/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableHelper;
import org.eclipse.core.runtime.Assert;

public class DetailObservableValue<M, T>
extends AbstractObservableValue<T>
implements IObserving {
    private final boolean updating = false;
    private IValueChangeListener<T> innerChangeListener = event -> this.fireValueChange(Diffs.unmodifiableDiff(event.diff));
    private M currentOuterValue;
    private IObservableValue<T> innerObservableValue;
    private final Object detailType;
    private IObservableValue<M> outerObservableValue;
    private IObservableFactory<? super M, IObservableValue<T>> factory;
    IValueChangeListener<M> outerChangeListener = event -> {
        if (this.isDisposed()) {
            return;
        }
        ObservableTracker.setIgnore(true);
        try {
            T oldValue = this.doGetValue();
            this.updateInnerObservableValue();
            this.fireValueChange(Diffs.createValueDiff(oldValue, this.doGetValue()));
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    };

    public DetailObservableValue(IObservableValue<M> outerObservableValue, IObservableFactory<? super M, IObservableValue<T>> factory, Object detailType) {
        super(outerObservableValue.getRealm());
        Assert.isTrue((!outerObservableValue.isDisposed() ? 1 : 0) != 0, (String)"Master observable is disposed");
        this.factory = factory;
        this.detailType = detailType;
        this.outerObservableValue = outerObservableValue;
        outerObservableValue.addDisposeListener(staleEvent -> this.dispose());
        ObservableTracker.setIgnore(true);
        try {
            this.updateInnerObservableValue();
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableValue() {
        this.currentOuterValue = this.outerObservableValue.getValue();
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableValue = null;
        } else {
            ObservableTracker.setIgnore(true);
            try {
                this.innerObservableValue = this.factory.createObservable(this.currentOuterValue);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
            DetailObservableHelper.warnIfDifferentRealms(this.getRealm(), this.innerObservableValue.getRealm());
            if (this.detailType != null) {
                Object innerValueType = this.innerObservableValue.getValueType();
                Assert.isTrue((boolean)this.detailType.equals(innerValueType), (String)("Cannot change value type in a nested observable value, from " + String.valueOf(innerValueType) + " to " + String.valueOf(this.detailType)));
            }
            this.innerObservableValue.addValueChangeListener(this.innerChangeListener);
        }
    }

    @Override
    public void doSetValue(T value) {
        if (this.innerObservableValue != null) {
            ObservableTracker.setIgnore(true);
            try {
                this.innerObservableValue.setValue(value);
            }
            finally {
                ObservableTracker.setIgnore(false);
            }
        }
    }

    @Override
    public T doGetValue() {
        if (this.innerObservableValue == null) {
            return null;
        }
        ObservableTracker.setIgnore(true);
        try {
            T t = this.innerObservableValue.getValue();
            return t;
        }
        finally {
            ObservableTracker.setIgnore(false);
        }
    }

    @Override
    public Object getValueType() {
        return this.detailType;
    }

    @Override
    public synchronized void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
        }
        if (this.innerObservableValue != null) {
            this.innerObservableValue.removeValueChangeListener(this.innerChangeListener);
            this.innerObservableValue.dispose();
        }
        this.outerObservableValue = null;
        this.outerChangeListener = null;
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableValue = null;
        this.innerChangeListener = null;
    }

    @Override
    public Object getObserved() {
        if (this.innerObservableValue instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableValue)).getObserved();
        }
        return null;
    }
}

