/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.spelling;

import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.internal.ui.text.CPreprocessorScanner;
import org.eclipse.cdt.internal.ui.text.FastCPartitioner;
import org.eclipse.cdt.internal.ui.text.doctools.DocCommentSpellDictionary;
import org.eclipse.cdt.internal.ui.text.spelling.SpellCheckIterator;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingEngine;
import org.eclipse.cdt.internal.ui.text.spelling.SpellingPreferences;
import org.eclipse.cdt.internal.ui.text.spelling.engine.ISpellChecker;
import org.eclipse.cdt.ui.text.ITokenStore;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.cdt.ui.text.doctools.IDocCommentDictionary;
import org.eclipse.cdt.ui.text.doctools.IDocCommentOwner;
import org.eclipse.cdt.ui.text.doctools.IDocCommentSimpleDictionary;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;

public class CSpellingEngine
extends SpellingEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellingEngine.SpellEventListener listener = new SpellingEngine.SpellEventListener(collector, document);
        boolean isIgnoringStringLiterals = SpellingPreferences.isIgnoreStringLiterals();
        DocCommentSpellDictionary toRemove = null;
        try {
            IDocumentPartitioner partitioner;
            checker.addListener(listener);
            IDocCommentOwner owner = null;
            if (document instanceof IDocumentExtension3 && (partitioner = ((IDocumentExtension3)document).getDocumentPartitioner("___c_partitioning")) instanceof FastCPartitioner) {
                owner = ((FastCPartitioner)partitioner).getDocCommentOwner();
            }
            try {
                int i = 0;
                while (i < regions.length) {
                    IRegion region = regions[i];
                    ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)"___c_partitioning", (int)region.getOffset(), (int)region.getLength(), (boolean)false);
                    int index = 0;
                    while (index < partitions.length) {
                        if (monitor != null && monitor.isCanceled()) {
                            return;
                        }
                        ITypedRegion partition = partitions[index];
                        String type = partition.getType();
                        if (!isIgnoringStringLiterals || !type.equals("__c_string")) {
                            if (owner != null) {
                                IDocCommentDictionary dict = null;
                                if (type.equals("__c_multiline_doc_comment")) {
                                    dict = owner.getMultilineConfiguration().getSpellingDictionary();
                                } else if (type.equals("__c_singleline_doc_comment")) {
                                    dict = owner.getSinglelineConfiguration().getSpellingDictionary();
                                }
                                if (dict instanceof IDocCommentSimpleDictionary) {
                                    DocCommentSpellDictionary sd = new DocCommentSpellDictionary((IDocCommentSimpleDictionary)dict);
                                    checker.addDictionary(sd);
                                    toRemove = sd;
                                }
                            }
                            if (!type.equals("__c_preprocessor")) {
                                if (!type.equals("__dftl_partition_content_type") && !type.equals("__c_character")) {
                                    checker.execute(new SpellCheckIterator(document, (IRegion)partition, checker.getLocale()));
                                }
                            } else {
                                IToken token;
                                CPreprocessorScanner scanner = new CPreprocessorScanner(new ITokenStoreFactory(){

                                    @Override
                                    public ITokenStore createTokenStore(String[] propertyColorNames) {
                                        return new SimpleTokenStore();
                                    }
                                }, (ICLanguageKeywords)GPPLanguage.getDefault());
                                scanner.setRange(document, partition.getOffset(), partition.getLength());
                                int firstTokenOffset = -1;
                                int firstTokenLength = -1;
                                while (!(token = scanner.nextToken()).isEOF()) {
                                    if (!token.isOther()) continue;
                                    int offset = scanner.getTokenOffset();
                                    int length = scanner.getTokenLength();
                                    if (firstTokenOffset < 0) {
                                        firstTokenOffset = offset;
                                        firstTokenLength = length;
                                    }
                                    String subregionType = null;
                                    char c = document.getChar(offset);
                                    if (c == '\"') {
                                        if (!isIgnoringStringLiterals && !this.isIncludeDirective(document, firstTokenOffset, firstTokenLength)) {
                                            subregionType = "__c_string";
                                        }
                                    } else if (c == '/' && length >= 2) {
                                        c = document.getChar(offset + 1);
                                        if (c == '/') {
                                            subregionType = "__c_singleline_comment";
                                        } else if (c == '*') {
                                            subregionType = "__c_multiline_comment";
                                        }
                                    }
                                    if (subregionType == null) continue;
                                    TypedRegion subregion = new TypedRegion(offset, length, subregionType);
                                    checker.execute(new SpellCheckIterator(document, (IRegion)subregion, checker.getLocale()));
                                }
                            }
                            if (toRemove != null) {
                                checker.removeDictionary(toRemove);
                                toRemove = null;
                            }
                        }
                        ++index;
                    }
                    ++i;
                }
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
        finally {
            if (toRemove != null) {
                checker.removeDictionary(toRemove);
            }
            checker.removeListener(listener);
        }
    }

    private boolean isIncludeDirective(IDocument document, int offset, int length) throws BadLocationException {
        while (length > 0) {
            char c = document.getChar(offset);
            if (c == '#' || Character.isWhitespace(c)) {
                ++offset;
                --length;
                continue;
            }
            if (c != 'i') break;
            return document.get(offset, length).startsWith("include");
        }
        return false;
    }

    private static class SimpleTokenStore
    implements ITokenStore {
        private SimpleTokenStore() {
        }

        @Override
        public void ensureTokensInitialised() {
        }

        @Override
        public IPreferenceStore getPreferenceStore() {
            return null;
        }

        @Override
        public IToken getToken(String property) {
            return new Token((Object)property);
        }

        @Override
        public void adaptToPreferenceChange(PropertyChangeEvent event) {
        }

        @Override
        public boolean affectsBehavior(PropertyChangeEvent event) {
            return false;
        }
    }
}

