/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.TypeValidator;
import com.google.javascript.jscomp.graph.StandardUnionFind;
import com.google.javascript.jscomp.graph.UnionFind;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;

class DisambiguateProperties
implements CompilerPass {
    private static final int MAX_INVALIDATION_WARNINGS_PER_PROPERTY = 10;
    private static final Logger logger = Logger.getLogger(DisambiguateProperties.class.getName());
    private static final Pattern NONWORD_PATTERN = Pattern.compile("[^\\w$]");
    private final AbstractCompiler compiler;
    private final Set<JSType> invalidatingTypes;
    private final JSTypeRegistry registry;
    private final ObjectType BOTTOM_OBJECT;
    private Multimap<Object, JSError> invalidationMap;
    private final Map<String, CheckLevel> propertiesToErrorFor;
    private Map<FunctionType, Iterable<ObjectType>> implementedInterfaces;
    private Map<String, IdentityHashMap<JSType, ObjectType>> gtwpCache;
    private Map<String, Property> properties = new HashMap<String, Property>();

    private ObjectType gtwpCacheGet(String field, JSType type) {
        IdentityHashMap<JSType, ObjectType> m = this.gtwpCache.get(field);
        return m == null ? null : m.get(type);
    }

    private void gtwpCachePut(String field, JSType type, ObjectType top) {
        IdentityHashMap<JSType, ObjectType> m = this.gtwpCache.get(field);
        if (m == null) {
            m = new IdentityHashMap();
            this.gtwpCache.put(field, m);
        }
        Preconditions.checkState((null == m.put(type, top) ? 1 : 0) != 0);
    }

    DisambiguateProperties(AbstractCompiler compiler, Map<String, CheckLevel> propertiesToErrorFor) {
        this.compiler = compiler;
        this.registry = compiler.getTypeRegistry();
        this.BOTTOM_OBJECT = this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE).toObjectType();
        this.invalidatingTypes = new HashSet<JSType>((Collection<JSType>)ImmutableSet.of((Object)this.registry.getNativeType(JSTypeNative.ALL_TYPE), (Object)this.registry.getNativeType(JSTypeNative.NO_OBJECT_TYPE), (Object)this.registry.getNativeType(JSTypeNative.NO_TYPE), (Object)this.registry.getNativeType(JSTypeNative.FUNCTION_PROTOTYPE), (Object)this.registry.getNativeType(JSTypeNative.FUNCTION_INSTANCE_TYPE), (Object)this.registry.getNativeType(JSTypeNative.OBJECT_PROTOTYPE), (Object[])new JSType[]{this.registry.getNativeType(JSTypeNative.TOP_LEVEL_PROTOTYPE), this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE)}));
        this.propertiesToErrorFor = propertiesToErrorFor;
        this.invalidationMap = !this.propertiesToErrorFor.isEmpty() ? LinkedHashMultimap.create() : null;
    }

    @Override
    public void process(Node externs, Node root) {
        Preconditions.checkState((this.compiler.getLifeCycleStage() == AbstractCompiler.LifeCycleStage.NORMALIZED ? 1 : 0) != 0);
        this.implementedInterfaces = new HashMap<FunctionType, Iterable<ObjectType>>();
        this.gtwpCache = new HashMap<String, IdentityHashMap<JSType, ObjectType>>();
        for (TypeValidator.TypeMismatch mis : this.compiler.getTypeMismatches()) {
            this.recordInvalidatingType(mis.typeA, mis.src);
            this.recordInvalidatingType(mis.typeB, mis.src);
        }
        for (TypeValidator.TypeMismatch mis : this.compiler.getImplicitInterfaceUses()) {
            this.recordInvalidatingType(mis.typeA, mis.src);
            this.recordInvalidatingType(mis.typeB, mis.src);
        }
        NodeTraversal.traverseEs6(this.compiler, externs, new FindExternProperties());
        NodeTraversal.traverseEs6(this.compiler, root, new FindRenameableProperties());
        this.renameProperties();
    }

    private void recordInvalidationError(JSType t, JSError error) {
        Collection errors;
        if (!t.isObject()) {
            return;
        }
        if (this.invalidationMap != null && (errors = this.invalidationMap.get((Object)t)).size() < 10) {
            errors.add(error);
        }
    }

    private void recordInvalidatingType(JSType type, JSError error) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            for (JSType alt : type.toMaybeUnionType().getAlternatesWithoutStructuralTyping()) {
                this.recordInvalidatingType(alt, error);
            }
        } else if (type.isEnumElementType()) {
            this.recordInvalidatingType(type.toMaybeEnumElementType().getPrimitiveType(), error);
        } else {
            this.addInvalidatingType(type);
            this.recordInvalidationError(type, error);
            ObjectType objType = ObjectType.cast(type);
            if (objType != null && objType.getImplicitPrototype() != null) {
                this.addInvalidatingType(objType.getImplicitPrototype());
                this.recordInvalidationError(objType.getImplicitPrototype(), error);
            }
            if (objType != null && objType.isConstructor() && objType.isFunctionType()) {
                this.addInvalidatingType(objType.toMaybeFunctionType().getInstanceType());
            }
        }
    }

    protected Property getProperty(String name) {
        if (!this.properties.containsKey(name)) {
            this.properties.put(name, new Property(name));
        }
        return this.properties.get(name);
    }

    void renameProperties() {
        int propsRenamed = 0;
        int propsSkipped = 0;
        int instancesRenamed = 0;
        int instancesSkipped = 0;
        int singleTypeProps = 0;
        HashSet<String> reported = new HashSet<String>();
        for (Property prop : this.properties.values()) {
            if (prop.shouldRename()) {
                UnionFind<JSType> pTypes = prop.getTypes();
                Map<JSType, String> propNames = this.buildPropNames(prop);
                ++propsRenamed;
                prop.expandTypesToSkip();
                for (Map.Entry<Node, JSType> entry : prop.rootTypesByNode.entrySet()) {
                    Node node = entry.getKey();
                    JSType rootType = entry.getValue();
                    if (prop.shouldRename(rootType)) {
                        String newName = propNames.get(pTypes.find(rootType));
                        node.setString(newName);
                        this.compiler.reportCodeChange();
                        ++instancesRenamed;
                        continue;
                    }
                    ++instancesSkipped;
                    CheckLevel checkLevelForProp = this.propertiesToErrorFor.get(prop.name);
                    if (checkLevelForProp == null || checkLevelForProp == CheckLevel.OFF || reported.contains(prop.name)) continue;
                    reported.add(prop.name);
                    this.compiler.report(JSError.make(node, checkLevelForProp, Warnings.INVALIDATION_ON_TYPE, prop.name, rootType.toString(), ""));
                }
                continue;
            }
            if (prop.skipRenaming) {
                ++propsSkipped;
                continue;
            }
            ++singleTypeProps;
        }
        logger.fine("Renamed " + instancesRenamed + " instances of " + propsRenamed + " properties.");
        logger.fine("Skipped renaming " + instancesSkipped + " invalidated " + "properties, " + propsSkipped + " instances of properties " + "that were skipped for specific types and " + singleTypeProps + " properties that were referenced from only one type.");
    }

    private Map<JSType, String> buildPropNames(Property prop) {
        UnionFind<JSType> pTypes = prop.getTypes();
        String pname = prop.name;
        HashMap<JSType, String> names = new HashMap<JSType, String>();
        for (Set<JSType> set : pTypes.allEquivalenceClasses()) {
            Preconditions.checkState((!set.isEmpty() ? 1 : 0) != 0);
            JSType representative = pTypes.find(set.iterator().next());
            String typeName = null;
            for (JSType type : set) {
                String typeString = type.toString();
                if (typeName != null && typeString.compareTo(typeName) >= 0) continue;
                typeName = typeString;
            }
            String newName = "{...}".equals(typeName) ? pname : NONWORD_PATTERN.matcher(typeName).replaceAll("_") + '$' + pname;
            names.put(representative, newName);
        }
        return names;
    }

    Multimap<String, Collection<JSType>> getRenamedTypesForTesting() {
        HashMultimap ret = HashMultimap.create();
        for (Map.Entry<String, Property> entry : this.properties.entrySet()) {
            Property prop = entry.getValue();
            if (prop.skipRenaming) continue;
            for (Collection collection : prop.getTypes().allEquivalenceClasses()) {
                if (collection.isEmpty() || prop.typesToSkip.contains(collection.iterator().next())) continue;
                ret.put((Object)entry.getKey(), (Object)collection);
            }
        }
        return ret;
    }

    private void addInvalidatingType(JSType type) {
        Preconditions.checkState((!type.isUnionType() ? 1 : 0) != 0);
        this.invalidatingTypes.add(type);
    }

    private JSType getType(Node node) {
        if (node.getJSType() == null) {
            return this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return node.getJSType();
    }

    private boolean isInvalidatingType(JSType type) {
        if (type == null || this.invalidatingTypes.contains(type) || type.isUnknownType()) {
            return true;
        }
        ObjectType objType = ObjectType.cast(type);
        return objType != null && !objType.hasReferenceName();
    }

    private ImmutableSet<JSType> getTypesToSkipForType(JSType type) {
        if ((type = type.restrictByNotNullOrUndefined()).isUnionType()) {
            ImmutableSet.Builder types = ImmutableSet.builder();
            types.add((Object)type);
            for (JSType alt : type.toMaybeUnionType().getAlternates()) {
                types.addAll(this.getTypesToSkipForTypeNonUnion(alt));
            }
            return types.build();
        }
        if (type.isEnumElementType()) {
            return this.getTypesToSkipForType(type.toMaybeEnumElementType().getPrimitiveType());
        }
        return ImmutableSet.copyOf(this.getTypesToSkipForTypeNonUnion(type));
    }

    private Set<JSType> getTypesToSkipForTypeNonUnion(JSType type) {
        HashSet<JSType> types = new HashSet<JSType>();
        JSType skipType = type;
        while (skipType != null) {
            types.add(skipType);
            ObjectType objSkipType = skipType.toObjectType();
            if (objSkipType == null) break;
            skipType = objSkipType.getImplicitPrototype();
        }
        return types;
    }

    private boolean isTypeToSkip(JSType type) {
        return type.isEnumType() || type.autoboxesTo() != null;
    }

    private Iterable<JSType> getTypeAlternatives(JSType type) {
        if (type.isUnionType()) {
            return type.toMaybeUnionType().getAlternatesWithoutStructuralTyping();
        }
        ObjectType objType = type.toObjectType();
        if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
            ArrayList<JSType> list = new ArrayList<JSType>();
            for (FunctionType impl : this.registry.getDirectImplementors(objType)) {
                list.add(impl.getInstanceType());
            }
            return list;
        }
        return null;
    }

    @VisibleForTesting
    ObjectType getTypeWithProperty(String field, JSType type) {
        ObjectType maybeType;
        if (type == null) {
            return null;
        }
        ObjectType foundType = this.gtwpCacheGet(field, type);
        if (foundType != null) {
            return foundType.equals(this.BOTTOM_OBJECT) ? null : foundType;
        }
        if (type.isEnumElementType()) {
            foundType = this.getTypeWithProperty(field, type.toMaybeEnumElementType().getPrimitiveType());
            this.gtwpCachePut(field, type, foundType == null ? this.BOTTOM_OBJECT : foundType);
            return foundType;
        }
        if (!(type instanceof ObjectType)) {
            if (type.autoboxesTo() != null) {
                foundType = this.getTypeWithProperty(field, type.autoboxesTo());
                this.gtwpCachePut(field, type, foundType == null ? this.BOTTOM_OBJECT : foundType);
                return foundType;
            }
            this.gtwpCachePut(field, type, this.BOTTOM_OBJECT);
            return null;
        }
        if ("prototype".equals(field)) {
            this.gtwpCachePut(field, type, this.BOTTOM_OBJECT);
            return null;
        }
        ObjectType objType = ObjectType.cast(type);
        if (objType != null && objType.getConstructor() != null && objType.getConstructor().isInterface()) {
            ObjectType topInterface = FunctionType.getTopDefiningInterface(objType, field);
            if (topInterface != null && topInterface.getConstructor() != null) {
                foundType = topInterface.getConstructor().getPrototype();
            }
        } else {
            while (objType != null && objType.getImplicitPrototype() != objType) {
                if (objType.hasOwnProperty(field)) {
                    foundType = objType;
                }
                objType = objType.getImplicitPrototype();
            }
        }
        if (foundType == null && (maybeType = ObjectType.cast(this.registry.getGreatestSubtypeWithProperty(type, field))) != null && maybeType.hasOwnProperty(field)) {
            foundType = maybeType;
        }
        if (foundType != null && foundType.isTemplatizedType()) {
            foundType = foundType.toMaybeTemplatizedType().getReferencedType();
        }
        if (foundType != null && foundType.isNamedType()) {
            foundType = foundType.toMaybeNamedType().getReferencedType().toMaybeObjectType();
        }
        this.gtwpCachePut(field, type, foundType == null ? this.BOTTOM_OBJECT : foundType);
        return foundType;
    }

    private JSType getInstanceFromPrototype(JSType type) {
        ObjectType prototype;
        FunctionType owner;
        if (type.isFunctionPrototypeType() && ((owner = (prototype = (ObjectType)type).getOwnerFunction()).isConstructor() || owner.isInterface())) {
            return prototype.getOwnerFunction().getInstanceType();
        }
        return null;
    }

    private void recordInterfaces(FunctionType constructor, JSType relatedType, Property p) {
        Preconditions.checkArgument((boolean)constructor.isConstructor());
        Iterable<ObjectType> interfaces = this.implementedInterfaces.get(constructor);
        if (interfaces == null) {
            interfaces = constructor.getImplementedInterfaces();
            this.implementedInterfaces.put(constructor, interfaces);
        }
        for (ObjectType itype : interfaces) {
            ObjectType top = this.getTypeWithProperty(p.name, itype);
            if (top != null) {
                p.addType(itype, relatedType);
            }
            if (!p.skipRenaming) continue;
            return;
        }
    }

    private FunctionType getConstructor(JSType type) {
        ObjectType objType = ObjectType.cast(type);
        if (objType == null) {
            return null;
        }
        FunctionType constructor = null;
        constructor = objType.isFunctionType() ? objType.toMaybeFunctionType() : (objType.isFunctionPrototypeType() ? objType.getOwnerFunction() : objType.getConstructor());
        return constructor != null && constructor.isConstructor() ? constructor : null;
    }

    private class FindExternProperties
    extends NodeTraversal.AbstractScopedCallback {
        private FindExternProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                String field = n.getLastChild().getString();
                JSType type = DisambiguateProperties.this.getType(n.getFirstChild());
                Property prop = DisambiguateProperties.this.getProperty(field);
                if (DisambiguateProperties.this.isInvalidatingType(type) || this.isStructuralInterfacePrototype(type)) {
                    prop.invalidate();
                } else if (!prop.skipRenaming) {
                    prop.addTypeToSkip(type);
                    type = DisambiguateProperties.this.getInstanceFromPrototype(type);
                    if (type != null) {
                        prop.getTypes().add(type);
                        prop.typesToSkip.add(type);
                    }
                }
            }
        }

        private boolean isStructuralInterfacePrototype(JSType type) {
            return type.isFunctionPrototypeType() && type.toObjectType().getOwnerFunction().isStructuralInterface();
        }
    }

    private class FindRenameableProperties
    extends NodeTraversal.AbstractScopedCallback {
        private FindRenameableProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (n.isGetProp()) {
                this.handleGetProp(t, n);
            } else if (n.isObjectLit()) {
                this.handleObjectLit(t, n);
            }
        }

        private void handleGetProp(NodeTraversal t, Node n) {
            String name = n.getLastChild().getString();
            JSType type = DisambiguateProperties.this.getType(n.getFirstChild());
            Property prop = DisambiguateProperties.this.getProperty(name);
            if (!prop.scheduleRenaming(n.getLastChild(), this.processProperty(t, prop, type, null)) && DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) {
                String suggestion = "";
                if (type instanceof JSType) {
                    JSType jsType = type;
                    if (jsType.isAllType() || jsType.isUnknownType()) {
                        if (n.getFirstChild().isThis()) {
                            suggestion = "The \"this\" object is unknown in the function,consider using @this";
                        } else {
                            String qName = n.getFirstChild().getQualifiedName();
                            suggestion = "Consider casting " + qName + " if you know its type.";
                        }
                    } else {
                        ArrayList<String> errors = new ArrayList<String>();
                        this.printErrorLocations(errors, jsType);
                        if (!errors.isEmpty()) {
                            suggestion = "Consider fixing errors for the following types:\n";
                            suggestion = suggestion + Joiner.on((String)"\n").join(errors);
                        }
                    }
                }
                DisambiguateProperties.this.compiler.report(JSError.make(n, (CheckLevel)((Object)DisambiguateProperties.this.propertiesToErrorFor.get(name)), Warnings.INVALIDATION, name, String.valueOf(type), n.toString(), suggestion));
            }
        }

        private void handleObjectLit(NodeTraversal t, Node n) {
            for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
                if (child.isQuotedString()) continue;
                String name = child.getString();
                JSType type = DisambiguateProperties.this.getType(n);
                Property prop = DisambiguateProperties.this.getProperty(name);
                if (prop.scheduleRenaming(child, this.processProperty(t, prop, type, null)) || !DisambiguateProperties.this.propertiesToErrorFor.containsKey(name)) continue;
                DisambiguateProperties.this.compiler.report(JSError.make(child, (CheckLevel)((Object)DisambiguateProperties.this.propertiesToErrorFor.get(name)), Warnings.INVALIDATION, name, String.valueOf(type), n.toString(), ""));
            }
        }

        private void printErrorLocations(List<String> errors, JSType t) {
            if (!t.isObject() || t.isAllType()) {
                return;
            }
            if (t.isUnionType()) {
                for (JSType alt : t.toMaybeUnionType().getAlternates()) {
                    this.printErrorLocations(errors, alt);
                }
                return;
            }
            for (JSError error : DisambiguateProperties.this.invalidationMap.get((Object)t)) {
                errors.add(t + " at " + error.sourceName + ":" + error.lineNumber);
            }
        }

        private JSType processProperty(NodeTraversal t, Property prop, JSType type, JSType relatedType) {
            type = type.restrictByNotNullOrUndefined();
            if (prop.skipRenaming || DisambiguateProperties.this.isInvalidatingType(type)) {
                return null;
            }
            Iterable alternatives = DisambiguateProperties.this.getTypeAlternatives(type);
            if (alternatives != null) {
                JSType firstType = relatedType;
                for (JSType subType : alternatives) {
                    JSType lastType = this.processProperty(t, prop, subType, firstType);
                    if (lastType == null) continue;
                    firstType = firstType == null ? lastType : firstType;
                }
                return firstType;
            }
            ObjectType topType = DisambiguateProperties.this.getTypeWithProperty(prop.name, type);
            if (DisambiguateProperties.this.isInvalidatingType(topType)) {
                return null;
            }
            prop.addType(type, relatedType);
            return topType;
        }
    }

    private class Property {
        final String name;
        private UnionFind<JSType> types;
        Set<JSType> typesToSkip = new HashSet<JSType>();
        boolean skipRenaming;
        Map<Node, JSType> rootTypesByNode = new HashMap<Node, JSType>();
        private final Set<JSType> recordInterfacesCache = new HashSet<JSType>();

        Property(String name) {
            this.name = name;
        }

        UnionFind<JSType> getTypes() {
            if (this.types == null) {
                this.types = new StandardUnionFind<JSType>();
            }
            return this.types;
        }

        void addType(JSType type, JSType relatedType) {
            Preconditions.checkState((!this.skipRenaming ? 1 : 0) != 0, (String)"Attempt to record skipped property: %s", (Object[])new Object[]{this.name});
            ObjectType top = DisambiguateProperties.this.getTypeWithProperty(this.name, type);
            if (DisambiguateProperties.this.isInvalidatingType(top)) {
                this.invalidate();
                return;
            }
            if (DisambiguateProperties.this.isTypeToSkip(top)) {
                this.addTypeToSkip(top);
            }
            if (relatedType == null) {
                this.getTypes().add(top);
            } else {
                this.getTypes().union(top, relatedType);
            }
            FunctionType constructor = DisambiguateProperties.this.getConstructor(type);
            if (constructor != null && this.recordInterfacesCache.add(type)) {
                DisambiguateProperties.this.recordInterfaces(constructor, top, this);
            }
        }

        void addTypeToSkip(JSType type) {
            for (JSType skipType : DisambiguateProperties.this.getTypesToSkipForType(type)) {
                this.typesToSkip.add(skipType);
                this.getTypes().union(skipType, type);
            }
        }

        void expandTypesToSkip() {
            block4: {
                int originalTypesSize;
                if (!this.shouldRename()) break block4;
                int count = 0;
                do {
                    Preconditions.checkState((++count < 10 ? 1 : 0) != 0, (Object)"Stuck in loop expanding types to skip.");
                    HashSet<JSType> rootTypesToSkip = new HashSet<JSType>();
                    for (JSType subType : this.typesToSkip) {
                        rootTypesToSkip.add(this.types.find(subType));
                    }
                    this.typesToSkip.addAll(rootTypesToSkip);
                    HashSet<JSType> newTypesToSkip = new HashSet<JSType>();
                    Set<JSType> allTypes = this.types.elements();
                    originalTypesSize = allTypes.size();
                    for (JSType subType : allTypes) {
                        if (this.typesToSkip.contains(subType) || !this.typesToSkip.contains(this.types.find(subType))) continue;
                        newTypesToSkip.add(subType);
                    }
                    for (JSType newType : newTypesToSkip) {
                        this.addTypeToSkip(newType);
                    }
                } while (this.types.elements().size() != originalTypesSize);
            }
        }

        boolean shouldRename() {
            return !this.skipRenaming && this.types != null && this.types.allEquivalenceClasses().size() > 1;
        }

        boolean shouldRename(JSType type) {
            return !this.skipRenaming && !this.typesToSkip.contains(type);
        }

        boolean invalidate() {
            boolean changed = !this.skipRenaming;
            this.skipRenaming = true;
            this.types = null;
            this.typesToSkip = null;
            this.rootTypesByNode = null;
            return changed;
        }

        boolean scheduleRenaming(Node node, JSType type) {
            if (!this.skipRenaming) {
                if (DisambiguateProperties.this.isInvalidatingType(type)) {
                    this.invalidate();
                    return false;
                }
                this.rootTypesByNode.put(node, type);
            }
            return true;
        }
    }

    static class Warnings {
        static final DiagnosticType INVALIDATION = DiagnosticType.disabled("JSC_INVALIDATION", "Property disambiguator skipping all instances of property {0} because of type {1} node {2}. {3}");
        static final DiagnosticType INVALIDATION_ON_TYPE = DiagnosticType.disabled("JSC_INVALIDATION_TYPE", "Property disambiguator skipping instances of property {0} on type {1}. {2}");

        Warnings() {
        }
    }
}

