/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.rule;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.oniguruma.OnigCaptureIndex;
import org.eclipse.tm4e.core.internal.rule.CaptureRule;
import org.eclipse.tm4e.core.internal.rule.CompilePatternsResult;
import org.eclipse.tm4e.core.internal.rule.CompiledRule;
import org.eclipse.tm4e.core.internal.rule.IRuleRegistry;
import org.eclipse.tm4e.core.internal.rule.RegExpSource;
import org.eclipse.tm4e.core.internal.rule.RegExpSourceList;
import org.eclipse.tm4e.core.internal.rule.Rule;
import org.eclipse.tm4e.core.internal.rule.RuleId;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;

public final class BeginEndRule
extends Rule {
    private final RegExpSource begin;
    public final List<@Nullable CaptureRule> beginCaptures;
    private final RegExpSource end;
    public final List<@Nullable CaptureRule> endCaptures;
    public final boolean endHasBackReferences;
    private final boolean applyEndPatternLast;
    final boolean hasMissingPatterns;
    final RuleId[] patterns;
    private @Nullable RegExpSourceList cachedCompiledPatterns;

    BeginEndRule(RuleId id, @Nullable String name, @Nullable String contentName, String begin, List<@Nullable CaptureRule> beginCaptures, @Nullable String end, List<@Nullable CaptureRule> endCaptures, boolean applyEndPatternLast, CompilePatternsResult patterns, @Nullable String grammarScope) {
        super(id, name, contentName, grammarScope);
        this.begin = new RegExpSource(begin, this.id);
        this.beginCaptures = beginCaptures;
        this.end = new RegExpSource(NullSafetyHelper.defaultIfNull(end, "\uffff"), RuleId.END_RULE);
        this.endHasBackReferences = this.end.hasBackReferences;
        this.endCaptures = endCaptures;
        this.applyEndPatternLast = applyEndPatternLast;
        this.patterns = patterns.patterns;
        this.hasMissingPatterns = patterns.hasMissingPatterns;
    }

    public String debugBeginRegExp() {
        return this.begin.getSource();
    }

    public String debugEndRegExp() {
        return this.end.getSource();
    }

    public String getEndWithResolvedBackReferences(CharSequence lineText, OnigCaptureIndex[] captureIndices) {
        return this.end.resolveBackReferences(lineText, captureIndices);
    }

    @Override
    public void collectPatterns(IRuleRegistry grammar, RegExpSourceList out) {
        out.add(this.begin);
    }

    @Override
    public CompiledRule compile(IRuleRegistry grammar, @Nullable String endRegexSource) {
        return this.getCachedCompiledPatterns(grammar, endRegexSource).compile();
    }

    @Override
    public CompiledRule compileAG(IRuleRegistry grammar, @Nullable String endRegexSource, boolean allowA, boolean allowG) {
        return this.getCachedCompiledPatterns(grammar, endRegexSource).compileAG(allowA, allowG);
    }

    private RegExpSourceList getCachedCompiledPatterns(IRuleRegistry grammar, @Nullable String endRegexSource) {
        RegExpSourceList cachedCompiledPatterns = this.cachedCompiledPatterns;
        if (cachedCompiledPatterns == null) {
            cachedCompiledPatterns = new RegExpSourceList();
            RuleId[] ruleIdArray = this.patterns;
            int n = this.patterns.length;
            int n2 = 0;
            while (n2 < n) {
                RuleId pattern = ruleIdArray[n2];
                Rule rule = grammar.getRule(pattern);
                rule.collectPatterns(grammar, cachedCompiledPatterns);
                ++n2;
            }
            if (this.applyEndPatternLast) {
                cachedCompiledPatterns.add(this.endHasBackReferences ? this.end.clone() : this.end);
            } else {
                cachedCompiledPatterns.remove(this.endHasBackReferences ? this.end.clone() : this.end);
            }
            this.cachedCompiledPatterns = cachedCompiledPatterns;
        }
        if (this.endHasBackReferences && endRegexSource != null) {
            if (this.applyEndPatternLast) {
                cachedCompiledPatterns.setSource(cachedCompiledPatterns.length() - 1, endRegexSource);
            } else {
                cachedCompiledPatterns.setSource(0, endRegexSource);
            }
        }
        return cachedCompiledPatterns;
    }
}

