/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator.methodparam;

import java.util.Optional;
import java.util.function.Function;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.apidef.ApiFunction;
import org.eclipse.scout.sdk.core.java.apidef.IApiSpecification;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.JavaBuilderContextFunction;
import org.eclipse.scout.sdk.core.java.builder.member.IMemberBuilder;
import org.eclipse.scout.sdk.core.java.builder.member.MemberBuilder;
import org.eclipse.scout.sdk.core.java.generator.AbstractAnnotatableGenerator;
import org.eclipse.scout.sdk.core.java.generator.methodparam.IMethodParameterGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.Strings;

public class MethodParameterGenerator<TYPE extends IMethodParameterGenerator<TYPE>>
extends AbstractAnnotatableGenerator<TYPE>
implements IMethodParameterGenerator<TYPE> {
    private boolean m_isFinal;
    private boolean m_isVarargs;
    private JavaBuilderContextFunction<String> m_dataType;

    protected MethodParameterGenerator() {
    }

    protected MethodParameterGenerator(IMethodParameter parameter, IWorkingCopyTransformer transformer) {
        super(parameter, transformer);
        IMethod declaringMethod = parameter.declaringMethod();
        boolean isVarargs = Flags.isVarargs(declaringMethod.flags()) && (long)parameter.index() == declaringMethod.parameters().stream().count() - 1L;
        String dataType = parameter.dataType().reference();
        if (isVarargs) {
            dataType = dataType.substring(0, dataType.length() - 2);
        }
        this.asFinal(Flags.isFinal(parameter.flags())).asVarargs(isVarargs).withDataType(dataType);
    }

    public static IMethodParameterGenerator<?> create() {
        return new MethodParameterGenerator();
    }

    public static IMethodParameterGenerator<?> create(IMethodParameter parameter, IWorkingCopyTransformer transformer) {
        return new MethodParameterGenerator(parameter, transformer);
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        super.build(builder);
        this.createParameterSource(MemberBuilder.create(builder));
    }

    protected void createParameterSource(IMemberBuilder<?> builder) {
        if (this.isFinal()) {
            builder.appendFlags(16);
        }
        String dataType = this.dataTypeFunc().orElseThrow(() -> Ensure.newFail((CharSequence)"Method parameter data type missing for generator {}", (Object[])new Object[]{this})).apply(builder.context());
        builder.ref(dataType);
        if (this.isVarargs()) {
            builder.append("...");
        }
        String parameterName = MethodParameterGenerator.ensureValidJavaName(this.elementName(builder.context()).orElseThrow(() -> Ensure.newFail((CharSequence)"Method parameter name missing for generator {}", (Object[])new Object[]{this})));
        ((IMemberBuilder)builder.space()).append(parameterName);
    }

    @Override
    protected String annotationDelimiter(ISourceBuilder<?> builder) {
        return String.valueOf(' ');
    }

    @Override
    public Optional<String> dataType() {
        return this.dataTypeFunc().flatMap(JavaBuilderContextFunction::apply);
    }

    @Override
    public Optional<String> dataType(IJavaBuilderContext context) {
        return this.dataTypeFunc().map(f -> (String)f.apply(context));
    }

    @Override
    public Optional<JavaBuilderContextFunction<String>> dataTypeFunc() {
        return Optional.ofNullable(this.m_dataType);
    }

    @Override
    public TYPE withDataType(String dataType) {
        this.m_dataType = JavaBuilderContextFunction.orNull(dataType);
        return (TYPE)((IMethodParameterGenerator)this.thisInstance());
    }

    @Override
    public <A extends IApiSpecification> TYPE withDataTypeFrom(Class<A> apiDefinition, Function<A, String> dataTypeSupplier) {
        this.m_dataType = new ApiFunction<A, String>(apiDefinition, dataTypeSupplier);
        return (TYPE)((IMethodParameterGenerator)this.thisInstance());
    }

    @Override
    public TYPE withDataTypeFunc(Function<IJavaBuilderContext, String> dataTypeSupplier) {
        this.m_dataType = JavaBuilderContextFunction.orNull(dataTypeSupplier);
        return (TYPE)((IMethodParameterGenerator)this.thisInstance());
    }

    @Override
    public boolean isFinal() {
        return this.m_isFinal;
    }

    @Override
    public TYPE asFinal() {
        return this.asFinal(true);
    }

    @Override
    public TYPE notFinal() {
        return this.asFinal(false);
    }

    @Override
    public TYPE asFinal(boolean newFinalValue) {
        this.m_isFinal = newFinalValue;
        return (TYPE)((IMethodParameterGenerator)this.thisInstance());
    }

    @Override
    public boolean isVarargs() {
        return this.m_isVarargs;
    }

    @Override
    public TYPE asVarargs() {
        return this.asVarargs(true);
    }

    @Override
    public TYPE notVarargs() {
        return this.asVarargs(false);
    }

    @Override
    public TYPE asVarargs(boolean newVarargsValue) {
        this.m_isVarargs = newVarargsValue;
        return (TYPE)((IMethodParameterGenerator)this.thisInstance());
    }

    @Override
    public String reference(IJavaBuilderContext context) {
        return this.reference(context, false);
    }

    @Override
    public String reference(IJavaBuilderContext context, boolean useErasureOnly) {
        JavaBuilderContextFunction<String> dataTypeFunc = this.dataTypeFunc().orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot calculate the method parameter reference because the datatype is missing.", (Object[])new Object[0]));
        Object typeString = (String)Strings.notEmpty((CharSequence)dataTypeFunc.apply(context)).orElseThrow(() -> Ensure.newFail((CharSequence)"Cannot compute parameter data type of method parameter '{}'.", (Object[])new Object[]{this.elementName(context).orElse(null)}));
        if (useErasureOnly) {
            typeString = JavaTypes.erasure((CharSequence)typeString);
        }
        if (this.isVarargs()) {
            typeString = (String)typeString + JavaTypes.arrayMarker();
        }
        return typeString;
    }
}

