/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.text;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.tm4e.registry.IGrammarDefinition;
import org.eclipse.tm4e.registry.IGrammarRegistryManager;
import org.eclipse.tm4e.registry.ITMScope;
import org.eclipse.tm4e.registry.TMEclipseRegistryPlugin;
import org.eclipse.tm4e.ui.text.ITMPartitionRegion;
import org.eclipse.tm4e.ui.text.ITMPartitioner;

public final class TMPartitions {
    private static final IContentType[] NO_CONTENT_TYPES = new IContentType[0];
    public static final String TM_PARTITIONING = "tm4e.partitioning";
    public static final String PARTITION_TYPE_PREFIX = "tm4e:";
    public static final String BASE_PARTITION_TYPE = "tm4e:base";

    public static boolean hasPartitioning(@Nullable IDocument doc) {
        IDocumentExtension3 ext3;
        return doc instanceof IDocumentExtension3 && (ext3 = (IDocumentExtension3)doc).getDocumentPartitioner(TM_PARTITIONING) != null;
    }

    public static @Nullable ITMPartitionRegion getPartition(IDocument doc, int offset) {
        IDocumentExtension3 ext3;
        IDocumentPartitioner iDocumentPartitioner;
        if (doc instanceof IDocumentExtension3 && (iDocumentPartitioner = (ext3 = (IDocumentExtension3)doc).getDocumentPartitioner(TM_PARTITIONING)) instanceof ITMPartitioner) {
            ITMPartitioner tmPartitioner = (ITMPartitioner)iDocumentPartitioner;
            return tmPartitioner.getPartition(offset);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static IContentType[] getContentTypesForOffset(IDocument doc, int offset) {
        void tmPart;
        ITMPartitionRegion part = TMPartitions.getPartition(doc, offset);
        if (part == null) {
            return NO_CONTENT_TYPES;
        }
        if (!(part instanceof ITMPartitionRegion)) {
            return NO_CONTENT_TYPES;
        }
        ITMPartitionRegion iTMPartitionRegion = part;
        String scopeName = tmPart.getGrammarScope();
        IGrammarRegistryManager mgr = TMEclipseRegistryPlugin.getGrammarRegistryManager();
        Collection cts = mgr.getContentTypesForScope(ITMScope.parse((String)scopeName));
        if (cts != null && !cts.isEmpty()) {
            return (IContentType[])cts.toArray(IContentType[]::new);
        }
        ArrayList result = new ArrayList();
        IGrammarDefinition[] iGrammarDefinitionArray = mgr.getDefinitions();
        int n = iGrammarDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Collection mapped;
            IGrammarDefinition def = iGrammarDefinitionArray[n2];
            ITMScope defScope = def.getScope();
            if (scopeName.equals(defScope.getName()) && (mapped = mgr.getContentTypesForScope(defScope)) != null && !mapped.isEmpty()) {
                result.addAll(mapped);
            }
            ++n2;
        }
        return result.isEmpty() ? NO_CONTENT_TYPES : (IContentType[])result.toArray(IContentType[]::new);
    }

    private TMPartitions() {
    }
}

