/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodData;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodWizard;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;

public class ImplementMethodInputPage
extends UserInputWizardPage {
    private ImplementMethodData data;
    private ContainerCheckedTreeViewer tree;

    public ImplementMethodInputPage(ImplementMethodData data, ImplementMethodWizard implementMethodRefactoringWizard) {
        super(Messages.ImplementMethodInputPage_PageTitle);
        this.setData(data);
    }

    public boolean canFlipToNextPage() {
        if (this.data.needParameterInput()) {
            return super.canFlipToNextPage();
        }
        return this.isPageComplete();
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.ImplementMethodInputPage_PageTitle);
        this.setMessage(Messages.ImplementMethodInputPage_Header);
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.createTree(comp);
        this.createFieldManagementButtonsComposite(comp);
        this.setControl((Control)comp);
        this.checkPage();
    }

    private Composite createFieldManagementButtonsComposite(Composite comp) {
        Composite btComp = new Composite(comp, 0);
        FillLayout layout = new FillLayout(512);
        layout.spacing = 4;
        btComp.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.verticalAlignment = 128;
        btComp.setLayoutData((Object)gd);
        Button selectAll = new Button(btComp, 8);
        selectAll.setText(Messages.ImplementMethodInputPage_SelectAll);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items;
                Object[] objectArray = items = ImplementMethodInputPage.this.data.getElements(null);
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object treeItem = objectArray[n2];
                    MethodToImplementConfig method = (MethodToImplementConfig)treeItem;
                    method.setChecked(true);
                    ImplementMethodInputPage.this.tree.setChecked(treeItem, true);
                    ++n2;
                }
                ImplementMethodInputPage.this.checkPage();
            }
        });
        Button deselectAll = new Button(btComp, 8);
        deselectAll.setText(Messages.ImplementMethodInputPage_DeselectAll);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items;
                Object[] objectArray = items = ImplementMethodInputPage.this.data.getElements(null);
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object treeItem = objectArray[n2];
                    MethodToImplementConfig method = (MethodToImplementConfig)treeItem;
                    method.setChecked(false);
                    ImplementMethodInputPage.this.tree.setChecked(treeItem, false);
                    ++n2;
                }
                ImplementMethodInputPage.this.checkPage();
            }
        });
        return btComp;
    }

    private void createTree(Composite comp) {
        this.tree = new ContainerCheckedTreeViewer(comp);
        this.tree.setContentProvider((IContentProvider)this.data);
        this.tree.setAutoExpandLevel(2);
        this.tree.setInput((Object)"");
        this.tree.getTree().setLayoutData((Object)new GridData(1808));
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MethodToImplementConfig config = (MethodToImplementConfig)event.getElement();
                config.setChecked(event.getChecked());
                ImplementMethodInputPage.this.checkPage();
            }
        });
        for (MethodToImplementConfig config : this.data.getMethodsToImplement()) {
            this.tree.setChecked((Object)config, config.isChecked());
        }
    }

    public IWizardPage getNextPage() {
        if (this.data.needParameterInput()) {
            return this.getWizard().getPageForConfig(this.data.getFirstConfigNeedingParameterNames());
        }
        return this.computeSuccessorPage();
    }

    public ImplementMethodWizard getWizard() {
        return (ImplementMethodWizard)super.getWizard();
    }

    public void setData(ImplementMethodData data) {
        this.data = data;
    }

    public ImplementMethodData getData() {
        return this.data;
    }

    private void checkPage() {
        if (this.data.getMethodsToImplement().size() > 0) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }
}

