/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.storage.GitFileRevision;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.jgit.lib.Repository;

public class WorkspaceFileRevision
extends GitFileRevision {
    private final IResource rsrc;

    public static WorkspaceFileRevision forFile(Repository repository, IResource resource) {
        IPath path = ResourceUtil.getRepositoryRelativePath(resource.getLocation(), repository);
        String repoRelativePath = path == null ? null : path.toString();
        return new WorkspaceFileRevision(repository, repoRelativePath, resource);
    }

    public WorkspaceFileRevision(Repository repository, String path, IResource resource) {
        super(repository, path);
        this.rsrc = resource;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
        return this.rsrc instanceof IStorage ? (IStorage)this.rsrc : null;
    }

    @Override
    public boolean isPropertyMissing() {
        return false;
    }

    public String getAuthor() {
        return "";
    }

    public long getTimestamp() {
        return -1L;
    }

    public String getComment() {
        return "";
    }

    public String getContentIdentifier() {
        return "Workspace";
    }

    @Override
    public GitInfo.Source getSource() {
        return GitInfo.Source.WORKING_TREE;
    }
}

