/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.scout.sdk.core.java.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.java.ecj.JreInfo;
import org.eclipse.scout.sdk.core.log.SdkLog;

public class ClasspathBuilder {
    private static final Map<Path, JreInfo> JRE_INFOS = new ConcurrentHashMap<Path, JreInfo>();
    private final List<FileSystem.Classpath> m_full;
    private final List<FileSystem.Classpath> m_bootClasspath;
    private final Collection<FileSystem.Classpath> m_classpath;
    private final Set<ClasspathEntry> m_entries;
    private final JreInfo m_jreInfo;

    protected ClasspathBuilder(Path jreHome, Collection<? extends ClasspathEntry> paths) {
        Path javaHome = Optional.ofNullable(jreHome).orElseGet(JreInfo::runningJavaHome).normalize();
        this.m_jreInfo = JRE_INFOS.computeIfAbsent(javaHome, JreInfo::new);
        Map<ClasspathEntry, FileSystem.Classpath> classpath = this.toClasspath(paths);
        this.m_entries = classpath.keySet();
        this.m_classpath = classpath.values();
        this.m_bootClasspath = ClasspathBuilder.createBootClasspathFor(this.m_jreInfo);
        ArrayList<FileSystem.Classpath> fullCp = new ArrayList<FileSystem.Classpath>(this.m_classpath.size() + this.m_bootClasspath.size());
        fullCp.addAll(this.m_classpath);
        fullCp.addAll(this.m_bootClasspath);
        this.m_full = fullCp;
    }

    public List<FileSystem.Classpath> fullClasspath() {
        return this.m_full;
    }

    public List<FileSystem.Classpath> bootClasspath() {
        return this.m_bootClasspath;
    }

    public Collection<FileSystem.Classpath> userClasspath() {
        return this.m_classpath;
    }

    public Set<ClasspathEntry> userClasspathEntries() {
        return this.m_entries;
    }

    public JreInfo jreInfo() {
        return this.m_jreInfo;
    }

    private static List<FileSystem.Classpath> createBootClasspathFor(JreInfo jre) {
        ArrayList<FileSystem.Classpath> result = new ArrayList<FileSystem.Classpath>();
        Path jreHome = jre.jreHome();
        Path rtSrcZip = jre.rtSrcZip();
        if (jre.supportsJrtModules()) {
            SdkLog.debug((CharSequence)"Boot Classpath uses binary JRT modules of Java home: {}.", (Object[])new Object[]{jreHome});
            result.add(FileSystem.getJrtClasspath((String)jreHome.toString(), null, null, null));
        } else {
            SdkLog.debug((CharSequence)"Using Boot Classpath based on the jars in the lib folder of Java home: {}.", (Object[])new Object[]{jreHome});
            ClasspathBuilder.appendSrcClasspathToEnd(result, rtSrcZip, null);
            for (Path cpEntry : jre.bootClasspath()) {
                ClasspathBuilder.appendBinClasspathToEnd(result, cpEntry);
            }
        }
        return result;
    }

    private Map<ClasspathEntry, FileSystem.Classpath> toClasspath(Collection<? extends ClasspathEntry> paths) {
        LinkedHashMap<ClasspathEntry, FileSystem.Classpath> result = new LinkedHashMap<ClasspathEntry, FileSystem.Classpath>(paths.size());
        String version = this.jreInfo().version();
        if ("1.8".equals(version)) {
            version = null;
        }
        for (ClasspathEntry classpathEntry : paths) {
            FileSystem.Classpath classpath;
            if (result.containsKey(classpathEntry) || (classpath = ClasspathBuilder.toClasspath(classpathEntry.path(), classpathEntry.mode() == 1, classpathEntry.encoding(), version)) == null) continue;
            result.put(classpathEntry, classpath);
        }
        return result;
    }

    private static void appendBinClasspathToEnd(Collection<FileSystem.Classpath> collector, Path f) {
        ClasspathBuilder.appendClasspathToEnd(collector, f, false, null);
    }

    private static void appendSrcClasspathToEnd(Collection<FileSystem.Classpath> collector, Path f, String encoding) {
        ClasspathBuilder.appendClasspathToEnd(collector, f, true, encoding);
    }

    private static void appendClasspathToEnd(Collection<FileSystem.Classpath> collector, Path f, boolean isSourceOnly, String encoding) {
        FileSystem.Classpath cp = ClasspathBuilder.toClasspath(f, isSourceOnly, encoding, null);
        if (cp == null) {
            return;
        }
        collector.add(cp);
    }

    private static FileSystem.Classpath toClasspath(Path f, boolean isSourceOnly, String encoding, String release) {
        if (f == null || !Files.isReadable(f)) {
            return null;
        }
        return FileSystem.getClasspath((String)f.toString(), (String)encoding, (boolean)isSourceOnly, null, null, null, (String)release);
    }
}

