/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.wellform;

import java.util.Set;
import java.util.function.BiConsumer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.operation.wellform.WellformScoutTypeOperation;
import org.eclipse.scout.sdk.s2e.ui.util.S2eUiUtils;

public class WellformSelectedHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) {
        Set<IType> types = S2eUiUtils.getTypesInEventSelection(event);
        if (types.isEmpty()) {
            WellformSelectedHandler.logNoSelection();
            return null;
        }
        ISchedulingRule[] rules = (ISchedulingRule[])types.stream().map(IJavaElement::getResource).distinct().toArray(ISchedulingRule[]::new);
        MultiRule rule = new MultiRule(rules);
        EclipseEnvironment.runInEclipseEnvironment((BiConsumer)new WellformScoutTypeOperation(types, true), (ISchedulingRule)rule);
        return null;
    }

    private static void logNoSelection() {
        SdkLog.warning((CharSequence)"Cannot wellform classes in the selected scope because no classes are selected.", (Object[])new Object[0]);
    }
}

