/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.uri;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.urischeme.IUriSchemeHandler;

public class XDebugURISchemeHandler
implements IUriSchemeHandler {
    private static final String SCHEME = "://";

    public void handle(String uri) {
        IFileStore store;
        String[] split = uri.split(SCHEME, 2);
        if (split.length != 2) {
            return;
        }
        String fileName = split[1];
        int pos = fileName.lastIndexOf(64);
        if (pos == -1) {
            pos = fileName.lastIndexOf(58);
        }
        int lineNumber = 0;
        if (pos > 0) {
            fileName = fileName.substring(0, pos);
            lineNumber = Integer.valueOf(fileName.substring(pos + 1));
        }
        if ((store = EFS.getLocalFileSystem().getStore((IPath)new Path(fileName))).fetchInfo().exists() && !store.fetchInfo().isDirectory()) {
            OpenFile run = new OpenFile(store, lineNumber);
            if (Display.getCurrent() != null) {
                run.run();
            } else {
                Display.getDefault().asyncExec((Runnable)run);
            }
        }
    }

    private static class OpenFile
    implements Runnable {
        private IFileStore store;
        private int lineNumber;

        public OpenFile(IFileStore store, int lineNumber) {
            this.store = store;
            this.lineNumber = lineNumber;
        }

        @Override
        public void run() {
            IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
            try {
                IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)window.getActivePage(), (IFileStore)this.store);
                if (editor instanceof ITextEditor) {
                    ITextEditor textEditor = (ITextEditor)editor;
                    IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                    int lineStart = document.getLineOffset(this.lineNumber);
                    textEditor.selectAndReveal(lineStart, 0);
                }
            }
            catch (PartInitException e) {
                Logger.logException(e);
            }
            catch (BadLocationException e) {
                Logger.logException(e);
            }
        }
    }
}

