/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.core.data;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Pattern;

public class ProfilerFunctionData {
    private static final Pattern EVALD_CODE_PATTERN = Pattern.compile(".*\\(\\d+\\) : eval\\(\\)'d code");
    private String fFileName;
    private String fLocalFileName;
    private String fAbsoluteFileName;
    private String fFunctionName;
    private String fClassName;
    private int fLineNumber;
    private int fID;
    private int fOwnTimeSeconds;
    private int fOwnTimeMicroseconds;
    private int fTotalTimeSeconds;
    private int fTotalTimeMicroseconds;
    private int fCallsCount;
    private double CONVERTION = 1000000.0;

    public ProfilerFunctionData() {
    }

    public ProfilerFunctionData(String fileName) {
        this.setFileName(fileName);
    }

    public ProfilerFunctionData(String fileName, String functionName, int lineNumber, int calledID, int ownSecond, int ownMicorsecond, int totalSecond, int totalMicorsecond, int callCount) {
        this.setFileName(fileName);
        this.setFunctionName(functionName);
        this.setLineNumber(lineNumber);
        this.setID(calledID);
        this.setOwnTimeSeconds(ownSecond);
        this.setOwnTimeMicroseconds(ownMicorsecond);
        this.setTotalTimeSeconds(totalSecond);
        this.setTotalTimeMicroseconds(totalMicorsecond);
        this.setCallsCount(callCount);
    }

    public void setFunctionName(String functionName) {
        if (EVALD_CODE_PATTERN.matcher(functionName).matches()) {
            this.fFunctionName = "eval()";
        } else {
            int i = functionName.indexOf("::");
            if (i != -1) {
                this.setClassName(functionName.substring(0, i));
                this.fFunctionName = functionName.substring(i + 2);
            } else {
                this.fFunctionName = functionName;
            }
        }
    }

    public void setClassName(String className) {
        this.fClassName = className;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public String getClassName() {
        return this.fClassName;
    }

    public void setFileName(String fileName) {
        Path p = Paths.get(fileName, new String[0]);
        this.fFileName = p.getFileName().toString();
        this.fAbsoluteFileName = fileName;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public void setLocalFileName(String name) {
        this.fLocalFileName = name;
    }

    public String getLocalFileName() {
        if (this.fLocalFileName == null) {
            return this.fAbsoluteFileName;
        }
        return this.fLocalFileName;
    }

    public String getAbsoluteFileName() {
        return this.fAbsoluteFileName;
    }

    public void setLineNumber(int lineNumber) {
        this.fLineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public void setID(int id) {
        this.fID = id;
    }

    public int getID() {
        return this.fID;
    }

    public void setOwnTimeSeconds(int ownTimeSeconds) {
        this.fOwnTimeSeconds = ownTimeSeconds;
    }

    public int getOwnTimeSeconds() {
        return this.fOwnTimeSeconds;
    }

    public void setOwnTimeMicroseconds(int ownTimeMicroseconds) {
        this.fOwnTimeMicroseconds = ownTimeMicroseconds;
    }

    public int getOwnTimeMicroseconds() {
        return this.fOwnTimeMicroseconds;
    }

    public void setTotalTimeSeconds(int totalTimeSeconds) {
        this.fTotalTimeSeconds = totalTimeSeconds;
    }

    public int getTotalTimeSeconds() {
        return this.fTotalTimeSeconds;
    }

    public void setTotalTimeMicroseconds(int totalTimeMicroseconds) {
        if (totalTimeMicroseconds == 0 && this.fTotalTimeSeconds == 0) {
            this.fTotalTimeSeconds = this.fOwnTimeSeconds;
            this.fTotalTimeMicroseconds = this.fOwnTimeMicroseconds;
        } else {
            this.fTotalTimeMicroseconds = totalTimeMicroseconds;
        }
    }

    public int getTotalTimeMicroseconds() {
        return this.fTotalTimeMicroseconds;
    }

    public void setCallsCount(int callsCount) {
        this.fCallsCount = callsCount;
    }

    public int getCallsCount() {
        return this.fCallsCount;
    }

    public double getTotalTime() {
        double totalTime = ((double)this.fTotalTimeSeconds * this.CONVERTION + (double)this.fTotalTimeMicroseconds) / this.CONVERTION;
        return totalTime;
    }

    public double getTotalTimeInMilli() {
        return this.getTotalTime() * 1000.0;
    }

    public double getOwnTime() {
        double ownTime = ((double)this.fOwnTimeSeconds * this.CONVERTION + (double)this.fOwnTimeMicroseconds) / this.CONVERTION;
        return ownTime;
    }

    public double getOwnTimeInMilli() {
        return this.getOwnTime() * 1000.0;
    }

    public String toString() {
        if (this.fClassName != null) {
            return String.valueOf(this.fClassName) + "::" + this.fFunctionName;
        }
        return this.fFunctionName;
    }
}

