/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.debug.core.model.IScriptLineBreakpoint;
import org.eclipse.dltk.internal.debug.core.model.AbstractScriptBreakpoint;

public class ScriptLineBreakpoint
extends AbstractScriptBreakpoint
implements IScriptLineBreakpoint {
    private static final String[] UPDATABLE_ATTRS = new String[]{"lineNumber", "org.eclipse.debug.core.enabled", "org.eclipse.dltk.debug.hit_condition", "org.eclipse.dltk.debug.hit_value", "org.eclipse.dltk.debug.expression", "org.eclipse.dltk.debug.expression.state"};

    protected String getMarkerId() {
        return "org.eclipse.dltk.debug.scriptLineBreakpointMarker";
    }

    protected void addLineBreakpointAttributes(Map<String, Object> attributes, IPath path, int lineNumber, int charStart, int charEnd) {
        if (path != null) {
            attributes.put("location", path.toPortableString());
        }
        attributes.put("lineNumber", lineNumber);
        attributes.put("charStart", charStart);
        attributes.put("charEnd", charEnd);
    }

    public ScriptLineBreakpoint() {
    }

    public ScriptLineBreakpoint(String debugModelId, IResource resource, IPath path, int lineNumber, int charStart, int charEnd, boolean add) throws DebugException {
        IWorkspaceRunnable wr = monitor -> {
            this.setMarker(resource.createMarker(this.getMarkerId()));
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            this.addScriptBreakpointAttributes(attributes, debugModelId, true);
            this.addLineBreakpointAttributes(attributes, path, lineNumber, charStart, charEnd);
            this.ensureMarker().setAttributes(attributes);
            this.register(add);
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public String getResourceName() throws CoreException {
        IResource resource = this.ensureMarker().getResource();
        if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
            return resource.getName();
        }
        String portablePath = (String)this.ensureMarker().getAttribute("location");
        if (portablePath != null) {
            IPath path = Path.fromPortableString((String)portablePath);
            return path.lastSegment();
        }
        return null;
    }

    @Override
    public IResource getResource() {
        try {
            IResource resource = this.ensureMarker().getResource();
            if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
                return resource;
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    private static IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    @Override
    public IPath getResourcePath() {
        try {
            IResource resource = this.ensureMarker().getResource();
            if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
                return this.ensureMarker().getResource().getFullPath();
            }
            String path = (String)this.ensureMarker().getAttribute("location");
            if (path != null) {
                return Path.fromPortableString((String)path);
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    @Override
    public URI getResourceURI() {
        try {
            IResource resource = this.ensureMarker().getResource();
            if (!resource.equals((Object)ScriptLineBreakpoint.getWorkspaceRoot())) {
                block8: {
                    IFileHandle handle;
                    IEnvironment environment = EnvironmentManager.getEnvironment((IProject)resource.getProject());
                    if (environment != null && (handle = environment.getFile(resource.getLocationURI())) != null) {
                        try {
                            Object path = handle.getPath().toString();
                            if (!((String)path).startsWith("/")) {
                                path = "/" + (String)path;
                            }
                            return new URI("file", "", (String)path, null);
                        }
                        catch (URISyntaxException e) {
                            if (!DLTKCore.DEBUG) break block8;
                            e.printStackTrace();
                        }
                    }
                }
                return ScriptLineBreakpoint.makeUri((IPath)new Path(resource.getLocationURI().getPath()));
            }
            String portablePath = (String)this.ensureMarker().getAttribute("location");
            if (portablePath != null) {
                IPath path = Path.fromPortableString((String)portablePath);
                return ScriptLineBreakpoint.makeUri(path);
            }
        }
        catch (CoreException e) {
            DLTKDebugPlugin.log(e);
        }
        return null;
    }

    @Override
    public String[] getUpdatableAttributes() {
        return UPDATABLE_ATTRS;
    }
}

