/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.lsp.editor.EditorMetadata;
import org.eclipse.cdt.lsp.editor.EditorOptions;
import org.eclipse.cdt.lsp.ui.ConfigurationArea;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.OsgiPreferenceMetadataStore;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class SaveActionsConfigurationArea
extends ConfigurationArea<EditorOptions> {
    private final Button format;
    private final Button formatAll;
    private final Button formatEdited;

    public SaveActionsConfigurationArea(Composite parent, boolean isProjectScope) {
        super(1);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(this.columns).create());
        this.format = this.createButton(EditorMetadata.Predefined.formatOnSave, composite, 32, 0);
        this.formatAll = this.createButton(EditorMetadata.Predefined.formatAllLines, composite, 16, 15);
        this.formatEdited = this.createButton(EditorMetadata.Predefined.formatEditedLines, composite, 16, 15);
        SelectionAdapter formatListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = SaveActionsConfigurationArea.this.format.getSelection();
                SaveActionsConfigurationArea.this.formatAll.setEnabled(selection);
                SaveActionsConfigurationArea.this.formatEdited.setEnabled(selection);
            }
        };
        this.format.addSelectionListener((SelectionListener)formatListener);
    }

    @Override
    public void load(EditorOptions options, boolean enable) {
        this.format.setSelection(options.formatOnSave());
        this.formatAll.setSelection(options.formatAllLines());
        this.formatEdited.setSelection(options.formatEditedLines());
        this.format.setEnabled(enable);
        this.formatAll.setEnabled(enable && this.format.getSelection());
        this.formatEdited.setEnabled(enable && this.format.getSelection());
    }

    @Override
    public void store(IEclipsePreferences prefs) {
        OsgiPreferenceMetadataStore store = new OsgiPreferenceMetadataStore(prefs);
        this.buttons.entrySet().forEach(e -> store.save((Object)((Button)e.getValue()).getSelection(), (PreferenceMetadata)e.getKey()));
    }

    @Override
    public List<String> getPreferenceKeys() {
        ArrayList<String> list = new ArrayList<String>(3);
        list.add(EditorMetadata.Predefined.formatOnSave.identifer());
        list.add(EditorMetadata.Predefined.formatAllLines.identifer());
        list.add(EditorMetadata.Predefined.formatEditedLines.identifer());
        return list;
    }
}

