/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.internal.core.model.CElementDeltaBuilder;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.WorkingCopy;
import org.eclipse.core.runtime.OperationCanceledException;

public class ReconcileWorkingCopyOperation
extends CModelOperation {
    boolean forceProblemDetection;
    boolean fComputeAST;
    IASTTranslationUnit fAST;

    public ReconcileWorkingCopyOperation(ICElement workingCopy, boolean forceProblemDetection) {
        this(workingCopy, false, forceProblemDetection);
    }

    public ReconcileWorkingCopyOperation(ICElement workingCopy, boolean computeAST, boolean forceProblemDetection) {
        super(new ICElement[]{workingCopy});
        this.fComputeAST = computeAST;
        this.forceProblemDetection = forceProblemDetection;
    }

    @Override
    protected void executeOperation() throws CModelException {
        if (this.fMonitor != null) {
            if (this.fMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fMonitor.beginTask("element.reconciling", 10);
        }
        WorkingCopy workingCopy = this.getWorkingCopy();
        boolean wasConsistent = workingCopy.isConsistent();
        CElementDeltaBuilder deltaBuilder = null;
        try {
            if (!wasConsistent || this.forceProblemDetection || this.fComputeAST) {
                deltaBuilder = new CElementDeltaBuilder(workingCopy);
                this.fAST = workingCopy.makeConsistent(this.fComputeAST, this.fMonitor);
                deltaBuilder.buildDeltas();
                if (deltaBuilder.delta != null && (!wasConsistent || this.forceProblemDetection || deltaBuilder.delta.getAffectedChildren().length > 0)) {
                    this.addReconcileDelta(workingCopy, deltaBuilder.delta);
                }
            }
            if (this.fMonitor != null) {
                this.fMonitor.worked(2);
            }
        }
        finally {
            if (this.fMonitor != null) {
                this.fMonitor.done();
            }
        }
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected ICModelStatus verify() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        WorkingCopy workingCopy = this.getWorkingCopy();
        if (workingCopy.useCount == 0) {
            return new CModelStatus(969, workingCopy);
        }
        return status;
    }
}

