/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.breakpoints;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.debug.core.model.IScriptVariable;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.breakpoints.BreakpointUtils;
import org.eclipse.dltk.debug.ui.breakpoints.IScriptBreakpointLineValidator;
import org.eclipse.dltk.debug.ui.breakpoints.Messages;
import org.eclipse.dltk.debug.ui.breakpoints.ScriptBreakpointLineValidatorFactory;
import org.eclipse.dltk.internal.ui.editor.WorkingCopyManager;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    protected static final int BREAKPOINT_LINE_NOT_FOUND = -1;

    protected boolean isRemote(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IMember) {
            IMember member = (IMember)element;
            return !member.getScriptProject().getProject().exists();
        }
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Object adapter = Platform.getAdapterManager().getAdapter((Object)input, "org.eclipse.team.core.history.IFileRevision");
            return adapter != null;
        }
        return false;
    }

    protected String getSelectedFirstLine(ITextEditor editor, ITextSelection selection) {
        try {
            IDocument doc = editor.getDocumentProvider().getDocument(null);
            int line = selection.getStartLine();
            IRegion region = doc.getLineInformation(line);
            return doc.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
            return null;
        }
    }

    protected String getSelectedText(ITextEditor editor, ITextSelection selection) {
        try {
            IDocument doc = editor.getDocumentProvider().getDocument(null);
            return doc.get(selection.getOffset(), selection.getLength());
        }
        catch (BadLocationException e) {
            DLTKUIPlugin.log((Throwable)e);
            return null;
        }
    }

    protected void report(final String message, final IWorkbenchPart part) {
        DLTKDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine = (IEditorStatusLine)part.getAdapter(IEditorStatusLine.class);
                if (statusLine != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && DLTKDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    DLTKDebugUIPlugin.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        return (ITextEditor)part.getAdapter(ITextEditor.class);
    }

    /*
     * Unable to fully structure code
     */
    protected static int findBreakpointLine(IDocument document, int startLine, IScriptBreakpointLineValidator validator) {
        line = null;
        lineNumber = startLine;
        numberOfLines = document.getNumberOfLines();
        if (lineNumber >= 0 && lineNumber < numberOfLines) ** GOTO lbl15
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                region = document.getLineInformation(lineNumber);
                line = document.get(region.getOffset(), region.getLength());
                if (validator.isValid(line, lineNumber)) {
                    return lineNumber;
                }
                ++lineNumber;
                continue;
            }
            catch (BadLocationException e) {
                DLTKDebugUIPlugin.log(e);
            }
lbl15:
            // 3 sources

            ** while (lineNumber < numberOfLines)
        }
lbl16:
        // 1 sources

        return -1;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null && selection instanceof ITextSelection) {
            IModelElement e;
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            int offset = textSelection.getOffset();
            if (document != null) {
                try {
                    IRegion region = document.getLineInformationOfOffset(offset);
                    int end = region.getOffset() + region.getLength();
                    while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                        ++offset;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            IMember m = null;
            IWorkingCopyManager manager = DLTKUIPlugin.getDefault().getWorkingCopyManager();
            ISourceModule unit = manager.getWorkingCopy(editorInput);
            if (unit != null) {
                ISourceModule iSourceModule = unit;
                synchronized (iSourceModule) {
                    unit.reconcile(false, null, null);
                }
            }
            if ((e = unit.getElementAt(offset)) instanceof IMember) {
                m = (IMember)e;
            }
            if (m != null) {
                return new StructuredSelection((Object)m);
            }
        }
        return selection;
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection) throws CoreException {
        Job job = new Job("Script Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = ScriptToggleBreakpointAdapter.this.getTextEditor(part);
                if (editor != null && selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        ScriptToggleBreakpointAdapter.this.report(null, part);
                        int lineNumber = ((ITextSelection)selection).getStartLine() + 1;
                        String debugModelId = ScriptToggleBreakpointAdapter.this.getDebugModelId();
                        ILineBreakpoint breakpoint = BreakpointUtils.findLineBreakpoint(editor, lineNumber, debugModelId);
                        if (breakpoint != null) {
                            breakpoint.delete();
                        } else {
                            IDocumentProvider documentProvider = editor.getDocumentProvider();
                            if (documentProvider == null) {
                                return Status.CANCEL_STATUS;
                            }
                            IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
                            lineNumber = ScriptToggleBreakpointAdapter.findBreakpointLine(document, lineNumber - 1, ScriptToggleBreakpointAdapter.this.getValidator()) + 1;
                            if (lineNumber != -1) {
                                if (BreakpointUtils.findLineBreakpoint(editor, lineNumber, debugModelId) == null) {
                                    BreakpointUtils.addLineBreakpoint(editor, lineNumber, debugModelId);
                                } else {
                                    ScriptToggleBreakpointAdapter.this.report(NLS.bind((String)Messages.ScriptToggleBreakpointAdapter_breakpointAlreadySetAtLine, (Object[])new Object[]{new Integer(lineNumber)}), part);
                                }
                            } else {
                                ScriptToggleBreakpointAdapter.this.report(Messages.ScriptToggleBreakpointAdapter_invalidBreakpointPosition, part);
                            }
                        }
                    }
                    catch (CoreException e) {
                        DLTKDebugUIPlugin.log(e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected IModelElement getModelElement(IEditorInput input) {
        ISourceModule je = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return ((WorkingCopyManager)DLTKUIPlugin.getDefault().getWorkingCopyManager()).getWorkingCopy(input, false);
    }

    protected boolean isField(ITextSelection selection, IWorkbenchPart part) {
        IModelElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getModelElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof ISourceModule) {
                    element = ((ISourceModule)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 8;
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        return false;
    }

    protected boolean isFields(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object thing : selection) {
                if (thing instanceof IField) {
                    return true;
                }
                if (!(thing instanceof IScriptVariable)) continue;
                return true;
            }
        }
        return false;
    }

    protected List<?> getFields(IStructuredSelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList fields = new ArrayList(selection.size());
        for (Object thing : selection) {
            if (thing instanceof IField) {
                fields.add(thing);
                continue;
            }
            if (!(thing instanceof IScriptVariable)) continue;
            fields.add(thing);
        }
        return fields;
    }

    protected abstract String getDebugModelId();

    protected IScriptBreakpointLineValidator getValidator() {
        return ScriptBreakpointLineValidatorFactory.NON_EMPTY_VALIDATOR;
    }
}

