/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.internal.testing.launcher.NullTestRunnerUI;
import org.eclipse.dltk.internal.testing.util.NumberUtils;
import org.eclipse.dltk.testing.DLTKTestingPlugin;
import org.eclipse.dltk.testing.ITestCategoryEngine;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.dltk.utils.NatureExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCategoryEngineManager
extends NatureExtensionManager<Descriptor> {
    private static final String EXTENSION_POINT = "org.eclipse.dltk.testing.categoryEngine";
    private static final String PRIORITY_ATTR = "priority";
    private final Comparator<Object> descriptorComparator = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            Descriptor descriptor1 = (Descriptor)o1;
            Descriptor descriptor2 = (Descriptor)o2;
            return descriptor1.priority - descriptor2.priority;
        }
    };
    private static TestCategoryEngineManager instance = null;

    protected String getCategoryAttributeName() {
        return "testingEngineId";
    }

    private TestCategoryEngineManager() {
        super(EXTENSION_POINT, Descriptor.class);
    }

    protected Object createDescriptor(IConfigurationElement confElement) {
        String strPriority = confElement.getAttribute(PRIORITY_ATTR);
        int priority = NumberUtils.toInt(strPriority);
        return new Descriptor(confElement, priority);
    }

    protected void initializeDescriptors(List<Object> descriptors) {
        Collections.sort(descriptors, this.descriptorComparator);
    }

    protected Object createInstanceByDescriptor(Object descriptor) throws CoreException {
        return descriptor;
    }

    protected Descriptor[] createEmptyResult() {
        return new Descriptor[0];
    }

    private static synchronized TestCategoryEngineManager getInstance() {
        if (instance == null) {
            instance = new TestCategoryEngineManager();
        }
        return instance;
    }

    public static ITestCategoryEngine[] getCategoryEngines(ITestRunnerUI runnerUI) {
        if (runnerUI instanceof NullTestRunnerUI) {
            return null;
        }
        Descriptor[] descriptors = (Descriptor[])TestCategoryEngineManager.getInstance().getInstances(runnerUI.getTestingEngine().getId());
        if (descriptors == null) {
            return null;
        }
        ArrayList<ITestCategoryEngine> result = new ArrayList<ITestCategoryEngine>(descriptors.length);
        int i = 0;
        while (i < descriptors.length) {
            Descriptor descriptor = descriptors[i];
            try {
                ITestCategoryEngine categoryEngine = (ITestCategoryEngine)descriptor.element.createExecutableExtension("class");
                if (categoryEngine.initialize(runnerUI)) {
                    result.add(categoryEngine);
                }
            }
            catch (CoreException e) {
                DLTKTestingPlugin.log("Error creating category engine", e);
            }
            catch (ClassCastException e) {
                DLTKTestingPlugin.log("Error creating category engine", e);
            }
            ++i;
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new ITestCategoryEngine[result.size()]);
    }

    static class Descriptor {
        final IConfigurationElement element;
        final int priority;

        public Descriptor(IConfigurationElement confElement, int priority) {
            this.element = confElement;
            this.priority = priority;
        }
    }
}

