/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.typeinference.evaluators;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.typeinference.DefaultRubyEvaluatorFactory;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.evaluators.RubyMixinGoalEvaluator;
import org.eclipse.dltk.ruby.typeinference.goals.ColonExpressionGoal;
import org.eclipse.dltk.ruby.typeinference.goals.NonTypeConstantTypeGoal;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.ClassType;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class ColonExpressionEvaluator
extends RubyMixinGoalEvaluator {
    private AbstractTypeGoal helperGoal = null;
    private IEvaluatedType helperResult = null;
    private IEvaluatedType answer = null;

    public ColonExpressionEvaluator(IGoal goal) {
        super(goal);
    }

    private ColonExpressionGoal getTypedGoal() {
        return (ColonExpressionGoal)DefaultRubyEvaluatorFactory.translateGoal(this.goal);
    }

    public Object produceResult() {
        return this.answer;
    }

    public IGoal[] init() {
        RubyColonExpression expr = this.getTypedGoal().getColonExpression();
        ASTNode left = expr.getLeft();
        if (left != null) {
            this.helperGoal = new ExpressionTypeGoal(this.getGoal().getContext(), left);
            return new IGoal[]{this.helperGoal};
        }
        IMixinElement mixinElement = this.mixinModel.getRawModel().get(expr.getName());
        if (mixinElement != null) {
            this.answer = new RubyClassType(mixinElement.getKey());
        }
        return IGoal.NO_GOALS;
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        this.helperResult = (IEvaluatedType)result;
        RubyColonExpression expr = this.getTypedGoal().getColonExpression();
        ASTNode left = expr.getLeft();
        if (left != null) {
            if (this.helperResult instanceof ClassType) {
                ClassType classType = (ClassType)this.helperResult;
                String modelKey = classType.getModelKey();
                modelKey = String.valueOf(modelKey) + IMixinRequestor.MIXIN_NAME_SEPARATOR + expr.getName();
                IMixinElement mixinElement = this.mixinModel.getRawModel().get(modelKey);
                if (mixinElement != null) {
                    Object[] objects = mixinElement.getAllObjects();
                    boolean found = false;
                    int i = 0;
                    while (i < objects.length) {
                        RubyMixinElementInfo info;
                        if (objects[i] instanceof RubyMixinElementInfo && (info = (RubyMixinElementInfo)objects[i]).getKind() == 3) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (found) {
                        NonTypeConstantTypeGoal g = new NonTypeConstantTypeGoal(this.goal.getContext(), mixinElement);
                        return new IGoal[]{g};
                    }
                    this.answer = new RubyClassType(modelKey);
                } else {
                    this.answer = null;
                }
            }
        } else {
            IMixinElement mixinElement = this.mixinModel.getRawModel().get(expr.getName());
            if (mixinElement != null) {
                this.answer = new RubyClassType(mixinElement.getKey());
            }
        }
        return IGoal.NO_GOALS;
    }
}

