/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.python.internal.core.codeassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.codeassist.select.SelectionNodeFound;
import org.eclipse.dltk.python.internal.core.codeassist.PythonSelectionParser;
import org.eclipse.dltk.python.internal.core.parser.PythonParseUtils;

public class PythonSelectionEngine
extends ScriptSelectionEngine {
    public static boolean DEBUG = DLTKCore.DEBUG_SELECTION;
    private int actualSelectionStart;
    private int actualSelectionEnd;
    private PythonSelectionParser parser = new PythonSelectionParser();
    private List selectionElements = new ArrayList();
    private IDLTKLanguageToolkit toolkit;

    public IModelElement[] select(ISourceModule sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        block12: {
            String source = sourceUnit.getSourceContents();
            if (DEBUG) {
                System.out.print("SELECTION IN ");
                System.out.print(sourceUnit.getFileName());
                System.out.print(" FROM ");
                System.out.print(selectionSourceStart);
                System.out.print(" TO ");
                System.out.println(selectionSourceEnd);
                System.out.println("SELECTION - Source :");
                System.out.println(source);
            }
            if (!this.checkSelection(source, selectionSourceStart, selectionSourceEnd)) {
                return new IModelElement[0];
            }
            if (DEBUG) {
                System.out.print("SELECTION - Checked : \"");
                System.out.print(source.substring(this.actualSelectionStart, this.actualSelectionEnd));
                System.out.println('\"');
            }
            try {
                ModuleDeclaration parsedUnit = this.parser.parse(sourceUnit);
                if (parsedUnit == null) break block12;
                try {
                    this.lookupEnvironment.buildTypeScope(parsedUnit, null);
                    this.unitScope = parsedUnit.scope;
                    if (this.unitScope != null) {
                        this.parseBlockStatements(parsedUnit, this.actualSelectionStart);
                        if (DEBUG) {
                            System.out.println("COMPLETION - AST :");
                            System.out.println(parsedUnit.toString());
                        }
                    }
                }
                catch (SelectionNodeFound e) {
                    if (e.getNode() != null) {
                        if (DEBUG) {
                            System.out.print("COMPLETION - Completion node : ");
                            System.out.println(e.getNode().toString());
                            if (this.parser.getAssistNodeParent() != null) {
                                System.out.print("COMPLETION - Parent Node : ");
                                System.out.println(this.parser.getAssistNodeParent());
                            }
                        }
                        this.select(e.getNode(), this.parser.getAssistNodeParent());
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (!DEBUG) break block12;
                System.out.println("Exception caught by SelectionEngine:");
                e.printStackTrace(System.out);
            }
        }
        return this.selectionElements.toArray(new IModelElement[this.selectionElements.size()]);
    }

    private void select(ASTNode astNode, ASTNode astNodeParent) {
    }

    private boolean checkSelection(String source, int selectionSourceStart, int selectionSourceEnd) {
        boolean cheat = false;
        if (selectionSourceEnd < selectionSourceStart) {
            selectionSourceEnd = selectionSourceStart;
            cheat = true;
        }
        int start = PythonParseUtils.startLineOrNoSymbol(selectionSourceStart, source);
        int end = PythonParseUtils.endLineOrNoSymbol(selectionSourceEnd, source);
        if (end <= start) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        if (start > source.length() || end > source.length()) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        boolean isVariable = false;
        if (source.charAt(start) == '$') {
            isVariable = true;
        } else if (start > 0 && source.charAt(start - 1) == '{' && start - 1 > 0 && source.charAt(start - 2) == '$') {
            start -= 2;
            isVariable = true;
            while (end < source.length() && source.charAt(end) != '}') {
                ++end;
            }
            ++end;
        }
        if (isVariable && end < source.length() && source.charAt(end) == '(') {
            while (end < source.length() && source.charAt(end) != ')') {
                ++end;
            }
            ++end;
        }
        String sub = source.substring(start, end);
        if (!(isVariable || sub.indexOf(32) == -1 && sub.indexOf(9) == -1 && sub.indexOf(10) == -1)) {
            if (cheat) {
                return this.checkSelection(source, selectionSourceEnd - 1, selectionSourceEnd - 1);
            }
            return false;
        }
        this.actualSelectionStart = start;
        this.actualSelectionEnd = end;
        return true;
    }

    public IAssistParser getParser() {
        return this.parser;
    }
}

