/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser;

import com.xored.org.mozilla.javascript.CompilerEnvirons;
import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Parser;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.ISourceElementParser;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptErrorReporter;
import org.eclipse.dltk.internal.javascript.parser.JavaScriptModuleDeclaration;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ResolverManager;
import org.eclipse.dltk.internal.javascript.typeinference.ContextReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.TypeInferencer;
import org.eclipse.dltk.internal.javascript.typeinference.UnknownReference;
import org.eclipse.dltk.javascript.core.JavaScriptPlugin;

public class JavaScriptSourceElementParser
implements ISourceElementParser {
    private ISourceElementRequestor fRequestor = null;
    private IProblemReporter fReporter = null;
    private org.eclipse.dltk.core.ISourceModule module;
    private HashSet reportedRefs = new HashSet();

    public void parseSourceModule(ISourceModule module, ISourceModuleInfoCache.ISourceModuleInfo mifo) {
        if (module instanceof org.eclipse.dltk.core.ISourceModule) {
            this.module = (org.eclipse.dltk.core.ISourceModule)module;
        }
        this.parseSourceModule(module.getSourceContents(), mifo);
    }

    private void parseSourceModule(String content, ISourceModuleInfoCache.ISourceModuleInfo info) {
        CompilerEnvirons cenv = new CompilerEnvirons();
        boolean strict = JavaScriptPlugin.getDefault().getPluginPreferences().getBoolean("USE_STRICT_MODE");
        cenv.setStrictMode(strict);
        JavaScriptModuleDeclaration moduleDeclaration = new JavaScriptModuleDeclaration(content.length());
        Parser parser = new Parser(cenv, new JavaScriptErrorReporter(this.fReporter));
        try {
            ScriptOrFnNode parse = parser.parse(new StringReader(content), "", 0);
            ReferenceResolverContext createResolverContext = null;
            if (this.module != null) {
                createResolverContext = ResolverManager.createResolverContext(this.module, new HashMap(), true);
                createResolverContext.init();
            } else {
                createResolverContext = new ReferenceResolverContext(null, new HashMap());
            }
            TypeInferencer interferencer = new TypeInferencer(null, createResolverContext);
            interferencer.setRequestor(this.fRequestor);
            interferencer.doInterferencing(parse, Integer.MAX_VALUE);
            this.fRequestor.enterModule();
            HostCollection collection = interferencer.getCollection();
            this.processNode(parse, collection);
            moduleDeclaration.setCollection(collection);
            Collection sm = collection.getReferences().values();
            Iterator i = sm.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (!(next instanceof IReference)) continue;
                IReference ref = (IReference)next;
                this.reportRef(ref, null, 0);
            }
            Map ms = interferencer.getFunctionMap();
            moduleDeclaration.setFunctionMap(ms);
            Iterator ia = ms.values().iterator();
            while (ia.hasNext()) {
                HostCollection next = (HostCollection)ia.next();
                this.fRequestor.acceptFieldReference(("!!!" + next.getName()).toCharArray(), 0);
            }
            this.fRequestor.exitModule(content.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void reportRef(IReference ref, String sma, int level) {
        if (this.reportedRefs.contains(ref)) {
            return;
        }
        this.reportedRefs.add(ref);
        String key = ref.getName();
        if (sma != null) {
            key = String.valueOf(sma) + '.' + key;
        }
        if (level == 0) {
            Set sm = ref.getChilds(false);
            Iterator i = sm.iterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (!(next instanceof IReference)) continue;
                IReference refa = (IReference)next;
                this.reportRef(refa, key, level + 1);
            }
        }
        this.fRequestor.acceptFieldReference(key.toCharArray(), 0);
    }

    private void processNode(ScriptOrFnNode parse, HostCollection collection) {
        FunctionNode n;
        int a = 0;
        while (a < parse.getFunctionCount()) {
            FunctionNode functionNode = parse.getFunctionNode(a);
            functionNode.getFunctionName();
            HostCollection function = collection != null ? collection.getFunction(functionNode) : null;
            ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
            String functionName = functionNode.getFunctionName();
            if (functionName.length() != 0) {
                methodInfo.name = functionName;
                methodInfo.declarationStart = functionNode.getEncodedSourceStart();
                String[] paramsAndVars = functionNode.getParamAndVarNames();
                String[] params = new String[functionNode.getParamCount()];
                int i = 0;
                while (i < params.length) {
                    params[i] = paramsAndVars[i];
                    ++i;
                }
                methodInfo.parameterNames = params;
                methodInfo.nameSourceStart = functionNode.nameStart + 1;
                methodInfo.nameSourceEnd = functionNode.nameEnd + 1;
                this.fRequestor.enterMethod(methodInfo);
                this.processNode(functionNode, function);
                this.fRequestor.exitMethod(functionNode.getEncodedSourceEnd());
            }
            ++a;
        }
        String[] paramsAndVars = parse.getParamAndVarNames();
        String[] params = new String[parse.getParamCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = paramsAndVars[i];
            ++i;
        }
        int of = 0;
        if (parse instanceof FunctionNode && (n = (FunctionNode)parse).getFunctionType() != 1) {
            of = 1;
        }
        int i2 = params.length;
        while (i2 < paramsAndVars.length - of) {
            ISourceElementRequestor.FieldInfo fieldInfo = new ISourceElementRequestor.FieldInfo();
            fieldInfo.name = paramsAndVars[i2];
            ScriptOrFnNode.Position p = parse.getPosition(i2);
            fieldInfo.nameSourceStart = p.start + 1;
            fieldInfo.nameSourceEnd = p.start + fieldInfo.name.length();
            fieldInfo.declarationStart = p.start;
            this.fRequestor.enterField(fieldInfo);
            if (collection != null) {
                IReference reference = collection.getReference(fieldInfo.name);
                if (reference != null) {
                    Set childs = reference.getChilds(false);
                    Iterator it = childs.iterator();
                    while (it.hasNext()) {
                        IReference ref;
                        Object o = it.next();
                        if (o instanceof IReference && (ref = (IReference)o) instanceof UnknownReference) {
                            UnknownReference uref = (UnknownReference)ref;
                            ISourceElementRequestor.FieldInfo fieldInfo1 = new ISourceElementRequestor.FieldInfo();
                            fieldInfo1.name = ref.getName();
                            fieldInfo1.nameSourceStart = uref.getOffset();
                            fieldInfo1.nameSourceEnd = uref.getOffset() + uref.getLength() - 1;
                            fieldInfo1.declarationStart = uref.getOffset();
                            this.fRequestor.enterField(fieldInfo1);
                            this.fRequestor.exitField(uref.getOffset() + uref.getLength());
                        }
                        if (!(o instanceof ContextReference)) continue;
                        ContextReference rr = (ContextReference)o;
                        ISourceElementRequestor.MethodInfo methodInfo = new ISourceElementRequestor.MethodInfo();
                        methodInfo.name = rr.getName();
                        methodInfo.parameterNames = new String[0];
                        methodInfo.declarationStart = rr.getPosition();
                        methodInfo.nameSourceStart = rr.getPosition();
                        methodInfo.nameSourceEnd = rr.getPosition() + rr.getLength() - 1;
                        this.fRequestor.enterMethod(methodInfo);
                        this.fRequestor.exitMethod(rr.getPosition() + rr.getLength());
                    }
                }
            } else {
                this.fRequestor.exitField(fieldInfo.nameSourceEnd);
            }
            ++i2;
        }
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.fRequestor = requestor;
    }

    public void setReporter(IProblemReporter reporter) {
        this.fReporter = reporter;
    }
}

