/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.dbgp.tests;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.dltk.dbgp.commands.IDbgpPropertyCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.dbgp.exceptions.DbgpProtocolException;
import org.eclipse.dltk.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.dbgp.internal.commands.DbgpPropertyCommands;
import org.eclipse.dltk.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.debug.dbgp.tests.AbstractCommunicator;
import org.eclipse.dltk.debug.dbgp.tests.DbgpProtocolTests;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbgpPropertyCommandsTests
extends DbgpProtocolTests {
    private static final String GET_PROPERTY_RESPONSE = "property_get.xml";
    private static final String SET_PROPERTY_RESPONSE = "property_set.xml";
    private IDbgpPropertyCommands commands;

    protected Element makePropertyGetResponse(String name, String fullName, String type) throws IOException, DbgpProtocolException {
        String xml = this.getResourceAsString(GET_PROPERTY_RESPONSE);
        xml = MessageFormat.format(xml, name, fullName, type, "_size", "_children");
        Document doc = DbgpXmlParser.parseXml((String)xml);
        return (Element)doc.getFirstChild();
    }

    protected Element makePropertySetResponse(int transaction_id, boolean success) throws IOException, DbgpProtocolException {
        String xml = this.getResourceAsString(SET_PROPERTY_RESPONSE);
        xml = MessageFormat.format(xml, success ? "1" : "0", Integer.toString(transaction_id));
        Document doc = DbgpXmlParser.parseXml((String)xml);
        return (Element)doc.getFirstChild();
    }

    protected String makePropertyValueResponse(String name) {
        return "";
    }

    public void testGetPropertyByName() throws Exception {
        final Element response = this.makePropertyGetResponse("xxx", "test::xxx", "string");
        this.commands = new DbgpPropertyCommands((IDbgpCommunicator)new AbstractCommunicator(){

            public Element communicate(DbgpRequest request) throws DbgpException {
                DbgpPropertyCommandsTests.assertTrue((request.optionCount() == 2 ? 1 : 0) != 0);
                DbgpPropertyCommandsTests.assertTrue((boolean)request.hasOption("-i"));
                DbgpPropertyCommandsTests.assertTrue((boolean)request.hasOption("-n"));
                return response;
            }
        });
    }

    public void testGetPropertyByNameAndStackDepth() throws Exception {
    }

    public void testGetPropertyByNameAndStackDepthAndContextId() throws Exception {
    }

    public void testSetProperty() throws Exception {
        final Element response = this.makePropertySetResponse(123, true);
        this.commands = new DbgpPropertyCommands((IDbgpCommunicator)new AbstractCommunicator(){

            public Element communicate(DbgpRequest request) throws DbgpException {
                DbgpPropertyCommandsTests.assertTrue((boolean)request.hasOption("-n"));
                return response;
            }
        });
    }
}

