/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;

public class TclForStatement
extends Statement {
    private Block initial;
    private ASTNode condition;
    private Block incremental;
    private Block body;

    public TclForStatement(Block start, ASTNode test, Block next, Block body, int startPos, int endPos) {
        Assert.isNotNull((Object)start);
        Assert.isNotNull((Object)test);
        Assert.isNotNull((Object)next);
        Assert.isNotNull((Object)body);
        this.initial = start;
        this.condition = test;
        this.incremental = next;
        this.body = body;
        this.setEnd(endPos);
        this.setStart(startPos);
    }

    public TclForStatement(int startPos, int endPos) {
        this.setEnd(endPos);
        this.setStart(startPos);
        this.initial = null;
        this.condition = null;
        this.incremental = null;
        this.body = null;
    }

    public int getKind() {
        return 2001;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            if (this.initial != null) {
                this.initial.traverse(visitor);
            }
            if (this.condition != null) {
                this.condition.traverse(visitor);
            }
            if (this.incremental != null) {
                this.incremental.traverse(visitor);
            }
            if (this.body != null) {
                this.body.traverse(visitor);
            }
            visitor.endvisit((Statement)this);
        }
    }

    public Block getInitial() {
        return this.initial;
    }

    public ASTNode getCondition() {
        return this.condition;
    }

    public Block getIncremental() {
        return this.incremental;
    }

    public Block getBlock() {
        return this.body;
    }

    public void setInitial(Block start) {
        this.initial = start;
    }

    public void setCondition(ASTNode test) {
        this.condition = test;
    }

    public void setIncremental(Block next) {
        this.incremental = next;
    }

    public void acceptBlock(Block body) {
        this.body = body;
    }
}

