/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.core.model;

import org.eclipse.dltk.dbgp.IDbgpStackLevel;
import org.eclipse.dltk.dbgp.commands.IDbgpStatckCommands;
import org.eclipse.dltk.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.internal.debug.core.model.ScriptStackFrame;
import org.eclipse.dltk.internal.debug.core.model.ScriptThread;

public class ScriptStack {
    private ScriptStackFrame[] frames;
    private final ScriptThread thread;

    protected ScriptStackFrame[] readFrames(IDbgpStatckCommands commands) throws DbgpException {
        IDbgpStackLevel[] levels = commands.getStackLevels();
        ScriptStackFrame[] frames = new ScriptStackFrame[levels.length];
        int i = 0;
        while (i < levels.length) {
            IDbgpStackLevel level = levels[i];
            frames[level.getLevel()] = new ScriptStackFrame(this.thread, level);
            ++i;
        }
        return frames;
    }

    public ScriptStack(ScriptThread thread) {
        this.thread = thread;
        this.frames = new ScriptStackFrame[0];
    }

    public void update() {
        this.frames = new ScriptStackFrame[0];
        try {
            this.frames = this.readFrames(this.thread.getDbgpSession().getCoreCommands());
        }
        catch (DbgpException dbgpException) {}
    }

    public ScriptThread getThread() {
        return this.thread;
    }

    public int size() {
        return this.frames.length;
    }

    public boolean hasFrames() {
        return this.frames.length > 0;
    }

    public ScriptStackFrame[] getFrames() {
        return (ScriptStackFrame[])this.frames.clone();
    }

    public ScriptStackFrame getTopFrame() {
        ScriptStackFrame[] frames = this.getFrames();
        return frames.length > 0 ? frames[0] : null;
    }
}

