/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.core.ScriptFolder;
import org.eclipse.dltk.internal.ui.StandardModelElementContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ProjectFragmentProvider;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.dltk.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;

public abstract class ScriptExplorerContentProvider
extends StandardModelElementContentProvider
implements ITreeContentProvider,
IElementChangedListener {
    protected static final int ORIGINAL = 0;
    protected static final int PARENT = 1;
    protected static final int GRANT_PARENT = 2;
    protected static final int PROJECT = 4;
    private TreeViewer fViewer;
    private Object fInput;
    private boolean fIsFlatLayout;
    private ProjectFragmentProvider fScriptFolderProvider = new ProjectFragmentProvider(this.getPreferenceStore());
    private int fPendingChanges;

    public ScriptExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
    }

    public ProjectFragmentProvider getScriptFolderProvider() {
        return this.fScriptFolderProvider;
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected Object getViewerInput() {
        return this.fInput;
    }

    public void elementChanged(ElementChangedEvent event) {
        try {
            if (this.inputDeleted()) {
                return;
            }
            this.processDelta(event.getDelta());
        }
        catch (ModelException e) {
            DLTKUIPlugin.log(e);
        }
    }

    private boolean inputDeleted() {
        if (this.fInput == null) {
            return false;
        }
        if (this.fInput instanceof IModelElement && ((IModelElement)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof IResource && ((IResource)this.fInput).exists()) {
            return false;
        }
        if (this.fInput instanceof WorkingSetModel) {
            return false;
        }
        this.postRefresh(this.fInput, 0, this.fInput);
        return true;
    }

    public void dispose() {
        super.dispose();
        DLTKCore.removeElementChangedListener((IElementChangedListener)this);
        this.fScriptFolderProvider.dispose();
    }

    private boolean needsToDelegateGetChildren(Object element) {
        int type = -1;
        if (element instanceof IModelElement) {
            type = ((IModelElement)element).getElementType();
        }
        return !this.fIsFlatLayout && (type == 4 || type == 3 || type == 2 || element instanceof IFolder);
    }

    public Object[] getChildren(Object parentElement) {
        Object[] children = NO_CHILDREN;
        try {
            if (parentElement instanceof IScriptModel) {
                return ScriptExplorerContentProvider.concatenate(this.getScriptProjects((IScriptModel)parentElement), this.getNonScriptProjects((IScriptModel)parentElement));
            }
            if (parentElement instanceof BuildPathContainer) {
                return this.getContainerProjectFragments((BuildPathContainer)parentElement);
            }
            if (parentElement instanceof IProject) {
                return ((IProject)parentElement).members();
            }
            if (this.needsToDelegateGetChildren(parentElement)) {
                Object[] ScriptFolders = this.fScriptFolderProvider.getChildren(parentElement);
                children = this.getWithParentsResources(ScriptFolders, parentElement);
            } else {
                children = super.getChildren(parentElement);
            }
            if (parentElement instanceof IScriptProject) {
                IScriptProject project = (IScriptProject)parentElement;
                return this.rootsAndContainers(project, children);
            }
            return children;
        }
        catch (CoreException coreException) {
            return NO_CHILDREN;
        }
    }

    private Object[] rootsAndContainers(IScriptProject project, Object[] roots) throws ModelException {
        ArrayList<Object> result = new ArrayList<Object>(roots.length);
        HashSet<IBuildpathEntry> containers = new HashSet<IBuildpathEntry>(roots.length);
        HashSet<IProjectFragment> containedRoots = new HashSet<IProjectFragment>(roots.length);
        IBuildpathEntry[] entries = project.getRawBuildpath();
        int i = 0;
        while (i < entries.length) {
            IBuildpathEntry entry = entries[i];
            if (entry != null && entry.getEntryKind() == 5) {
                IProjectFragment[] roots1 = project.findProjectFragments(entry);
                containedRoots.addAll(Arrays.asList(roots1));
                containers.add(entry);
            }
            ++i;
        }
        i = 0;
        while (i < roots.length) {
            if (roots[i] instanceof IProjectFragment) {
                if (!containedRoots.contains(roots[i])) {
                    result.add(roots[i]);
                }
            } else {
                result.add(roots[i]);
            }
            ++i;
        }
        Iterator each = containers.iterator();
        while (each.hasNext()) {
            IBuildpathEntry element = (IBuildpathEntry)each.next();
            result.add(new BuildPathContainer(project, element));
        }
        return result.toArray();
    }

    protected Object[] getContainerProjectFragments(BuildPathContainer container) {
        return container.getChildren(container);
    }

    private Object[] getNonScriptProjects(IScriptModel model) throws ModelException {
        return model.getForeignResources();
    }

    public Object getParent(Object child) {
        if (this.needsToDelegateGetParent(child)) {
            return this.fScriptFolderProvider.getParent(child);
        }
        return super.getParent(child);
    }

    protected Object internalGetParent(Object element) {
        if (element instanceof IProjectFragment) {
            IProjectFragment root = (IProjectFragment)element;
            IScriptProject project = root.getScriptProject();
            try {
                IBuildpathEntry[] entries = project.getRawBuildpath();
                int i = 0;
                while (i < entries.length) {
                    IBuildpathEntry entry = entries[i];
                    if (entry.getEntryKind() == 5 && BuildPathContainer.contains(project, entry, root)) {
                        return new BuildPathContainer(project, entry);
                    }
                    ++i;
                }
            }
            catch (ModelException modelException) {}
        }
        if (element instanceof BuildPathContainer) {
            return ((BuildPathContainer)element).getScriptProject();
        }
        return super.internalGetParent(element);
    }

    private boolean needsToDelegateGetParent(Object element) {
        int type = -1;
        if (element instanceof IModelElement) {
            type = ((IModelElement)element).getElementType();
        }
        return !this.fIsFlatLayout && type == 4;
    }

    private Object[] getWithParentsResources(Object[] existingObject, Object parent) {
        Object[] objects = super.getChildren(parent);
        ArrayList<Object> list = new ArrayList<Object>();
        if (existingObject != null) {
            list.addAll(Arrays.asList(existingObject));
        }
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (!(object instanceof ScriptFolder) && !list.contains(object)) {
                list.add(object);
            }
            ++i;
        }
        return list.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        this.fScriptFolderProvider.inputChanged(viewer, oldInput, newInput);
        this.fViewer = (TreeViewer)viewer;
        if (oldInput == null && newInput != null) {
            DLTKCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            DLTKCore.removeElementChangedListener((IElementChangedListener)this);
        }
        this.fInput = newInput;
    }

    private void processDelta(IModelElementDelta delta) throws ModelException {
        Object parent;
        IScriptProject proj;
        int kind = delta.getKind();
        int flags = delta.getFlags();
        IModelElement element = delta.getElement();
        int elementType = element.getElementType();
        if (!(elementType == 1 || elementType == 2 || (proj = element.getScriptProject()) != null && proj.getProject().isOpen())) {
            return;
        }
        if (!this.fIsFlatLayout && elementType == 4) {
            this.fScriptFolderProvider.processDelta(delta);
            if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
                return;
            }
            this.handleAffectedChildren(delta, element);
            return;
        }
        if (elementType == 5) {
            ISourceModule cu = (ISourceModule)element;
            if (!ScriptModelUtil.isPrimary((ISourceModule)cu)) {
                return;
            }
            if (!this.getProvideMembers(element) && cu.isWorkingCopy() && kind == 4) {
                return;
            }
            if (kind == 4 && !ScriptExplorerContentProvider.isStructuralCUChange(flags)) {
                return;
            }
            if (!this.isOnBuildpath(cu)) {
                return;
            }
        }
        if (elementType == 2) {
            if ((flags & 0x600) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
            if ((flags & 0x20000) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
        }
        if (kind == 2) {
            parent = this.internalGetParent(element);
            if (element instanceof IScriptFolder) {
                if (this.fViewer.testFindItem(parent) != null) {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            this.postRemove(element);
            if (parent instanceof IScriptFolder) {
                this.postUpdateIcon((IModelElement)((IScriptFolder)parent));
            }
            if (this.isScriptFolderEmpty(element.getParent()) && this.fViewer.testFindItem(parent) != null) {
                this.postRefresh(this.internalGetParent(parent), 2, element);
            }
            return;
        }
        if (kind == 1) {
            parent = this.internalGetParent(element);
            if (parent instanceof IScriptFolder) {
                Object grandparent = this.internalGetParent(parent);
                if (parent.equals(this.fInput)) {
                    this.postRefresh(parent, 1, element);
                } else if (this.fViewer.testFindItem(parent) == null) {
                    this.postRefresh(grandparent, 2, element);
                } else {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            this.postAdd(parent, element);
        }
        if (elementType == 5) {
            if (kind == 4) {
                this.postRefresh(element, 0, element);
                this.updateSelection(delta);
            }
            return;
        }
        if (elementType == 3) {
            if ((flags & 0x8000) != 0) {
                this.postRefresh(element, 0, element);
                return;
            }
            if (this.isBuildPathChange(delta)) {
                this.postRefresh(element.getScriptProject(), 4, element);
                return;
            }
        }
        if (this.processResourceDeltas(delta.getResourceDeltas(), element)) {
            return;
        }
        this.handleAffectedChildren(delta, element);
    }

    private static boolean isStructuralCUChange(int flags) {
        return (flags & 8) != 0 || (flags & 0x4001) == 1;
    }

    void handleAffectedChildren(IModelElementDelta delta, IModelElement element) throws ModelException {
        IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (affectedChildren.length > 1) {
            if (element instanceof IScriptFolder) {
                IModelElement parent = (IModelElement)this.internalGetParent(element);
                if (element.equals(this.fInput)) {
                    this.postRefresh(element, 0, element);
                } else {
                    this.postRefresh(parent, 1, element);
                }
                return;
            }
            if (element instanceof IProjectFragment) {
                Object toRefresh = this.skipProjectProjectFragment((IProjectFragment)element);
                this.postRefresh(toRefresh, 0, toRefresh);
            } else {
                this.postRefresh(element, 0, element);
            }
            return;
        }
        this.processAffectedChildren(affectedChildren);
    }

    protected void processAffectedChildren(IModelElementDelta[] affectedChildren) throws ModelException {
        int i = 0;
        while (i < affectedChildren.length) {
            this.processDelta(affectedChildren[i]);
            ++i;
        }
    }

    private boolean isOnBuildpath(ISourceModule element) {
        IScriptProject project = element.getScriptProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnBuildpath((IModelElement)element);
    }

    private void updateSelection(IModelElementDelta delta) {
        final IModelElement addedElement = this.findAddedElement(delta);
        if (addedElement != null) {
            final StructuredSelection selection = new StructuredSelection((Object)addedElement);
            this.postRunnable(new Runnable(){

                public void run() {
                    Control ctrl = ScriptExplorerContentProvider.this.fViewer.getControl();
                    if (ctrl != null && !ctrl.isDisposed() && ScriptExplorerContentProvider.this.fViewer.testFindItem((Object)addedElement) != null) {
                        ScriptExplorerContentProvider.this.fViewer.setSelection((ISelection)selection);
                    }
                }
            });
        }
    }

    private IModelElement findAddedElement(IModelElementDelta delta) {
        if (delta.getKind() == 1) {
            return delta.getElement();
        }
        int i = 0;
        IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
        if (i < affectedChildren.length) {
            return this.findAddedElement(affectedChildren[i]);
        }
        return null;
    }

    private void postUpdateIcon(final IModelElement element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = ScriptExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ScriptExplorerContentProvider.this.fViewer.update((Object)element, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private boolean processResourceDelta(IResourceDelta delta, Object parent) {
        int status = delta.getKind();
        int flags = delta.getFlags();
        IResource resource = delta.getResource();
        if (resource == null) {
            return false;
        }
        if ((status & 2) != 0) {
            if (parent instanceof IScriptFolder) {
                this.postRefresh(this.internalGetParent(parent), 1, parent);
                return true;
            }
            this.postRemove(resource);
        }
        if ((status & 1) != 0) {
            if (parent instanceof IScriptFolder) {
                this.postRefresh(this.internalGetParent(parent), 1, parent);
                return true;
            }
            this.postAdd(parent, resource);
        }
        if ((flags & 0x4000) != 0) {
            this.postProjectStateChanged(this.internalGetParent(parent));
            return true;
        }
        this.processResourceDeltas(delta.getAffectedChildren(), resource);
        return false;
    }

    public void setIsFlatLayout(boolean state) {
        this.fIsFlatLayout = state;
    }

    private boolean processResourceDeltas(IResourceDelta[] deltas, Object parent) {
        if (deltas == null) {
            return false;
        }
        if (deltas.length > 1) {
            this.postRefresh(parent, 0, parent);
            return true;
        }
        int i = 0;
        while (i < deltas.length) {
            if (this.processResourceDelta(deltas[i], parent)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void postRefresh(Object root, int relation, Object affectedElement) {
        if (this.isParent(root, this.fInput)) {
            root = this.fInput;
        }
        ArrayList<Object> toRefresh = new ArrayList<Object>(1);
        toRefresh.add(root);
        this.augmentElementToRefresh(toRefresh, relation, affectedElement);
        this.postRefresh(toRefresh, true);
    }

    protected void augmentElementToRefresh(List toRefresh, int relation, Object affectedElement) {
    }

    boolean isParent(Object root, Object child) {
        Object parent = this.getParent(child);
        if (parent == null) {
            return false;
        }
        if (parent.equals(root)) {
            return true;
        }
        return this.isParent(root, parent);
    }

    protected void postRefresh(final List toRefresh, final boolean updateLabels) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = ScriptExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    Iterator iter = toRefresh.iterator();
                    while (iter.hasNext()) {
                        ScriptExplorerContentProvider.this.fViewer.refresh(iter.next(), updateLabels);
                    }
                }
            }
        });
    }

    protected void postAdd(final Object parent, final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = ScriptExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed() && ScriptExplorerContentProvider.this.fViewer.testFindItem(element) == null) {
                    ScriptExplorerContentProvider.this.fViewer.add(parent, element);
                }
            }
        });
    }

    protected void postRemove(final Object element) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = ScriptExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ScriptExplorerContentProvider.this.fViewer.remove(element);
                }
            }
        });
    }

    protected void postProjectStateChanged(final Object root) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control ctrl = ScriptExplorerContentProvider.this.fViewer.getControl();
                if (ctrl != null && !ctrl.isDisposed()) {
                    ScriptExplorerContentProvider.this.fViewer.refresh(root, true);
                    ScriptExplorerContentProvider.this.fViewer.setSelection(ScriptExplorerContentProvider.this.fViewer.getSelection());
                }
            }
        });
    }

    void postRunnable(final Runnable r) {
        Control ctrl = this.fViewer.getControl();
        Runnable trackedRunnable = new Runnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    r.run();
                }
                catch (Throwable throwable) {
                    Object var1_2 = null;
                    ScriptExplorerContentProvider.this.removePendingChange();
                    throw throwable;
                }
                {
                    Object var1_3 = null;
                    ScriptExplorerContentProvider.this.removePendingChange();
                    return;
                }
            }
        };
        if (ctrl != null && !ctrl.isDisposed()) {
            this.addPendingChange();
            try {
                ctrl.getDisplay().asyncExec(trackedRunnable);
            }
            catch (RuntimeException e) {
                this.removePendingChange();
                throw e;
            }
            catch (Error e) {
                this.removePendingChange();
                throw e;
            }
        }
    }

    public synchronized boolean hasPendingChanges() {
        return this.fPendingChanges > 0;
    }

    private synchronized void addPendingChange() {
        ++this.fPendingChanges;
    }

    synchronized void removePendingChange() {
        --this.fPendingChanges;
        if (this.fPendingChanges < 0) {
            this.fPendingChanges = 0;
        }
    }
}

