/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.description.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import org.eclipse.actf.ai.audio.description.IMetadata;
import org.eclipse.actf.ai.audio.description.IMetadataProvider;
import org.eclipse.actf.ai.audio.description.impl.MetadataImpl;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.XMLStoreException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataProviderImpl
implements IMetadataProvider {
    private HashMap<Key, ArrayList<IMetadata>> metadataList = new HashMap();
    private ArrayList<IMetadata> metadata;
    private ArrayList<IXMLInfo> entries;
    private Locale locale = null;
    private Stack<String> langStack = new Stack();
    ArrayList<ArrayList<IMetadata>> alternatives;

    public MetadataProviderImpl(ArrayList<IXMLInfo> entries) {
        this.entries = entries;
    }

    @Override
    public void reload() {
        this.metadataList.clear();
        this.readFile();
    }

    private void readFile() {
        int i = 0;
        while (i < this.entries.size()) {
            IXMLInfo entry = this.entries.get(i);
            AllHandler ah = new AllHandler(entry);
            entry.setContentHandler((ContentHandler)ah);
            try {
                entry.startSAX();
            }
            catch (XMLStoreException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public void prepareMetadata() {
        this.prepareMetadata(this.locale);
    }

    @Override
    public void prepareMetadata(Locale locale) {
        Set<Key> keys = this.metadataList.keySet();
        this.alternatives = new ArrayList();
        for (Key key : keys) {
            if (!key.lang.equals(locale.getLanguage())) continue;
            this.alternatives.add(this.metadataList.get(key));
        }
        if (this.alternatives.size() > 0) {
            this.setMetadata(this.alternatives.get(0));
        }
    }

    public void setMetadata(ArrayList<IMetadata> metadata) {
        this.metadata = metadata;
    }

    @Override
    public IMetadata getItem(int index) {
        if (index >= 0 && index < this.metadata.size()) {
            return this.metadata.get(index);
        }
        return null;
    }

    @Override
    public ArrayList<IMetadata> getAllItems() {
        return this.metadata;
    }

    @Override
    public int getIndex(int position) {
        if (this.metadata == null) {
            return 0;
        }
        int ret = 0;
        int i = 0;
        while (i < this.metadata.size()) {
            if (this.metadata.get(i).getStartTime() >= position) {
                ret = i - 1;
                return ret;
            }
            ++i;
        }
        return this.metadata.size() - 1;
    }

    @Override
    public int getSize() {
        if (this.metadata == null) {
            return 0;
        }
        return this.metadata.size();
    }

    @Override
    public boolean hasMetadata() {
        if (this.metadata == null) {
            return false;
        }
        return this.metadata.size() > 0;
    }

    private class AllHandler
    extends BaseHandler {
        private boolean altFlag;

        public AllHandler(IXMLInfo entry) {
            super(null, entry);
            MetadataProviderImpl.this.langStack.clear();
            MetadataProviderImpl.this.langStack.push("");
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (this.altFlag) {
                if ("item".equals(localName)) {
                    String importance = attributes.getValue("importance");
                    if (importance == null || importance.length() == 0) {
                        importance = "middle";
                    }
                    this.getEntry().setContentHandler((ContentHandler)new ItemHandler((BaseHandler)this, importance));
                }
            } else {
                String type;
                if ("alternative".equals(localName) && (type = attributes.getValue("type")) != null && type.equals("audio-description")) {
                    this.altFlag = true;
                }
                "volumeLevel".equals(localName);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("alternative".equals(localName)) {
                this.altFlag = false;
            }
        }
    }

    private class BaseHandler
    extends DefaultHandler {
        private BaseHandler back;
        private IXMLInfo entry;

        public BaseHandler(BaseHandler back, IXMLInfo entry) {
            this.back = back;
            this.entry = entry;
        }

        public BaseHandler(BaseHandler back) {
            this.back = back;
            this.entry = back.getEntry();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (attributes.getValue("xml:lang") != null) {
                MetadataProviderImpl.this.langStack.push(attributes.getValue("xml:lang"));
            } else {
                MetadataProviderImpl.this.langStack.push(String.valueOf((String)MetadataProviderImpl.this.langStack.peek()));
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            MetadataProviderImpl.this.langStack.pop();
            this.getEntry().setContentHandler((ContentHandler)this.back);
        }

        public IXMLInfo getEntry() {
            return this.entry;
        }
    }

    private class ItemHandler
    extends BaseHandler {
        private boolean descFlag;
        private boolean startFlag;
        private boolean durationFlag;
        private boolean additionFlag;
        private boolean waveFlag;
        private StringBuffer buf;
        private String start;
        private String duration;
        private ArrayList<String> speed;
        private ArrayList<String> gender;
        private ArrayList<String> desc;
        private ArrayList<String> lang;
        private ArrayList<String> extended;
        private ArrayList<String> waveLocal;
        private String importance;

        public ItemHandler(BaseHandler back, String importance) {
            super(back);
            this.descFlag = false;
            this.startFlag = false;
            this.durationFlag = false;
            this.additionFlag = false;
            this.waveFlag = false;
            this.buf = new StringBuffer();
            this.speed = new ArrayList();
            this.gender = new ArrayList();
            this.desc = new ArrayList();
            this.lang = new ArrayList();
            this.extended = new ArrayList();
            this.waveLocal = new ArrayList();
            this.importance = importance;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if ("start".equals(localName)) {
                if (attributes.getValue("type").equals("relTime")) {
                    this.startFlag = true;
                }
            } else if ("duration".equals(localName)) {
                this.durationFlag = true;
            } else if ("description".equals(localName)) {
                this.descFlag = true;
                this.speed.add(attributes.getValue("speed"));
                this.gender.add(attributes.getValue("gender"));
                this.extended.add(attributes.getValue("extended"));
            } else if ("wave".equals(localName)) {
                this.waveFlag = true;
                this.waveLocal.add(attributes.getValue("local"));
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.startFlag) {
                this.buf.append(ch, start, length);
            } else if (this.durationFlag) {
                this.buf.append(ch, start, length);
            } else if (this.descFlag) {
                this.buf.append(ch, start, length);
            } else if (this.additionFlag) {
                this.buf.append(ch, start, length);
            } else if (this.waveFlag) {
                this.buf.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("start".equals(localName)) {
                this.startFlag = false;
                this.start = this.buf.toString();
                this.buf.delete(0, this.buf.length());
            } else if ("duration".equals(localName)) {
                this.durationFlag = false;
                this.duration = this.buf.toString();
                this.buf.delete(0, this.buf.length());
            } else if ("description".equals(localName)) {
                this.descFlag = false;
                this.desc.add(this.buf.toString());
                this.lang.add((String)MetadataProviderImpl.this.langStack.peek());
                this.buf.delete(0, this.buf.length());
            } else if ("wave".equals(localName)) {
                this.waveFlag = false;
                this.buf.delete(0, this.buf.length());
            } else if ("item".equals(localName)) {
                int i = 0;
                while (i < this.desc.size()) {
                    MetadataImpl mi = new MetadataImpl(this.start, this.duration, this.desc.get(i), this.lang.get(i), this.importance, this.speed.get(i), this.gender.get(i), this.extended.get(i));
                    int j = 0;
                    while (j < this.waveLocal.size()) {
                        mi.setWavLocal(this.waveLocal.get(j));
                        ++j;
                    }
                    Key key = new Key(this.getEntry().getDocumentation(), this.lang.get(i));
                    ArrayList<MetadataImpl> list = (ArrayList<MetadataImpl>)MetadataProviderImpl.this.metadataList.get(key);
                    if (list == null) {
                        list = new ArrayList<MetadataImpl>();
                        MetadataProviderImpl.this.metadataList.put(key, list);
                    }
                    list.add(mi);
                    ++i;
                }
                super.endElement(uri, localName, qName);
            }
        }
    }

    private static class Key {
        public String id;
        public String lang;

        public Key(String id, String lang) {
            this.id = id;
            this.lang = lang == null || lang.length() == 0 ? "" : new Locale(lang).getLanguage();
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return this.toString().equals(o.toString());
        }

        public String toString() {
            return String.valueOf(this.id) + this.lang;
        }
    }
}

