/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.audio.description.impl;

import java.util.Locale;
import org.eclipse.actf.ai.audio.description.IMetadata;

public class MetadataImpl
implements IMetadata {
    private double scale = 1.0;
    private String sTime;
    private int type = 1;
    private int start;
    private int originalTime;
    private int duration;
    private String description;
    private int importance;
    private String lang;
    private int speed = 50;
    private String gender = "male";
    private boolean hasValidWav = false;
    private int wavSpeed = 100;
    private String wavUri = "";
    private String wavLocal = "";
    private boolean wavEnabled = true;

    public MetadataImpl(String start, String duration, String desc, String lang, String importance, String speed, String gender, String extended) {
        this.setStart(start);
        this.setDuration(duration);
        this.setLang(lang);
        this.setDescription(desc);
        this.setImportance(importance);
        this.setSpeed(speed);
        this.setGender(gender);
        this.setExtended(extended);
    }

    private void setExtended(String extended) {
        if ("true".equalsIgnoreCase(extended)) {
            this.setType(9);
        }
    }

    private void setSpeed(String speed) {
        try {
            int speedVal = Integer.parseInt(speed);
            if (speedVal >= 0 && speedVal <= 100) {
                this.speed = speedVal;
            }
        }
        catch (Exception exception) {}
    }

    private void setGender(String gender) {
        if ("male".equalsIgnoreCase(gender)) {
            this.gender = "male";
        } else if ("female".equalsIgnoreCase(gender)) {
            this.gender = "female";
        }
    }

    private void setType(int type) {
        this.type = type;
    }

    private void setStart(String start) {
        this.start = this.string2time(start);
        this.setStringTime();
    }

    private void setDuration(String duration) {
        this.duration = this.string2time(duration);
    }

    private void setLang(String lang) {
        this.lang = new Locale(lang).getLanguage();
    }

    private void setDescription(String desc) {
        this.description = desc;
    }

    private void setImportance(String importance) {
        if ((importance = importance.toLowerCase()).equals("low")) {
            this.importance = 0;
        } else if (importance.equals("middle")) {
            this.importance = 1;
        } else if (importance.equals("high")) {
            this.importance = 2;
        }
    }

    private int string2time(String str) {
        int time = 0;
        try {
            String[] part = str.split(":");
            int[] r = new int[]{1, 1000, 60000, 3600000};
            time = 0;
            int i = part.length - 1;
            int j = 0;
            while (i >= 0) {
                int temp = Integer.parseInt(part[i]);
                time += temp * r[j];
                --i;
                ++j;
            }
            time /= 10;
        }
        catch (Exception e) {
            e.printStackTrace();
            time = 0;
        }
        return time;
    }

    private void setStringTime() {
        int temp = this.getStartTime();
        int mm = 0;
        int s = 0;
        int m = 0;
        int h = 0;
        mm = temp % 100;
        temp -= mm;
        s = (temp /= 100) % 60;
        temp -= s;
        m = (temp /= 60) % 60;
        temp -= m;
        h = temp /= 60;
        StringBuffer sb = new StringBuffer();
        if (h != 0) {
            sb.append(String.valueOf(h) + "h");
        }
        sb.append(String.valueOf(m < 10 ? "0" : "") + m + "m");
        sb.append(String.valueOf(s < 10 ? "0" : "") + s + "s");
        sb.append(String.valueOf(mm < 10 ? "0" : "") + mm);
        this.sTime = sb.toString();
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public String getDescription() {
        return this.description;
    }

    public int getStartTime() {
        int temp = this.start;
        if (temp < 0) {
            temp = 0;
        }
        return (int)((double)temp * this.scale);
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.start) + " (" + this.duration + ") " + this.description + ", " + this.importance;
    }

    public String getStringTime() {
        return this.sTime;
    }

    public void refresh() {
        this.start = this.originalTime;
        this.setStringTime();
    }

    public int getDuration() {
        return this.duration;
    }

    public String getLang() {
        return this.lang;
    }

    public int getImportance() {
        return this.importance;
    }

    public int getSpeed() {
        return this.speed;
    }

    public String getGender() {
        return this.gender;
    }

    public boolean getWavEnabled() {
        return this.wavEnabled;
    }

    public String getWavLocal() {
        return this.wavLocal;
    }

    public int getWavSpeed() {
        return this.wavSpeed;
    }

    public String getWavUri() {
        return this.wavUri;
    }

    public void setWavEnabled(String wavEnabled) {
    }

    public void setWavLocal(String wavLocal) {
        this.wavLocal = wavLocal;
        this.hasValidWav = true;
    }

    public void setWavSpeed(String wavSpeed) {
    }

    public void setWavUri(String wavUri) {
    }

    public boolean hasValidWav() {
        return this.hasValidWav;
    }
}

