/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PlatformUIUtil {
    public static IWorkbenchWindow getActiveWindow() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PlatformUIUtil.getActiveWindow();
        if (window != null) {
            try {
                return window.getActivePage();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Shell getShell() {
        IWorkbenchWindow window = PlatformUIUtil.getActiveWindow();
        if (window != null) {
            try {
                return window.getShell();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getActivePerspectiveId() {
        try {
            return PlatformUIUtil.getActivePage().getPerspective().getId();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IWorkbenchPage showPerspective(String perspectiveId) {
        IWorkbenchWindow window = PlatformUIUtil.getActiveWindow();
        if (window != null) {
            try {
                if (perspectiveId != null) {
                    return PlatformUI.getWorkbench().showPerspective(perspectiveId, window);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage activePage = PlatformUIUtil.getActivePage();
        if (activePage != null) {
            try {
                return activePage.getActiveEditor();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static boolean isViewVisible(String viewId) {
        IViewReference reference;
        IWorkbenchPage page = PlatformUIUtil.getActivePage();
        if (page != null && (reference = page.findViewReference(viewId)) != null) {
            return page.isPartVisible(reference.getPart(false));
        }
        return false;
    }

    public static IViewPart showView(String viewId) {
        IWorkbenchPage page;
        if (viewId != null && (page = PlatformUIUtil.getActivePage()) != null) {
            try {
                return page.showView(viewId);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IAction getGlobalActionHandler(String viewId, String actionId) {
        IWorkbenchPage page = PlatformUIUtil.getActivePage();
        if (page != null) {
            try {
                IWorkbenchPartSite site;
                IViewPart viewPart = page.findView(viewId);
                if (viewPart != null && (site = viewPart.getSite()) instanceof IViewSite) {
                    return ((IViewSite)site).getActionBars().getGlobalActionHandler(actionId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static IWorkbenchHelpSystem getHelpSystem() {
        try {
            return PlatformUI.getWorkbench().getHelpSystem();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL resolveHelpURL(String href, boolean documentOnly) {
        IWorkbenchHelpSystem helpSystem = PlatformUIUtil.getHelpSystem();
        if (helpSystem != null) {
            return helpSystem.resolve(href, documentOnly);
        }
        return null;
    }

    public static ISharedImages getSharedImages() {
        try {
            return PlatformUI.getWorkbench().getSharedImages();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ImageDescriptor getSharedImageDescriptor(String symbolicName) {
        try {
            return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(symbolicName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

