/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.parser;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.actf.model.dom.html.IErrorLogListener;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.dom.html.dochandler.PREHandler;
import org.eclipse.actf.model.dom.html.errorhandler.FramesetErrorHandler;
import org.eclipse.actf.model.dom.html.errorhandler.HTMLErrorHandler;
import org.eclipse.actf.model.internal.dom.html.impl.SHDOMImpl;
import org.eclipse.actf.model.internal.dom.html.impl.SHDocument;
import org.eclipse.actf.model.internal.dom.html.parser.CharsetHandler;
import org.eclipse.actf.model.internal.dom.html.parser.EncodingException;
import org.eclipse.actf.model.internal.dom.html.util.JapaneseEncodingDetector;
import org.eclipse.actf.model.internal.dom.html.util.RereadableInputStream;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.html.HTMLDOMImplementation;
import org.w3c.dom.html.HTMLDocument;
import org.xml.sax.SAXException;

public class HTMLParser
extends SGMLParser
implements IHTMLParser {
    public RereadableInputStream ris;
    public InputStreamReader isReader;
    public String encoding = null;

    static {
        InputStream is = null;
        is = HTMLParser.class.getResourceAsStream("public_entities.properties");
        if (is != null) {
            Properties map = new Properties();
            try {
                map.load(is);
                Enumeration<Object> keys = map.keys();
                while (keys.hasMoreElements()) {
                    String aKey = (String)keys.nextElement();
                    String replaceKey = aKey.replace('@', ' ');
                    pubEntityMap.put(replaceKey, (String)map.get(aKey));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    InputStreamReader getISReader() {
        return this.isReader;
    }

    public HTMLParser() {
        this.defaultDTD = "-//W3C//DTD HTML 4.0 Transitional//EN";
        this.addErrorHandler(new FramesetErrorHandler());
        this.addErrorHandler(new HTMLErrorHandler());
        this.setDocumentHandler(new PREHandler(this));
        this.setDOMImplementation(SHDOMImpl.getDOMImplementation());
        if (this.getDOMImplementation() == null) {
            this.setDocument(new SHDocument());
        }
    }

    protected Reader getResource(String resourceName) throws IOException {
        InputStream is = IHTMLParser.class.getResourceAsStream("dtd/" + resourceName);
        if (is != null) {
            return new InputStreamReader(is);
        }
        return super.getResource(resourceName);
    }

    public static void main(String[] args) {
        boolean dump = false;
        String targetFileName = null;
        int length = args.length;
        String encoding = null;
        boolean ce = false;
        boolean indent = false;
        int warning = -1;
        boolean physical = false;
        boolean xml = false;
        String list = null;
        boolean keepUnknown = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-d")) {
                dump = true;
                --length;
            } else if (args[i].equals("-o")) {
                targetFileName = args[++i];
                length -= 2;
            } else if (args[i].equals("-e")) {
                if (++i == args.length) {
                    HTMLParser.usage();
                }
                encoding = args[i];
                length -= 2;
            } else if (args[i].equals("-c")) {
                ce = true;
                --length;
            } else if (args[i].equals("-x")) {
                xml = true;
                --length;
            } else if (args[i].equals("-i")) {
                indent = true;
                --length;
            } else if (args[i].startsWith("-w")) {
                if (args[i].length() == 2) {
                    warning = 0;
                } else {
                    try {
                        warning = Integer.parseInt(args[i].substring(2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        HTMLParser.usage();
                    }
                }
                --length;
            } else if (args[i].startsWith("-ku")) {
                keepUnknown = true;
                --length;
            } else if (args[i].equals("-physical")) {
                physical = true;
                --length;
            } else {
                if (!args[i].startsWith("-l") || args[i].length() <= 2) break;
                list = args[i].substring(2);
                --length;
            }
            ++i;
        }
        if (length == 0) {
            HTMLParser.usage();
        }
        int i2 = args.length - length;
        while (i2 < args.length) {
            try {
                InputStream is;
                HTMLParser parser = new HTMLParser();
                parser.keepUnknownElements(keepUnknown);
                if (warning != -1) {
                    if (warning == 0) {
                        parser.addErrorLogListener(new IErrorLogListener(){

                            public void errorLog(int code, String msg) {
                                System.err.println(msg);
                            }
                        });
                    } else {
                        final int errorKind = warning;
                        parser.addErrorLogListener(new IErrorLogListener(){

                            public void errorLog(int code, String msg) {
                                if (code == errorKind) {
                                    System.err.println(msg);
                                }
                            }
                        });
                    }
                }
                if (physical) {
                    parser.elementHandle(false);
                }
                if (xml) {
                    parser.setDefaultTagCase(1);
                    parser.setTagCase(1);
                    parser.setAttrNameCase(1);
                }
                if (args[i2].equals("-u")) {
                    URL url = new URL(args[++i2]);
                    is = url.openStream();
                } else {
                    is = new FileInputStream(args[i2]);
                }
                System.err.println("parsing " + args[i2] + " ...");
                try {
                    if (ce) {
                        parser.parseSwitchEnc(is, encoding);
                        System.out.println("Encoding: " + parser.getEncoding());
                    } else {
                        parser.parse(is, encoding);
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                parser.close();
                if (dump) {
                    OutputStream os = targetFileName == null ? System.out : new FileOutputStream(targetFileName);
                    PrintWriter pw = encoding != null ? new PrintWriter(new OutputStreamWriter(os, encoding)) : new PrintWriter(os);
                    if (!xml) {
                        ((SHDocument)parser.getDocument()).printAsSGML(pw, indent);
                    } else {
                        ((SHDocument)parser.getDocument()).printAsXHTML(pw, indent, encoding);
                    }
                } else if (list != null) {
                    NodeList nodeList = parser.getDocument().getElementsByTagName(list);
                    i2 = 0;
                    while (i2 < nodeList.getLength()) {
                        System.out.println(nodeList.item(i2));
                        ++i2;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i2;
        }
    }

    /*
     * Loose catch block
     */
    public Node parse(InputStream is) throws ParseException, IOException, SAXException {
        JapaneseEncodingDetector JED = new JapaneseEncodingDetector(is);
        try {
            this.encoding = JED.detect();
        }
        catch (Throwable throwable) {
            try {
                is.close();
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            is.close();
        }
        catch (Exception exception) {}
        Node node = this.parse(JED.getInputStream(), this.encoding);
        try {
            is.close();
        }
        catch (Exception exception) {}
        return node;
        catch (Exception exception) {
            Node node2;
            try {
                this.isReader = new InputStreamReader(JED.getInputStream());
                node2 = this.parse(this.isReader);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (Exception exception2) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (Exception exception3) {}
            return node2;
        }
    }

    public Node parse(InputStream is, String charEncoding) throws SAXException, ParseException, IOException {
        if (charEncoding == null) {
            this.isReader = new InputStreamReader(is);
        } else {
            this.encoding = charEncoding;
            this.isReader = new InputStreamReader(is, charEncoding);
        }
        Node result = this.parse(this.isReader);
        try {
            is.close();
        }
        catch (Exception exception) {}
        return result;
    }

    public Node parseSwitchEnc(InputStream is) throws ParseException, IOException, SAXException {
        return this.parseSwitchEnc(is, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node parseSwitchEnc(InputStream is, String defaultEncoding) throws SAXException, ParseException, IOException {
        Node node;
        block14: {
            Node node2;
            this.ris = new RereadableInputStream(is);
            this.setDocumentHandler(new CharsetHandler(this, this.ris));
            try {
                if (defaultEncoding == null) {
                    this.isReader = new InputStreamReader(this.ris);
                } else {
                    this.encoding = defaultEncoding;
                    this.isReader = new InputStreamReader((InputStream)this.ris, defaultEncoding);
                }
                node2 = this.parse(this.isReader);
            }
            catch (EncodingException e) {
                try {
                    if (this.setDOMImplementation(this.getDOMImplementation()) == null) {
                        Document doc = this.getDocument();
                        while (doc.hasChildNodes()) {
                            doc.removeChild(doc.getFirstChild());
                        }
                    }
                    this.init();
                    this.encoding = e.getNewReader().getEncoding();
                    node = this.parse(e.getNewReader());
                    break block14;
                }
                catch (Throwable throwable) {
                    try {
                        is.close();
                        throw throwable;
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
            }
            try {
                is.close();
                return node2;
            }
            catch (Exception exception) {}
            return node2;
        }
        try {
            is.close();
            return node;
        }
        catch (Exception exception) {}
        return node;
    }

    protected Document createDocument(DocumentType docType) {
        DOMImplementation domImpl = this.getDOMImplementation();
        try {
            if (!(domImpl instanceof HTMLDOMImplementation)) {
                return super.createDocument(docType);
            }
        }
        catch (Error error) {
            return super.createDocument(docType);
        }
        HTMLDocument ret = ((HTMLDOMImplementation)domImpl).createHTMLDocument("dummy");
        if (ret.getDocumentElement() != null) {
            ret.removeChild(ret.getDocumentElement());
        }
        if (docType != null) {
            try {
                ret.insertBefore(docType, null);
            }
            catch (DOMException dOMException) {}
        }
        return ret;
    }

    public String getEncoding() {
        return this.encoding;
    }

    void setEncoding(String enc) {
        this.encoding = enc;
    }

    private static void usage() {
        System.out.println("usage java org.eclipse.actf.model.dom.html.parser.HTMLParser [-w[#]] [-d] [-e encoding] [-c] files...");
        System.exit(1);
    }

    protected String getDefaultTopElement() {
        return "HTML";
    }
}

