/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.dombycom.impl.object;

import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.model.dom.dombycom.impl.NodeImpl;
import org.eclipse.actf.model.dom.dombycom.impl.object.MediaObjectImpl;
import org.eclipse.actf.util.win32.comclutch.DispatchException;
import org.eclipse.actf.util.win32.comclutch.IDispatch;

class QTNodeImpl
extends MediaObjectImpl {
    boolean pause = false;
    private INodeExVideo.VideoState currentState = INodeExVideo.VideoState.STATE_UNKNOWN;

    QTNodeImpl(NodeImpl baseNode, IDispatch inode) {
        super(baseNode, inode);
    }

    private Object exec0(String cmd) {
        try {
            return this.inode.invoke0(cmd);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    private Object exec1(String cmd, Object obj) {
        try {
            return this.inode.invoke1(cmd, obj);
        }
        catch (DispatchException dispatchException) {
            return null;
        }
    }

    public boolean getMuteState() {
        Object bool = this.exec0("GetMute");
        if (bool != null) {
            return (Integer)bool != 0;
        }
        return false;
    }

    public int getVolume() {
        Object volume = this.exec0("GetVolume");
        if (volume != null) {
            return (Integer)volume * 1000 / 256;
        }
        return 0;
    }

    public boolean muteMedia(boolean flag) {
        this.exec1("setMute", flag);
        return true;
    }

    public boolean setVolume(int val) {
        int volume = val * 256 / 1000;
        this.exec1("SetVolume", volume);
        return true;
    }

    public boolean fastForward() {
        return false;
    }

    public boolean fastReverse() {
        this.exec0("Rewind");
        return true;
    }

    public double getCurrentPosition() {
        Object time = this.exec0("GetTime");
        Object scale = this.exec0("GetTimeScale");
        if (time != null) {
            return ((Integer)time).doubleValue() / ((Integer)scale).doubleValue();
        }
        return 0.0;
    }

    public INodeExVideo.VideoState getCurrentState() {
        return this.currentState;
    }

    public double getTotalLength() {
        return 0.0;
    }

    public boolean nextTrack() {
        return false;
    }

    public boolean pauseMedia() {
        if (this.currentState == INodeExVideo.VideoState.STATE_PAUSE) {
            return this.playMedia();
        }
        this.exec0("Stop");
        this.currentState = INodeExVideo.VideoState.STATE_PAUSE;
        return true;
    }

    public boolean playMedia() {
        this.exec0("Play");
        this.currentState = INodeExVideo.VideoState.STATE_PLAY;
        return true;
    }

    public boolean previousTrack() {
        return false;
    }

    public boolean stopMedia() {
        this.exec0("Stop");
        this.exec1("SetTime", 0);
        this.currentState = INodeExVideo.VideoState.STATE_STOP;
        return true;
    }
}

