/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class JapaneseEncodingDetector {
    private static final int J_SJIS = 0;
    private static final int J_EUC = 1;
    private static final int J_JIS = 2;
    private static final int J_MIX = 3;
    private static final int J_UTF8 = 4;
    private static final int LATIN1 = 5;
    private static final String JIS = "ISO-2022-JP";
    private static final String EUC = "EUC-JP";
    private static final String SJIS = "Shift_JIS";
    private static final String UTF_8 = "UTF8";
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final byte JIS_ESCAPE = 27;
    private static final byte JIS_DOUBLE = 36;
    private static final byte JIS_SINGLE = 40;
    private static final byte JIS_B = 66;
    private static final byte JIS_AT = 64;
    private static final byte JIS_D = 68;
    private static final byte JIS_J = 74;
    private static final byte JIS_I = 73;
    private static final byte JIS_KANA_PAYLOAD_BEGIN = 33;
    private static final byte JIS_KANA_PAYLOAD_END = 95;
    private static final byte JIS_D_PAYLOAD_BEGIN = 33;
    private static final byte JIS_D_PAYLOAD_END = 126;
    private static final byte E_KANA_1ST = -114;
    private static final byte E_HOJO_1ST = -113;
    private static final byte E_KISYU_1ST = -96;
    private static final byte E_KANJI_BEGIN = -95;
    private static final byte E_KANJI_END = -2;
    private static final byte E_KANA_BEGIN = -95;
    private static final byte E_KANA_END = -33;
    private static final byte E_PAYLOAD_BEGIN = -96;
    private static final byte E_PAYLOAD_END = -1;
    private static final byte S1st1begin = -127;
    private static final byte S1st1end = -97;
    private static final byte S1st2begin = -32;
    private static final byte S1st2end = -17;
    private static final byte S2nd1begin = 64;
    private static final byte S2nd1end = 126;
    private static final byte S2nd2begin = -128;
    private static final byte S2nd2end = -4;
    private static final byte Skanabegin = -95;
    private static final byte Skanaend = -33;
    private static final byte ASCII_BEGIN = 0;
    private static final byte ASCII_END = 127;
    private static final byte U_2BYTE_BEGIN = -64;
    private static final byte U_2BYTE_END = -33;
    private static final byte U_3BYTE_BEGIN = -32;
    private static final byte U_3BYTE_END = -17;
    private static final byte U_4BYTE_BEGIN = -16;
    private static final byte U_4BYTE_END = -9;
    private static final byte U_PAYLOAD_BEGIN = -128;
    private static final byte U_PAYLOAD_END = -65;
    private static final byte LATIN_BEGIN = -96;
    private static final byte LATIN_END = -1;
    private byte[] buf = new byte[8192];
    private int length;
    private int errorJIS;
    private int errorUTF8;
    private int errorLATIN1;
    private int errorSJIS;
    private int errorEUC;
    private InputStream is;
    private Vector<Integer> eucRemoveV = new Vector();

    public JapaneseEncodingDetector(InputStream is) {
        this.is = is;
    }

    private String toString(int ret) {
        switch (ret) {
            case 4: {
                return UTF_8;
            }
            case 2: {
                return JIS;
            }
            case 1: {
                return EUC;
            }
            case 5: {
                return ISO_8859_1;
            }
        }
        return SJIS;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.length);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getByteArray() {
        byte[] bytebuf = new byte[this.length];
        System.arraycopy(this.buf, 0, bytebuf, 0, this.length);
        return bytebuf;
    }

    private void removeKisyuIzonEUC() {
        int i = this.eucRemoveV.size() - 1;
        while (i > -1) {
            byte[] bytebuf = new byte[this.length - 2];
            int index = this.eucRemoveV.get(i);
            System.arraycopy(this.buf, 0, bytebuf, 0, index);
            System.arraycopy(this.buf, index + 2, bytebuf, index, this.length - index - 2);
            this.buf = bytebuf;
            this.length -= 2;
            --i;
        }
    }

    private boolean isJIS(byte[] target, int length) {
        int index = 0;
        boolean inSingle = true;
        boolean inKana = false;
        boolean inKanji = false;
        boolean hasEscape = false;
        byte b = this.buf[index];
        while (index < length) {
            if (b == 27 && index + 2 < length) {
                byte c = this.buf[index + 1];
                byte d = this.buf[index + 2];
                if (c == 40) {
                    switch (d) {
                        case 66: 
                        case 74: {
                            inSingle = true;
                            inKana = false;
                            inKanji = false;
                            index += 3;
                            hasEscape = true;
                            break;
                        }
                        case 73: {
                            inKana = true;
                            inSingle = false;
                            inKanji = false;
                            index += 3;
                            hasEscape = true;
                            break;
                        }
                        default: {
                            ++this.errorJIS;
                            ++index;
                            break;
                        }
                    }
                } else if (c == 36) {
                    switch (d) {
                        case 64: 
                        case 66: 
                        case 68: {
                            inKanji = true;
                            inSingle = false;
                            inKana = false;
                            index += 3;
                            hasEscape = true;
                            break;
                        }
                        default: {
                            ++this.errorJIS;
                            ++index;
                            break;
                        }
                    }
                } else {
                    ++this.errorJIS;
                    ++index;
                }
            } else if (inKanji && index + 1 < length && this.isPayloadJISkanji(b) && this.isPayloadJISkanji(this.buf[index + 1])) {
                index += 2;
            } else if (inSingle && this.isASCII(b)) {
                ++index;
            } else if (inKana && this.isPayloadJISkana(b)) {
                ++index;
            } else {
                ++this.errorJIS;
                ++index;
            }
            b = this.buf[index];
        }
        return this.errorJIS == 0 && hasEscape;
    }

    private boolean isUTF8(byte[] target, int length) {
        int index = 0;
        byte b = this.buf[index];
        while (index < length) {
            if (this.isASCII(b)) {
                ++index;
            } else if (this.is2byteUTF8(b) && index + 1 < length) {
                if (this.isPayloadUTF8(this.buf[index + 1])) {
                    index += 2;
                } else {
                    ++this.errorUTF8;
                    ++index;
                }
            } else if (this.is3byteUTF8(b) && index + 2 < length) {
                if (this.isPayloadUTF8(this.buf[index + 1]) && this.isPayloadUTF8(this.buf[index + 2])) {
                    index += 3;
                } else {
                    ++this.errorUTF8;
                    ++index;
                }
            } else if (this.is4byteUTF8(b) && index + 3 < length) {
                if (this.isPayloadUTF8(this.buf[index + 1]) && this.isPayloadUTF8(this.buf[index + 2]) && this.isPayloadUTF8(this.buf[index + 3])) {
                    index += 4;
                } else {
                    ++this.errorUTF8;
                    ++index;
                }
            } else {
                ++this.errorUTF8;
                ++index;
            }
            b = this.buf[index];
        }
        return this.errorUTF8 == 0;
    }

    private boolean isLATIN1(byte[] target, int length) {
        int index = 0;
        byte b = this.buf[index];
        while (index < length) {
            if (this.isASCII(b) || this.isLATIN1(b)) {
                ++index;
            } else {
                ++index;
                ++this.errorLATIN1;
            }
            b = this.buf[index];
        }
        return this.errorLATIN1 == 0;
    }

    private boolean isSJIS(byte[] target, int length) {
        int index = 0;
        byte b = this.buf[index];
        while (index < length) {
            if (this.isASCII(b) || this.isSJISkana(b)) {
                ++index;
            } else if (this.isSJIS1st(b) && index + 1 < length) {
                if (this.isSJIS2nd(this.buf[index + 1])) {
                    index += 2;
                } else {
                    ++index;
                    ++this.errorSJIS;
                }
            } else {
                ++index;
                ++this.errorSJIS;
            }
            b = this.buf[index];
        }
        return this.errorSJIS == 0;
    }

    private boolean isEUC(byte[] target, int length) {
        int index = 0;
        byte b = this.buf[index];
        while (index < length) {
            if (this.isASCII(b)) {
                ++index;
            } else if (this.isEUCkanji(b) && index + 1 < length) {
                if (this.isPayloadEUC(this.buf[index + 1])) {
                    index += 2;
                } else {
                    ++index;
                    ++this.errorEUC;
                }
            } else if (this.isEUCkana(b) && index + 1 < length) {
                if (this.isKanaPayloadEUC(this.buf[index + 1])) {
                    index += 2;
                } else {
                    ++index;
                    ++this.errorEUC;
                }
            } else if (this.isEUChojo(b) && index + 2 < length) {
                if (this.isPayloadEUC(this.buf[index + 1]) && this.isPayloadEUC(this.buf[index + 2])) {
                    index += 3;
                } else {
                    ++index;
                    ++this.errorEUC;
                }
            } else if (this.isEUCKisyu(b) && index + 1 < length) {
                if (this.isPayloadEUC(this.buf[index + 1])) {
                    this.eucRemoveV.add(new Integer(index));
                    index += 2;
                } else {
                    ++index;
                    ++this.errorEUC;
                }
            } else {
                ++index;
                ++this.errorEUC;
            }
            b = this.buf[index];
        }
        return this.errorEUC == 0;
    }

    public String detect() throws IOException {
        this.length = 0;
        this.errorJIS = 0;
        this.errorUTF8 = 0;
        this.errorLATIN1 = 0;
        this.errorSJIS = 0;
        this.errorEUC = 0;
        int len = this.is.read(this.buf, this.length, this.buf.length - this.length);
        while (len > 0) {
            this.length += len;
            if (this.length == this.buf.length) {
                byte[] newBuf = new byte[this.length + 8192];
                System.arraycopy(this.buf, 0, newBuf, 0, this.length);
                this.buf = newBuf;
            }
            len = this.is.read(this.buf, this.length, this.buf.length - this.length);
        }
        int ret = 0;
        if (this.isJIS(this.buf, this.length)) {
            ret = 2;
            return this.toString(ret);
        }
        if (this.isUTF8(this.buf, this.length)) {
            ret = 4;
            return this.toString(ret);
        }
        if (this.isSJIS(this.buf, this.length)) {
            ret = 0;
            return this.toString(ret);
        }
        if (this.isEUC(this.buf, this.length)) {
            ret = 1;
            this.removeKisyuIzonEUC();
            return this.toString(ret);
        }
        if (this.isLATIN1(this.buf, this.length)) {
            ret = 5;
            return this.toString(ret);
        }
        ret = 4;
        if (this.errorSJIS < 100 && this.errorSJIS < this.errorEUC && this.errorSJIS < this.errorUTF8 && this.errorSJIS < this.errorLATIN1 && this.errorSJIS < this.errorJIS) {
            ret = 0;
        } else if (this.errorEUC < 100 && this.errorEUC < this.errorSJIS && this.errorEUC < this.errorUTF8 && this.errorEUC < this.errorLATIN1 && this.errorEUC < this.errorJIS) {
            this.removeKisyuIzonEUC();
            ret = 1;
        } else if (this.errorLATIN1 < 100 && this.errorLATIN1 < this.errorSJIS && this.errorLATIN1 < this.errorEUC && this.errorLATIN1 < this.errorUTF8 && this.errorLATIN1 < this.errorJIS) {
            ret = 5;
        } else if (this.errorJIS < 100 && this.errorJIS < this.errorSJIS && this.errorJIS < this.errorEUC && this.errorJIS < this.errorUTF8 && this.errorJIS < this.errorLATIN1) {
            ret = 2;
        }
        return this.toString(ret);
    }

    private boolean isPayloadJISkanji(byte c) {
        return 33 <= c && c <= 126;
    }

    private boolean isPayloadJISkana(byte c) {
        return 33 <= c && c <= 95;
    }

    private boolean isEUCkana(byte c) {
        return c == -114;
    }

    private boolean isEUCkanji(byte c) {
        return -95 <= c && c <= -2;
    }

    private boolean isEUChojo(byte c) {
        return c == -113;
    }

    private boolean isEUCKisyu(byte c) {
        return c == -96;
    }

    private boolean isEUC1st(byte c) {
        return c == -114 || c == -113 || -95 <= c && c <= -2;
    }

    private boolean isPayloadEUC(byte c) {
        return -96 <= c && c <= -1;
    }

    private boolean isKanaPayloadEUC(byte c) {
        return -95 <= c && c <= -33;
    }

    private boolean isSJIS1st(byte c) {
        return -127 <= c && c <= -97 || -32 <= c && c <= -17;
    }

    private boolean isSJISkana(byte c) {
        return -95 <= c && c <= -33;
    }

    private boolean isSJIS2nd(byte c) {
        return 64 <= c && c <= 126 || -128 <= c && c <= -4;
    }

    private boolean isASCII(byte c) {
        return c >= 0 && c <= 127;
    }

    private boolean isLATIN1(byte c) {
        return -96 <= c && c <= -1;
    }

    private boolean is2byteUTF8(byte c) {
        return -64 <= c && c <= -33;
    }

    private boolean is3byteUTF8(byte c) {
        return -32 <= c && c <= -17;
    }

    private boolean is4byteUTF8(byte c) {
        return -16 <= c && c <= -9;
    }

    private boolean isPayloadUTF8(byte c) {
        return -128 <= c && c <= -65;
    }
}

