/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.rec;

import java.util.ArrayList;
import org.eclipse.actf.ai.xmlstore.nvdl.dispatcher.NVDLAttributes;
import org.eclipse.actf.ai.xmlstore.nvdl.fm.ActionList;
import org.eclipse.actf.ai.xmlstore.nvdl.fm.PDA;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;
import org.eclipse.actf.ai.xmlstore.nvdl.rec.NVDLReconstructionException;
import org.eclipse.actf.ai.xmlstore.nvdl.util.PrefixMapper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXReconstructor {
    private final NVDLRules rules;
    private final PDA pda;
    private ContentHandler output;
    private ArrayList<Input> inputs = new ArrayList();
    private NVDLElement currentElement;
    private ActionList requestActionList;
    private String waitingASNID;
    private ArrayList<Attr> resultASNAttributes;
    private PrefixMapper prefixMapper = new PrefixMapper();
    private Input responsedInput;
    private boolean finished;
    private ArrayList<Input> activeInputList = new ArrayList();

    public void reset() {
        this.currentElement = null;
        this.pda.reset();
    }

    private NVDLElement createNVDLElement(String ns, String localName) {
        return new NVDLElement(ns, localName, this.currentElement, this.rules.getTriggerManager(), 0);
    }

    private boolean checkAndWaitInactive() {
        int size = this.inputs.size();
        int i = 0;
        while (i < size) {
            Input input = this.inputs.get(i);
            if (input.active) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                return false;
            }
            ++i;
        }
        return true;
    }

    private synchronized void waitForInputReady() {
        while (!this.checkAndWaitInactive()) {
        }
    }

    private Input selectInput() {
        int size = this.inputs.size();
        Input selectedInput = null;
        int score = -1;
        int i = 0;
        while (i < size) {
            Input input = this.inputs.get(i);
            if (this.waitingASNID != null) {
                if (this.waitingASNID.equals(input.getExposingASNID())) {
                    this.resultASNAttributes = input.getASNAttributes();
                    this.waitingASNID = null;
                    return this.responsedInput;
                }
            } else {
                int cscore;
                NVDLElement tryElement;
                PDA.MatchResult mr;
                ActionList al = input.getActionList();
                if (al != null && (this.requestActionList == null || this.requestActionList.getCount() == al.getCount()) && (mr = this.pda.matchActionList(tryElement = input.retrieveNextElement(), al)) == PDA.MatchResult.MATCH && score < (cscore = al.getPrecedence())) {
                    selectedInput = input;
                    score = cscore;
                    System.err.println("Select(" + tryElement.ns + "):" + tryElement.localName);
                    System.err.println(al);
                    break;
                }
            }
            ++i;
        }
        return selectedInput;
    }

    private Input popActiveInput() {
        int idx = this.activeInputList.size();
        if (idx == 1) {
            return null;
        }
        this.activeInputList.remove(--idx);
        return this.activeInputList.get(--idx);
    }

    private Input getLastActiveInput() {
        int idx = this.activeInputList.size();
        if (idx == 0) {
            return null;
        }
        return this.activeInputList.get(0);
    }

    private synchronized void startWorkerManage() throws NVDLReconstructionException {
        while (true) {
            Input input;
            if (this.finished) {
                input = this.popActiveInput();
            } else {
                input = this.selectInput();
                if (input != null) {
                    this.activeInputList.add(input);
                } else {
                    StringBuffer buf = new StringBuffer("No Reconstruction Candidate:");
                    if (this.requestActionList != null) {
                        buf.append(this.requestActionList.toString());
                    }
                    System.err.println(buf);
                    if (this.output instanceof LexicalHandler) {
                        char[] bufch = buf.toString().toCharArray();
                        try {
                            ((LexicalHandler)((Object)this.output)).comment(bufch, 0, bufch.length);
                        }
                        catch (SAXException sAXException) {}
                    }
                    input = this.getLastActiveInput();
                }
            }
            if (input == null) {
                return;
            }
            input.notifyActivation(true);
            this.responsedInput = null;
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            } while (this.responsedInput == null);
        }
    }

    private synchronized void notifyCompletion(Input input, boolean finished) {
        this.finished = finished;
        this.responsedInput = input;
        this.notify();
    }

    public ContentHandler requestInput() {
        Input input = new Input();
        this.inputs.add(input);
        return input;
    }

    public void setOutput(ContentHandler output) {
        this.output = output;
    }

    public void start() throws NVDLReconstructionException, SAXException {
        this.output.startDocument();
        this.waitForInputReady();
        this.startWorkerManage();
        this.output.endDocument();
    }

    public SAXReconstructor(NVDLRules rules) {
        this.rules = rules;
        this.pda = new PDA(rules);
    }

    private class Attr {
        final String ns;
        final String prefix;
        final String localName;
        final String value;

        Attr(String ns, String qName, String value) {
            this.ns = ns;
            this.value = value;
            int idx = qName.indexOf(58);
            if (idx < 0) {
                this.localName = qName;
                this.prefix = "";
            } else {
                this.localName = qName.substring(idx + 1);
                this.prefix = qName.substring(0, idx);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Input
    extends DefaultHandler {
        private boolean skipToNextElement;
        private String nextNS;
        private String localName;
        private PrefixEntry prefixList = null;
        private boolean active = true;
        private boolean finish;
        private boolean activationFlag;
        private ActionList actionList;
        private String exposingASNID;
        private ArrayList<Attr> asnAttributes;
        private String lastID;
        private boolean isInSlotNode;
        private int secLevel;
        private ArrayList<Integer> secLevelStack = new ArrayList();

        private Input() {
        }

        private void setupNextElement(String ns, String localName) {
            this.nextNS = ns;
            this.localName = localName;
        }

        public NVDLElement retrieveNextElement() {
            return SAXReconstructor.this.createNVDLElement(this.nextNS, this.localName);
        }

        private void storePrefixMapping(String prefix, String ns) {
            SAXReconstructor.this.prefixMapper.startPrefixMapping(prefix, ns);
            this.prefixList = new PrefixEntry(this.prefixList, prefix, ns);
        }

        private void sendStartPrefixMapping() throws SAXException {
            PrefixEntry pe = this.prefixList;
            this.prefixList = new PrefixEntry(this.prefixList);
            while (pe != null) {
                if (pe.prefix == null) {
                    return;
                }
                SAXReconstructor.this.output.startPrefixMapping(pe.prefix, pe.ns);
                pe = pe.prev;
            }
        }

        private void sendEndPrefixMapping() throws SAXException {
            PrefixEntry pe = this.prefixList;
            while (pe != null) {
                if (pe.prefix == null) {
                    this.prefixList = pe.prev;
                    return;
                }
                SAXReconstructor.this.prefixMapper.endPrefixMapping(pe.prefix);
                SAXReconstructor.this.output.endPrefixMapping(pe.prefix);
                pe = pe.prev;
            }
            this.prefixList = null;
        }

        private void notifyCompletion(boolean finished) {
            SAXReconstructor.this.notifyCompletion(this, finished);
        }

        private synchronized boolean block(boolean finished) throws SAXException {
            this.active = false;
            this.notifyCompletion(finished);
            do {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
                if (!this.finish) continue;
                throw new SAXException("Finished");
            } while (!this.active);
            return this.activationFlag;
        }

        synchronized void notifyActivation(boolean flag) {
            this.active = true;
            this.activationFlag = flag;
            this.notify();
        }

        synchronized void notifyFinish() {
            this.finish = true;
            this.notify();
        }

        public ActionList getActionList() {
            return this.actionList;
        }

        public String getExposingASNID() {
            return this.exposingASNID;
        }

        public ArrayList<Attr> getASNAttributes() {
            return this.asnAttributes;
        }

        private ArrayList<Attr> waitASNAttributes(String asnID) throws SAXException {
            SAXReconstructor.this.waitingASNID = asnID;
            if (!this.block(false)) {
                return null;
            }
            return SAXReconstructor.this.resultASNAttributes;
        }

        private void pushSecLevel() {
            this.secLevelStack.add(this.secLevel);
        }

        private void popSecLevel() {
            int idx = this.secLevelStack.size() - 1;
            this.secLevel = this.secLevelStack.get(idx);
            this.secLevelStack.remove(idx);
        }

        private void setASNAttributes(Attributes attrs) {
            String asnID = attrs.getValue("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "asn-id");
            if (asnID == null) {
                return;
            }
            this.exposingASNID = asnID;
            this.asnAttributes = new ArrayList();
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                String ns = attrs.getURI(i);
                if (!ns.startsWith("http://purl.oclc.org/dsdl/nvdl/ns/instance")) {
                    String qName = attrs.getQName(i);
                    String value = attrs.getValue(i);
                    Attr a = new Attr(ns, qName, value);
                    this.asnAttributes.add(a);
                }
                ++i;
            }
        }

        private void emitStartElement(NVDLElement base, String uri, String localName, String qName, Attributes attrs) throws SAXException {
            String asnID = attrs.getValue("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "asn-id");
            if (asnID != null) {
                ArrayList<Attr> as = this.waitASNAttributes(asnID);
                NVDLAttributes newAttrs = new NVDLAttributes(base, attrs);
                for (Attr a : as) {
                    PrefixMapper.PrefixReturnVal prv = SAXReconstructor.this.prefixMapper.uniquePrefix(a.prefix, a.ns);
                    if (prv.requireDecl) {
                        this.storePrefixMapping(prv.prefix, a.ns);
                    }
                    String qNameA = String.valueOf(prv.prefix) + ":" + a.localName;
                    newAttrs.addExtAttribute(a.ns, a.localName, qNameA, a.value);
                }
                attrs = newAttrs;
            }
            this.sendStartPrefixMapping();
            SAXReconstructor.this.output.startElement(uri, localName, qName, attrs);
        }

        private void skippingElement() throws SAXException {
            if (this.skipToNextElement) {
                this.actionList = null;
                this.block(false);
                this.skipToNextElement = false;
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (!this.active) {
                return;
            }
            if (uri.equals("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0")) {
                if ("slot-node".equals(localName)) {
                    String id = attrs.getValue("", "slot-node-id");
                    if (id != null) {
                        this.lastID = id;
                    }
                    this.isInSlotNode = true;
                }
            } else if ("http://purl.oclc.org/dsdl/nvdl/ns/instance/1.0".equals(uri) && "virtualElement".equals(localName)) {
                this.setASNAttributes(attrs);
                this.active = false;
                this.notifyCompletion(false);
            } else {
                this.skippingElement();
                String id = attrs.getValue("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0", "sect-id");
                if (id != null) {
                    try {
                        this.actionList = new ActionList(SAXReconstructor.this.rules, id);
                    }
                    catch (ActionList.InvalidIdException e) {
                        throw new SAXException(e);
                    }
                    this.setupNextElement(uri, localName);
                    if (this.block(false)) {
                        SAXReconstructor.this.requestActionList = null;
                        SAXReconstructor.this.currentElement = this.retrieveNextElement();
                        this.emitStartElement(SAXReconstructor.this.currentElement, uri, localName, qName, attrs);
                        this.pushSecLevel();
                        this.secLevel = 0;
                        SAXReconstructor.this.pda.startElement(SAXReconstructor.this.currentElement);
                    }
                    return;
                }
                SAXReconstructor.this.currentElement = SAXReconstructor.this.createNVDLElement(uri, localName);
                this.emitStartElement(SAXReconstructor.this.currentElement, uri, localName, qName, attrs);
                ++this.secLevel;
                return;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.active) {
                return;
            }
            if (uri.equals("http://purl.oclc.org/dsdl/nvdl/ns/instance/2.0")) {
                if ("slot-node".equals(localName)) {
                    this.skippingElement();
                    try {
                        SAXReconstructor.this.requestActionList = new ActionList(SAXReconstructor.this.rules, this.lastID);
                    }
                    catch (ActionList.InvalidIdException e) {
                        throw new SAXException(e);
                    }
                    this.skipToNextElement = true;
                    this.skippingElement();
                }
            } else {
                this.skippingElement();
                SAXReconstructor.this.output.endElement(uri, localName, qName);
                this.sendEndPrefixMapping();
                if (this.secLevel == 0) {
                    SAXReconstructor.this.pda.endElement();
                    SAXReconstructor.this.currentElement = ((SAXReconstructor)SAXReconstructor.this).currentElement.parent;
                    this.popSecLevel();
                    this.block(true);
                } else {
                    SAXReconstructor.this.currentElement = ((SAXReconstructor)SAXReconstructor.this).currentElement.parent;
                    --this.secLevel;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.active) {
                return;
            }
            if (this.skipToNextElement) {
                return;
            }
            SAXReconstructor.this.output.characters(ch, start, length);
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (!this.active) {
                return;
            }
            if (this.skipToNextElement) {
                return;
            }
            SAXReconstructor.this.output.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            if (this.active) {
                this.notifyCompletion(true);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String ns) throws SAXException {
            this.storePrefixMapping(prefix, ns);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }
    }

    private class PrefixEntry {
        final String prefix;
        final String ns;
        final PrefixEntry prev;

        PrefixEntry(PrefixEntry prev, String prefix, String ns) {
            this.prev = prev;
            this.prefix = prefix;
            this.ns = ns;
        }

        PrefixEntry(PrefixEntry prev) {
            this.prev = prev;
            this.prefix = null;
            this.ns = null;
        }
    }
}

