/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.reader;

import java.util.List;
import org.eclipse.actf.ai.xmlstore.nvdl.model.Location;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLActionManager;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelTraverse;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLNoResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRejectAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.NVDLReaderException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NVDLSimplifier
extends NVDLModelTraverse {
    private NVDLRules rules;
    private NVDLMode currentMode;
    private ErrorHandler eh;
    private int errorCounter;

    private void error(NVDLModel m, String mes) throws NVDLModelException {
        this.error(m, mes, new Object[0]);
    }

    private void error(NVDLModel m, String mes, Object[] args) throws NVDLModelException {
        this.error(m, new NVDLReaderException(mes, args));
    }

    private void error(NVDLModel m, NVDLReaderException e) throws NVDLModelException {
        ++this.errorCounter;
        Location l = m.getLocation();
        try {
            this.eh.error(new SAXParseException(e.getMessage(), "", l.iri, l.line, l.pos, e));
        }
        catch (SAXException se) {
            throw new NVDLModelException(se);
        }
    }

    private String generateUniqueActionID() {
        String id;
        int i = 1;
        while (this.rules.getAction(id = "N" + i) != null) {
            ++i;
        }
        return id;
    }

    private void addDefaultAnyNamespace(NVDLMode mode) {
        NVDLAction a;
        String id;
        NVDLActionManager am;
        NVDLRule r;
        if (mode.getAnyNamespaceRuleForElement() == null) {
            r = new NVDLRule(true, "", ' ', true, false);
            am = r.getActionManager();
            id = this.generateUniqueActionID();
            a = new NVDLRejectAction(id, mode.name, r);
            r.copyLocation(mode);
            a.copyLocation(mode);
            a.setUseMode(mode);
            am.addNoResultAction((NVDLNoResultAction)a);
            mode.addRule(r);
        }
        if (mode.getAnyNamespaceRuleForAttribute() == null) {
            r = new NVDLRule(true, "", ' ', false, true);
            am = r.getActionManager();
            id = this.generateUniqueActionID();
            a = new NVDLResultAction(id, mode.name, 1, r);
            r.copyLocation(mode);
            a.copyLocation(mode);
            a.setUseMode(mode);
            am.setResultAction((NVDLResultAction)a);
            mode.addRule(r);
        }
    }

    public NVDLModel visitNVDLMode(NVDLMode mode) throws NVDLModelException {
        if (this.checkTraversed(mode)) {
            return null;
        }
        this.currentMode = mode;
        mode.simplifyInclusion();
        this.addDefaultAnyNamespace(mode);
        return super.visitNVDLMode(mode);
    }

    private void setUseMode(NVDLAction action) throws NVDLModelException {
        if (action.getUseMode() == null) {
            String useModeName = action.getUseModeName();
            if (useModeName == null) {
                action.setUseMode(this.currentMode);
            } else {
                NVDLMode mode = this.rules.getMode(useModeName);
                if (mode == null) {
                    this.error(action, "NVDLSimplifier.ModeIsNotDefinedError", new Object[]{useModeName});
                }
                action.setUseMode(mode);
            }
        }
        List<NVDLAction.Context> contexts = action.getContextsList();
        for (NVDLAction.Context c : contexts) {
            if (c.useMode != null) continue;
            assert (c.useModeName != null);
            NVDLMode mode = this.rules.getMode(c.useModeName);
            if (mode == null) {
                this.error(action, "NVDLSimplifier.ModeIsNotDefinedError", new Object[]{c.useModeName});
            }
            c.useMode = mode;
        }
    }

    public NVDLModel visitNVDLNoResultAction(NVDLNoResultAction action) throws NVDLModelException {
        if (this.checkTraversed(action)) {
            return null;
        }
        this.setUseMode(action);
        return super.visitNVDLNoResultAction(action);
    }

    public NVDLModel visitNVDLResultAction(NVDLResultAction action) throws NVDLModelException {
        if (this.checkTraversed(action)) {
            return null;
        }
        this.setUseMode(action);
        return super.visitNVDLResultAction(action);
    }

    public NVDLModel visitNVDLRules(NVDLRules rules) throws NVDLModelException {
        if (rules.getStartMode() == null) {
            String name = rules.getStartModeName();
            if (name == null) {
                this.error((NVDLModel)rules, "NVDLSimplifier.RulesHasNoStartModeError");
            } else {
                NVDLMode mode = rules.getMode(name);
                if (mode == null) {
                    this.error(rules, "NVDLSimplifier.StartModeIsNotDefinedError", new Object[]{name});
                }
                rules.setStartMode(mode);
            }
        }
        return super.visitNVDLRules(rules);
    }

    public int getErrorCount() {
        return this.errorCounter;
    }

    public NVDLSimplifier(NVDLRules rules, ErrorHandler eh) {
        this.rules = rules;
        this.eh = eh;
        this.errorCounter = 0;
    }
}

