/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLActionManager;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModel;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLModelVisitor;

public class NVDLRule
extends NVDLModel {
    private final boolean anyNamespace;
    private final String ns;
    private final Pattern nsPattern;
    private final char wildCardChar;
    private final boolean targetElement;
    private final boolean targetAttribute;
    private NVDLActionManager actionManager = new NVDLActionManager();

    public boolean isAnyNamespace() {
        return this.anyNamespace;
    }

    public boolean isTargetElement() {
        return this.targetElement;
    }

    public boolean isTargetAttribute() {
        return this.targetAttribute;
    }

    public boolean isConflicted(NVDLRule rule) {
        if (this.anyNamespace || rule.anyNamespace) {
            return this.anyNamespace == rule.anyNamespace && (this.isTargetElement() == rule.isTargetElement() || this.isTargetAttribute() == rule.isTargetAttribute());
        }
        return false;
    }

    public boolean isOverridden(NVDLRule rule) {
        if (this.targetElement != rule.targetElement || this.targetAttribute != rule.targetAttribute) {
            return false;
        }
        if (this.isAnyNamespace()) {
            return rule.isAnyNamespace();
        }
        return this.wildCardChar == rule.wildCardChar && this.ns.equals(rule.ns);
    }

    public boolean match(String ns, boolean targetElement) {
        if (targetElement ? !this.isTargetElement() : !this.isTargetAttribute()) {
            return false;
        }
        if (this.anyNamespace) {
            return true;
        }
        if (this.nsPattern == null) {
            return this.ns.equals(ns);
        }
        Matcher m = this.nsPattern.matcher(ns);
        return m.matches();
    }

    public NVDLModel visitModel(NVDLModelVisitor v) throws NVDLModelException {
        return v.visitNVDLRule(this);
    }

    public NVDLActionManager getActionManager() {
        return this.actionManager;
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        if (this.anyNamespace) {
            r.append("AnyNamespace");
        } else {
            r.append("NS={");
            r.append(this.ns);
            r.append("},W=");
            r.append(this.wildCardChar);
        }
        return r.toString();
    }

    private String quote(String pat, char wildCardChar) {
        StringBuffer r = new StringBuffer();
        int i = 0;
        while (i < pat.length()) {
            char c = pat.charAt(i);
            if (c == wildCardChar) {
                r.append(".*");
            } else if ("\\?*+.[]{}()$^".indexOf(c) >= 0) {
                r.append('\\');
                r.append(c);
            } else {
                r.append(c);
            }
            ++i;
        }
        return r.toString();
    }

    public NVDLRule(boolean anyNamespace, String ns, char wildCardChar, boolean targetElement, boolean targetAttribute) {
        assert (targetElement || targetAttribute);
        this.anyNamespace = anyNamespace;
        if (!anyNamespace) {
            this.ns = ns;
            this.nsPattern = ns.indexOf(wildCardChar) > 0 ? Pattern.compile(this.quote(ns, wildCardChar)) : null;
        } else {
            this.ns = null;
            this.nsPattern = null;
        }
        this.wildCardChar = wildCardChar;
        this.targetElement = targetElement;
        this.targetAttribute = targetAttribute;
    }
}

