/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.fm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.actf.ai.xmlstore.nvdl.fm.ActionList;
import org.eclipse.actf.ai.xmlstore.nvdl.fm.Interpretation;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLActionManager;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAttributeSection;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLMode;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLNoResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLResultAction;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRule;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLRules;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDA {
    private ArrayList<StackElement> currentContext = new ArrayList();
    private ArrayList<StackElement> nextContext = new ArrayList();
    private boolean isAttributeAttached;
    private final State initialState;

    private void finishTransition() {
        this.currentContext = this.nextContext;
        this.nextContext = new ArrayList(this.currentContext.size());
    }

    private boolean nextStateTransition(StackElement stack, NVDLElement e) {
        boolean firstBranch = true;
        State[] nextStates = stack.state.next(e.parent, e.ns, true);
        int i = 0;
        while (i < nextStates.length) {
            StackElement newStack = StackElement.newEffectiveStackElement(stack, nextStates[i], e, firstBranch);
            this.nextContext.add(newStack);
            firstBranch = false;
            ++i;
        }
        return nextStates.length > 0;
    }

    public boolean startElement(NVDLElement e) {
        boolean flag = false;
        int size = this.currentContext.size();
        int i = 0;
        while (i < size) {
            StackElement stack = this.currentContext.get(i);
            if (!e.isSectionHead()) {
                StackElement se = StackElement.newNoneffectiveStackElement(stack, e);
                this.nextContext.add(se);
            } else {
                flag = this.nextStateTransition(stack, e);
            }
            ++i;
        }
        this.finishTransition();
        return flag;
    }

    public boolean endElement() {
        boolean flag = false;
        int size = this.currentContext.size();
        int i = 0;
        while (i < size) {
            StackElement stack = this.currentContext.get(i);
            if (stack.firstBranch) {
                StackElement parent = stack.parent;
                assert (parent != null);
                if (parent.state != stack.state) {
                    flag = true;
                }
                this.nextContext.add(parent);
            }
            ++i;
        }
        this.finishTransition();
        return flag;
    }

    public boolean isAttributeAttached() {
        return this.isAttributeAttached;
    }

    public List<Interpretation> getAttributeInterpretation(Interpretation current, NVDLAttributeSection as) {
        StackElement stack = (StackElement)current;
        this.isAttributeAttached = false;
        ArrayList<Interpretation> result = new ArrayList<Interpretation>();
        State[] nextStates = stack.state.next(as.getBaseElement(), as.getNamespace(), false);
        int i = 0;
        while (i < nextStates.length) {
            AttrInterpretation ai = AttrInterpretation.newAttrInterpretation(stack, nextStates[i]);
            if (ai.isDispatch()) {
                result.add(ai);
            }
            if (ai.isAttach()) {
                this.isAttributeAttached = true;
            }
            ++i;
        }
        assert (this.isAttributeAttached || result.size() > 0);
        return result;
    }

    public List getCurrentInterpretations() {
        return this.currentContext;
    }

    private boolean matchActionListWithStackElement(StackElement s, NVDLElement e, ActionList al) {
        List<NVDLAction> l = al.getActions();
        int lastIdx = l.size() - 1;
        int idx = lastIdx - 1;
        State state = s.state;
        while (s != null) {
            NVDLAction a = s.getAction();
            if (a != null) {
                if (idx < 0) {
                    return false;
                }
                NVDLAction a2 = l.get(idx);
                if (!a.equals(a2)) {
                    return false;
                }
                --idx;
            }
            s = s.parent;
        }
        NVDLAction a2 = l.get(lastIdx);
        State[] states = state.next(e.parent, e.ns, true);
        int i = 0;
        while (i < states.length) {
            if (a2.equals(states[i].action)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public MatchResult matchActionList(NVDLElement nextElement, ActionList al) {
        int size = this.currentContext.size();
        int i = 0;
        while (i < size) {
            StackElement s = this.currentContext.get(i);
            if (this.matchActionListWithStackElement(s, nextElement, al)) {
                return MatchResult.MATCH;
            }
            ++i;
        }
        return MatchResult.NOMATCH;
    }

    public void reset() {
        this.currentContext.clear();
        this.nextContext.clear();
        this.isAttributeAttached = false;
        StackElement initialStack = StackElement.newEffectiveStackElement(null, this.initialState, null, true);
        this.currentContext.add(initialStack);
    }

    public PDA(NVDLRules rules) {
        NVDLMode startMode = rules.getStartMode();
        Compiler compiler = new Compiler();
        this.initialState = compiler.compile(startMode);
        this.reset();
    }

    public PDA(PDA base) {
        this.initialState = base.initialState;
        this.reset();
    }

    private void dumpDest(Edge.Mode.Dest d, Set<State> traversed) {
        System.out.println(d.toString());
        int i = 0;
        while (i < d.nextStates.length) {
            this.dumpState(d.nextStates[i], traversed);
            ++i;
        }
    }

    private void dumpMode(Edge.Mode em, Set<State> traversed) {
        int i = 0;
        while (i < em.dests.length) {
            this.dumpDest(em.dests[i], traversed);
            ++i;
        }
    }

    private void dumpEdge(Edge edge, Set<State> traversed) {
        System.out.println(edge.toString());
        this.dumpMode(edge.nextMode, traversed);
    }

    private void dumpState(State state, Set<State> traversed) {
        System.out.println(state.toString());
        if (!traversed.contains(state)) {
            traversed.add(state);
            this.dumpEdge(state.defaultEdge, traversed);
            int i = 0;
            while (i < state.contextEdges.length) {
                this.dumpEdge(state.contextEdges[i], traversed);
                ++i;
            }
        }
        System.out.println("--------------------");
    }

    public void dump() {
        this.dumpState(this.initialState, new HashSet<State>());
    }

    private static class AttrInterpretation
    extends Interpretation {
        public final StackElement parent;

        public Interpretation getParent() {
            return this.parent;
        }

        private AttrInterpretation(NVDLMode mode, NVDLAction action, StackElement parent) {
            super(mode, action, null);
            this.parent = parent;
        }

        static AttrInterpretation newAttrInterpretation(StackElement parent, State state) {
            return new AttrInterpretation(state.mode, state.action, parent);
        }
    }

    private static class Compiler {
        private HashMap<StateDicKey, State> stateDic = new HashMap();

        private Compiler() {
        }

        private State getState(StateDicKey k) {
            return this.stateDic.get(k);
        }

        private State newState(StateDicKey k) {
            State s = new State(k.mode, k.action);
            this.stateDic.put(k, s);
            return s;
        }

        private Edge.Mode.Dest compileRule(NVDLRule rule, NVDLMode m) {
            NVDLActionManager am = rule.getActionManager();
            ArrayList<State> states = new ArrayList<State>();
            NVDLResultAction ra = am.getResultAction();
            if (ra != null) {
                states.add(this.compileToState(ra, m));
            }
            List nras = am.getNoResultActions();
            for (NVDLNoResultAction nra : nras) {
                states.add(this.compileToState(nra, m));
            }
            return new Edge.Mode.Dest(rule, states.toArray(new State[states.size()]));
        }

        private Edge.Mode compileToMode(NVDLMode m) {
            Edge.Mode.Dest d;
            NVDLRule rule;
            Edge.Mode em = new Edge.Mode();
            ArrayList<Edge.Mode.Dest> dests = new ArrayList<Edge.Mode.Dest>();
            Iterator it = m.notAnyNamespaceRuleIterator();
            while (it.hasNext()) {
                rule = (NVDLRule)it.next();
                d = this.compileRule(rule, m);
                dests.add(d);
            }
            rule = m.getAnyNamespaceRuleForAttribute();
            if (rule != null) {
                d = this.compileRule(rule, m);
                dests.add(d);
            }
            if ((rule = m.getAnyNamespaceRuleForElement()) != null) {
                d = this.compileRule(rule, m);
                dests.add(d);
            }
            em.dests = dests.toArray(new Edge.Mode.Dest[dests.size()]);
            return em;
        }

        private Edge compileToDefaultEdge(NVDLMode m) {
            Edge e = new Edge(null, this.compileToMode(m));
            return e;
        }

        private Edge[] compileToContextEdges(NVDLAction a) {
            List<NVDLAction.Context> contextsList = a.getContextsList();
            Edge[] contextEdges = new Edge[contextsList.size()];
            int i = 0;
            for (NVDLAction.Context c : contextsList) {
                contextEdges[i++] = new Edge(c, this.compileToMode(c.useMode));
            }
            return contextEdges;
        }

        private State compileToState(NVDLAction a, NVDLMode m) {
            StateDicKey k = new StateDicKey(m, a);
            State s = this.getState(k);
            if (s != null) {
                return s;
            }
            s = this.newState(k);
            if (a == null) {
                s.defaultEdge = this.compileToDefaultEdge(m);
            } else {
                s.contextEdges = this.compileToContextEdges(a);
                s.defaultEdge = this.compileToDefaultEdge(a.getUseMode());
            }
            return s;
        }

        State compile(NVDLMode startMode) {
            return this.compileToState(null, startMode);
        }

        static class StateDicKey {
            private NVDLMode mode;
            private NVDLAction action;

            public boolean equals(Object o) {
                if (!(o instanceof StateDicKey)) {
                    return false;
                }
                StateDicKey s = (StateDicKey)o;
                return this.mode.equals(s.mode) && this.action.equals(s.action);
            }

            public int hashCode() {
                if (this.action == null) {
                    return this.mode.hashCode();
                }
                return this.mode.hashCode() ^ this.action.hashCode();
            }

            StateDicKey(NVDLMode mode, NVDLAction action) {
                this.mode = mode;
                this.action = action;
            }
        }
    }

    private static class Edge {
        final NVDLAction.Context allowableContext;
        final Mode nextMode;

        boolean match(NVDLElement e) {
            return this.allowableContext.match(e);
        }

        Edge(NVDLAction.Context allowableContext, Mode nextMode) {
            this.allowableContext = allowableContext;
            this.nextMode = nextMode;
        }

        public String toString() {
            String ret = "Edge:";
            if (this.allowableContext != null) {
                return String.valueOf(ret) + this.allowableContext.toString();
            }
            return ret;
        }

        static class Mode {
            private Dest[] dests;

            Mode() {
            }

            public State[] nextStates(String ns, boolean isElement) {
                int i = 0;
                while (i < this.dests.length) {
                    if (this.dests[i].rule.match(ns, isElement)) {
                        return this.dests[i].nextStates;
                    }
                    ++i;
                }
                return null;
            }

            static class Dest {
                final NVDLRule rule;
                final State[] nextStates;

                Dest(NVDLRule rule, State[] nextStates) {
                    this.rule = rule;
                    this.nextStates = nextStates;
                }

                public String toString() {
                    return "Dest:" + this.rule.toString();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchResult {
        NOMATCH,
        POSSIBLE,
        MATCH;

    }

    private static class StackElement
    extends Interpretation {
        public final State state;
        public final StackElement parent;
        public final boolean firstBranch;

        public Interpretation getParent() {
            return this.parent;
        }

        private StackElement(NVDLMode mode, NVDLAction action, NVDLElement e, StackElement parent, State state, boolean firstBranch) {
            super(mode, action, e);
            this.parent = parent;
            this.state = state;
            this.firstBranch = firstBranch;
        }

        static StackElement newEffectiveStackElement(StackElement parent, State state, NVDLElement element, boolean firstBranch) {
            return new StackElement(state.mode, state.action, element, parent, state, firstBranch);
        }

        static StackElement newNoneffectiveStackElement(StackElement parent, NVDLElement element) {
            return new StackElement(null, null, element, parent, parent.state, true);
        }
    }

    private static class State {
        String id;
        Edge defaultEdge;
        Edge[] contextEdges;
        final NVDLMode mode;
        final NVDLAction action;

        private Edge.Mode nextMode(NVDLElement e) {
            assert (e != null || this.contextEdges == null);
            if (this.contextEdges != null) {
                int i = 0;
                while (i < this.contextEdges.length) {
                    if (this.contextEdges[i].match(e)) {
                        return this.contextEdges[i].nextMode;
                    }
                    ++i;
                }
            }
            return this.defaultEdge.nextMode;
        }

        State[] next(NVDLElement e, String ns, boolean isElement) {
            Edge.Mode nextMode = this.nextMode(e);
            return nextMode.nextStates(ns, isElement);
        }

        State(NVDLMode mode, NVDLAction action) {
            this.mode = mode;
            this.action = action;
        }

        String getID() {
            return this.id;
        }

        public String toString() {
            return "PDA State-ID:" + this.id + " Mode:" + this.mode + " Action:" + this.action;
        }
    }
}

