/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.dispatcher;

import java.util.ArrayList;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLAttributeSection;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLElement;
import org.xml.sax.Attributes;

public class NVDLAttributes
implements Attributes,
NVDLAttributeSection {
    private final String sectionNS;
    private final NVDLElement baseElement;
    private final Attributes base;
    private final ArrayList<Integer> indexes = new ArrayList();
    private ArrayList<ExtAttr> extAttrs;

    public int getLength() {
        int len = this.indexes.size();
        if (this.extAttrs == null) {
            return len;
        }
        return len + this.extAttrs.size();
    }

    public String getURI(int index) {
        if (this.isIndexBase(index)) {
            return this.base.getURI(this.baseIdx(index));
        }
        if (this.isIndexExt(index)) {
            ExtAttr ea = this.getExtAttr(index);
            return ea.uri;
        }
        return null;
    }

    public String getLocalName(int index) {
        if (this.isIndexBase(index)) {
            return this.base.getLocalName(this.baseIdx(index));
        }
        if (this.isIndexExt(index)) {
            ExtAttr ea = this.getExtAttr(index);
            return ea.localName;
        }
        return null;
    }

    public String getQName(int index) {
        if (this.isIndexBase(index)) {
            return this.base.getQName(this.baseIdx(index));
        }
        if (this.isIndexExt(index)) {
            ExtAttr ea = this.getExtAttr(index);
            return ea.qName;
        }
        return null;
    }

    public String getType(int index) {
        if (this.isIndexBase(index)) {
            return this.base.getType(this.baseIdx(index));
        }
        if (this.isIndexExt(index)) {
            return "CDATA";
        }
        return null;
    }

    public String getValue(int index) {
        if (this.isIndexBase(index)) {
            return this.base.getValue(this.baseIdx(index));
        }
        if (this.isIndexExt(index)) {
            ExtAttr ea = this.getExtAttr(index);
            return ea.value;
        }
        return null;
    }

    public int getIndex(String uri, String localName) {
        int baseIdx = this.base.getIndex(uri, localName);
        if (baseIdx >= 0) {
            return this.getIdx(baseIdx);
        }
        int len = this.extAttrs.size();
        int i = 0;
        while (i < len) {
            ExtAttr ea = this.extAttrs.get(i);
            if (uri.equals(ea.uri) && localName.equals(ea.localName)) {
                return this.indexes.size() + i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(String qName) {
        int baseIdx = this.base.getIndex(qName);
        if (baseIdx >= 0) {
            return this.getIdx(baseIdx);
        }
        int len = this.extAttrs.size();
        int i = 0;
        while (i < len) {
            ExtAttr ea = this.extAttrs.get(i);
            if (qName.equals(ea.qName)) {
                return this.indexes.size() + i;
            }
            ++i;
        }
        return -1;
    }

    public String getType(String uri, String localName) {
        int baseIdx = this.getIndex(uri, localName);
        if (baseIdx < 0) {
            return null;
        }
        return this.getType(baseIdx);
    }

    public String getType(String qName) {
        int baseIdx = this.getIndex(qName);
        if (baseIdx < 0) {
            return null;
        }
        return this.getType(baseIdx);
    }

    public String getValue(String uri, String localName) {
        int baseIdx = this.getIndex(uri, localName);
        if (baseIdx < 0) {
            return null;
        }
        return this.getValue(baseIdx);
    }

    public String getValue(String qName) {
        int baseIdx = this.getIndex(qName);
        if (baseIdx < 0) {
            return null;
        }
        return this.getValue(baseIdx);
    }

    private int baseIdx(int idx) {
        Integer iv = this.indexes.get(idx);
        return iv;
    }

    private boolean isIndexBase(int idx) {
        return idx >= 0 && idx < this.indexes.size();
    }

    private boolean isIndexExt(int idx) {
        if (this.extAttrs == null) {
            return false;
        }
        int baseLen = this.indexes.size();
        return idx >= baseLen && idx < baseLen + this.extAttrs.size();
    }

    private ExtAttr getExtAttr(int index) {
        return this.extAttrs.get(index - this.indexes.size());
    }

    private int getIdx(int i) {
        return this.indexes.indexOf(new Integer(i));
    }

    void addAttribute(int i) {
        this.indexes.add(new Integer(i));
    }

    void addAttributes(NVDLAttributes part) {
        assert (part.base == this.base);
        int len = part.indexes.size();
        int i = 0;
        while (i < len) {
            Integer idx = part.indexes.get(i);
            this.indexes.add(idx);
            ++i;
        }
    }

    public void addExtAttribute(String uri, String localName, String qName, String value) {
        ExtAttr ea = new ExtAttr(uri, localName, qName, value);
        if (this.extAttrs == null) {
            this.extAttrs = new ArrayList();
        }
        this.extAttrs.add(ea);
    }

    public String getNamespace() {
        return this.sectionNS;
    }

    public NVDLElement getBaseElement() {
        return this.baseElement;
    }

    public NVDLAttributes(NVDLElement baseElement, Attributes base) {
        this.base = base;
        this.baseElement = baseElement;
        this.sectionNS = null;
    }

    NVDLAttributes(NVDLElement baseElement, Attributes base, String sectionNS) {
        this.base = base;
        this.baseElement = baseElement;
        this.sectionNS = sectionNS;
    }

    private static class ExtAttr {
        final String uri;
        final String localName;
        final String qName;
        final String value;

        ExtAttr(String uri, String localName, String qName, String value) {
            this.uri = uri;
            this.localName = localName;
            this.qName = qName;
            this.value = value;
        }
    }
}

