/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.sapi.engine;

import org.eclipse.actf.ai.tts.ISAPIEngine;
import org.eclipse.actf.ai.tts.sapi.SAPIPlugin;
import org.eclipse.actf.ai.tts.sapi.engine.ISpNotifySource;
import org.eclipse.actf.ai.tts.sapi.engine.ISpVoice;
import org.eclipse.actf.ai.tts.sapi.engine.SpObjectToken;
import org.eclipse.actf.ai.tts.sapi.engine.SpeechObjectTokens;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.actf.util.win32.COMUtil;
import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.actf.util.win32.NativeIntAccess;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;

public class SapiVoice
implements ISAPIEngine,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.actf.ai.tts.sapi.engine.SapiVoice";
    public static final String AUDIO_OUTPUT = "org.eclipse.actf.ai.tts.SapiVoice.audioOutput";
    public ISpVoice dispSpVoice;
    private Variant varSapiVoice;
    private OleAutomation automation;
    private int idGetVoices;
    private int idGetAudioOutputs;
    private ISpNotifySource spNotifySource = null;
    private static IPreferenceStore preferenceStore = SAPIPlugin.getDefault().getPreferenceStore();
    private boolean isDisposed = false;

    public SapiVoice() {
        int pv = COMUtil.createDispatch((GUID)ISpVoice.IID);
        this.dispSpVoice = new ISpVoice(pv);
        this.varSapiVoice = new Variant((IDispatch)this.dispSpVoice);
        this.automation = this.varSapiVoice.getAutomation();
        this.spNotifySource = ISpNotifySource.getNotifySource(this.dispSpVoice);
        SAPIPlugin.getDefault().addPropertyChangeListener(this);
        this.idGetVoices = this.getIDsOfNames("GetVoices");
        this.idGetAudioOutputs = this.getIDsOfNames("GetAudioOutputs");
        String orgID = preferenceStore.getString(ID);
        preferenceStore.setValue(ID, preferenceStore.getDefaultString(ID));
        this.setAudioOutputName();
        preferenceStore.setValue(ID, orgID);
        this.stop();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (ID.equals(event.getProperty())) {
            this.stop();
            this.setVoiceName();
        } else if (AUDIO_OUTPUT.equals(event.getProperty())) {
            this.stop();
            this.setAudioOutputName();
        }
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.spNotifySource.setEventListener(eventListener);
    }

    public void speak(String text, int flags, int index) {
        int firstFlag = 1;
        if ((1 & flags) != 0) {
            firstFlag |= 2;
        }
        if (index >= 0) {
            this.speak("<BOOKMARK mark=\"" + index + "\"/>", firstFlag | 0x20);
            this.speak(text, 1);
            this.speak("<BOOKMARK mark=\"-1\"/>", 33);
        } else {
            this.speak(text, firstFlag);
        }
    }

    public void speak(String text, int sapiFlags) {
        char[] data = (String.valueOf(text) + "\u0000").toCharArray();
        int bstrText = MemoryUtil.SysAllocString((char[])data);
        try {
            this.dispSpVoice.Speak(bstrText, sapiFlags);
        }
        finally {
            MemoryUtil.SysFreeString((int)bstrText);
        }
    }

    public void stop() {
        this.speak("", 1, -1);
    }

    public boolean setRate(int rate) {
        return this.dispSpVoice.put_Rate(rate) == 0;
    }

    public int getRate() {
        NativeIntAccess nia = new NativeIntAccess();
        try {
            if (this.dispSpVoice.get_Rate(nia.getAddress()) == 0) {
                int n = nia.getInt();
                return n;
            }
        }
        finally {
            nia.dispose();
        }
        return -1;
    }

    public boolean setVoice(Variant varVoice) {
        return this.dispSpVoice.put_Voice(varVoice.getDispatch().getAddress()) == 0;
    }

    public boolean setAudioOutput(Variant varAudioOutput) {
        return this.dispSpVoice.put_AudioOutput(varAudioOutput != null ? varAudioOutput.getDispatch().getAddress() : 0) == 0;
    }

    private void setVoiceName() {
        String voiceName = preferenceStore.getString(ID);
        if (voiceName.length() > 0) {
            this.setVoiceName("name=" + voiceName);
        }
    }

    public boolean setVoiceName(String voiceName) {
        boolean success = false;
        Variant varVoices = this.getVoices(voiceName, null);
        if (varVoices != null) {
            Variant varVoice;
            SpeechObjectTokens tokens = SpeechObjectTokens.getTokens(varVoices);
            if (tokens != null && tokens.getCount() > 0 && (varVoice = tokens.getItem(0)) != null) {
                success = this.setVoice(varVoice);
            }
            varVoices.dispose();
        }
        if (!success) {
            int index = voiceName.indexOf("name=");
            varVoices = this.getVoices(null, null);
            if (varVoices != null && index > -1) {
                String name = voiceName.substring(index + 5);
                SpeechObjectTokens voiceTokens = SpeechObjectTokens.getTokens(varVoices);
                if (voiceTokens != null) {
                    int count = voiceTokens.getCount();
                    int i = 0;
                    while (i < count) {
                        SpObjectToken token;
                        Variant varVoice = voiceTokens.getItem(i);
                        if (varVoice != null && (token = SpObjectToken.getToken(varVoice)) != null && name.equals(token.getDescription(0))) {
                            success = this.setVoice(varVoice);
                        }
                        ++i;
                    }
                }
            }
            varVoices.dispose();
        }
        return success;
    }

    private void setAudioOutputName() {
        String audioOutput = preferenceStore.getString(AUDIO_OUTPUT);
        if (audioOutput.length() > 0) {
            this.setAudioOutputName(audioOutput);
        } else {
            this.setAudioOutput(null);
        }
    }

    public boolean setAudioOutputName(String audioOutput) {
        boolean success = false;
        Variant varAudioOutputs = this.getAudioOutputs(null, null);
        if (varAudioOutputs != null) {
            SpeechObjectTokens tokens = SpeechObjectTokens.getTokens(varAudioOutputs);
            if (tokens != null) {
                int i = 0;
                while (i < tokens.getCount()) {
                    SpObjectToken token;
                    Variant varAudioOutput = tokens.getItem(i);
                    if (varAudioOutput != null && (token = SpObjectToken.getToken(varAudioOutput)) != null && audioOutput.equals(token.getDescription(0))) {
                        success = this.setAudioOutput(varAudioOutput);
                        break;
                    }
                    ++i;
                }
            }
            varAudioOutputs.dispose();
        }
        return success;
    }

    public Variant getVoices(String requiredAttributes, String optionalAttributes) {
        return this.getTokens(this.idGetVoices, requiredAttributes, optionalAttributes);
    }

    public Variant getAudioOutputs(String requiredAttributes, String optionalAttributes) {
        return this.getTokens(this.idGetAudioOutputs, requiredAttributes, optionalAttributes);
    }

    private Variant getTokens(int id, String requiredAttributes, String optionalAttributes) {
        if (requiredAttributes == null) {
            return this.automation.invoke(id);
        }
        if (optionalAttributes == null) {
            return this.automation.invoke(id, new Variant[]{new Variant(requiredAttributes)});
        }
        return this.automation.invoke(id, new Variant[]{new Variant(requiredAttributes), new Variant(optionalAttributes)});
    }

    private int getIDsOfNames(String name) {
        int[] dispid = this.automation.getIDsOfNames(new String[]{name});
        if (dispid != null) {
            return dispid[0];
        }
        return 0;
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.varSapiVoice.dispose();
            if (SAPIPlugin.getDefault() != null) {
                SAPIPlugin.getDefault().removePropertyChangeListener(this);
            }
        }
    }

    public int getSpeed() {
        int rate = this.getRate();
        return (rate + 10) * 5;
    }

    public void setSpeed(int speed) {
        int rate = speed / 5 - 10;
        this.setRate(rate);
    }

    public void setLanguage(String language) {
        String token;
        if ("ja".equals(language)) {
            token = "language=411";
        } else if ("en".equals(language)) {
            token = "language=409;9";
        } else {
            return;
        }
        this.setVoiceName(token);
    }

    public void setGender(String gender) {
        if ("male".equalsIgnoreCase(gender)) {
            this.setVoiceName("name=Microsoft Mike");
        } else if ("female".equalsIgnoreCase(gender)) {
            this.setVoiceName("name=Microsoft Mary");
        }
    }

    public boolean isAvailable() {
        return this.automation != null;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

