/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.views;

import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.internal.navigator.Messages;
import org.eclipse.actf.ai.internal.navigator.NavigatorPlugin;
import org.eclipse.actf.ai.navigator.IManipulator;
import org.eclipse.actf.ai.navigator.ui.ModeContribution;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NavigatorTreeView
extends ViewPart {
    private TreeViewer treeViewer;
    private TableViewer tableViewer;
    private boolean disposed;

    public void dispose() {
        super.dispose();
        this.disposed = true;
    }

    void initView(Composite parent) {
        FillLayout layout = new FillLayout(512);
        parent.setLayout((Layout)layout);
        SashForm sash = new SashForm(parent, 512);
        this.treeViewer = new TreeViewer((Composite)sash);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ITreeItemLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new ITreeItemContentProvider());
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)new TreeItemViewerDoubleClickListener());
        this.tableViewer = new TableViewer((Composite)sash, 770);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn tableColumnProperty = new TableColumn(table, 16384);
        tableColumnProperty.setText(Messages.NavigatorTreeView_property);
        tableColumnProperty.setWidth(70);
        TableColumn tableColumnValue = new TableColumn(table, 16384);
        tableColumnValue.setText(Messages.NavigatorTreeView_value);
        tableColumnValue.setWidth(100);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TreeItemDetailsLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new TreeItemDetailsContentProvider());
        sash.setWeights(new int[]{90, 10});
    }

    public void createPartControl(Composite parent) {
        this.initView(parent);
        NavigatorPlugin.getDefault().setNavigatorTreeView(this);
    }

    public void setFocus() {
    }

    private ITreeItem getRoot(ITreeItem item) {
        ITreeItem parent = item.getParent();
        while (parent != null) {
            item = parent;
            parent = item.getParent();
        }
        return item;
    }

    public void showItem(ITreeItem item) {
        if (this.disposed) {
            return;
        }
        if (this.treeViewer.getControl().isDisposed()) {
            return;
        }
        this.treeViewer.setInput((Object)this.getRoot(item));
        this.treeViewer.reveal((Object)item);
        StructuredSelection is = new StructuredSelection((Object)item);
        this.treeViewer.setSelection((ISelection)is, true);
    }

    public void clearItem() {
        if (this.disposed) {
            return;
        }
        this.treeViewer.setInput(null);
    }

    public boolean isShown() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.actf.ai.navigator.views.NavigatorTreeView");
        return part != null;
    }

    public boolean toggleViewShowing() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.actf.ai.navigator.views.NavigatorTreeView");
        if (part != null) {
            page.hideView(part);
            return false;
        }
        try {
            page.showView("org.eclipse.actf.ai.navigator.views.NavigatorTreeView");
            return true;
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return false;
        }
    }

    private ModeContribution getModeContribution(String id) {
        IViewSite viewSite = this.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        return (ModeContribution)manager.find(id);
    }

    private void update() {
        IViewSite viewSite = this.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        IStatusLineManager manager = actionBars.getStatusLineManager();
        manager.update(true);
    }

    public void setMode(IManipulator.Mode mode) {
        ModeContribution mc = this.getModeContribution("navigator.mode");
        if (mc != null) {
            mc.setMode(mode.name);
            this.update();
        }
    }

    public void showFennecName(String name) {
        ModeContribution mc = this.getModeContribution("navigator.mode");
        if (mc != null) {
            mc.showFennecName(name);
            this.update();
        }
    }

    static class ITreeItemContentProvider
    extends ArrayContentProvider
    implements ITreeContentProvider {
        ITreeItemContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ITreeItem item = (ITreeItem)parentElement;
            return item.getChildItems();
        }

        public Object getParent(Object element) {
            ITreeItem item = (ITreeItem)element;
            return item.getParent();
        }

        public boolean hasChildren(Object element) {
            ITreeItem item = (ITreeItem)element;
            ITreeItem[] childItems = item.getChildItems();
            return childItems != null && childItems.length > 0;
        }

        public Object[] getElements(Object input) {
            return this.getChildren(input);
        }
    }

    static class ITreeItemLabelProvider
    extends LabelProvider {
        ITreeItemLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            ITreeItem item = (ITreeItem)element;
            String r = item.getUIString();
            if (r.length() > 0) {
                return r;
            }
            r = item.getNodeString();
            if (r == null) {
                return "";
            }
            return r;
        }
    }

    static class TreeItemDetailsContentProvider
    implements IStructuredContentProvider {
        TreeItemDetailsContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        private String calcPath(ITreeItem item) {
            StringBuffer ret = new StringBuffer();
            Object o = item.getBaseNode();
            if (!(o instanceof Node)) {
                return "#none";
            }
            Node n = (Node)o;
            while (n != null) {
                if (n instanceof Document) break;
                ret.insert(0, n.getNodeName());
                ret.insert(0, "/");
                n = n.getParentNode();
            }
            return ret.toString();
        }

        private String calcID(ITreeItem item) {
            Object o = item.getBaseNode();
            if (!(o instanceof Element)) {
                return "";
            }
            Element e = (Element)o;
            return e.getAttribute("id");
        }

        private String formatStringInHex(String str) {
            StringBuffer ret = new StringBuffer();
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                ret.append(Integer.toHexString(c));
                ret.append(" ");
                ++i;
            }
            return ret.toString();
        }

        public Object[] getElements(Object obj) {
            ITreeItem item = (ITreeItem)obj;
            String[] uiStrings = new String[]{"UIString", item.getUIString()};
            String[] uiStringsInHex = new String[]{"UIString (HEX)", this.formatStringInHex(item.getUIString())};
            String[] nodeStrings = new String[]{"Node", item.getNodeString()};
            String[] path = new String[]{"Path", this.calcPath(item)};
            String[] id = new String[]{"ID", this.calcID(item)};
            String[] hasContent = new String[]{"hasContent", "" + Vocabulary.hasContent().eval((IEvalTarget)item)};
            String[] heading = new String[]{"Heading", "" + item.getHeadingLevel()};
            String[] nodeObject = new String[]{"NodeObject", "" + item.getBaseNode()};
            String[] isInputable = new String[]{"isInputable", "" + item.isInputable()};
            String[] isConnectable = new String[]{"isConnectable", "" + Vocabulary.isConnectable().eval((IEvalTarget)item)};
            return new Object[]{uiStrings, uiStringsInHex, nodeStrings, path, id, hasContent, heading, nodeObject, isInputable, isConnectable};
        }
    }

    static class TreeItemDetailsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TreeItemDetailsLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            String[] prop = (String[])obj;
            if (index >= prop.length) {
                return null;
            }
            return prop[index];
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class TreeItemViewerDoubleClickListener
    implements IDoubleClickListener {
        TreeItemViewerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            IStructuredSelection sel = (IStructuredSelection)event.getSelection();
            Object obj = sel.getFirstElement();
            NavigatorTreeView.this.tableViewer.setInput(obj);
        }
    }
}

