/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.util;

import com.ibm.icu.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageFormatter {
    private ResourceBundle resourceBundle = null;

    private void setResourceBundle(String pkgName) {
        try {
            this.resourceBundle = ResourceBundle.getBundle(pkgName);
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    public MessageFormatter(String pkgName) {
        this.setResourceBundle(pkgName);
    }

    private String getFormat(String propName) {
        String format;
        if (this.resourceBundle == null) {
            return propName;
        }
        try {
            format = this.resourceBundle.getString(propName);
        }
        catch (MissingResourceException missingResourceException) {
            return propName;
        }
        if (format != null) {
            return format;
        }
        return propName;
    }

    public String mes(String propName, Object[] args) {
        String format = this.getFormat(propName);
        String message = MessageFormat.format((String)format, (Object[])args);
        return message;
    }

    public String mes(String propName, Object obj1) {
        return this.mes(propName, new Object[]{obj1});
    }

    public String mes(String propName, Object obj1, Object obj2) {
        return this.mes(propName, new Object[]{obj1, obj2});
    }

    public String mes(String propName, Object obj1, Object obj2, Object obj3) {
        return this.mes(propName, new Object[]{obj1, obj2, obj3});
    }

    public String mes(String propName, Object obj1, Object obj2, Object obj3, Object obj4) {
        return this.mes(propName, new Object[]{obj1, obj2, obj3, obj4});
    }

    public String mes(String propName) {
        return this.getFormat(propName);
    }

    public String concat(String ... args) {
        if (args.length == 0) {
            return "";
        }
        if (args.length == 1) {
            return args[0];
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < args.length - 1) {
            buf.append(args[i]);
            buf.append(" ");
            ++i;
        }
        buf.append(args[args.length - 1]);
        return buf.toString();
    }
}

