/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.userinfo.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AltTextGuesser {
    private final IWebBrowserACTF browser;
    private final ITreeItem item;

    public AltTextGuesser(IWebBrowserACTF browser, ITreeItem item) {
        this.browser = browser;
        this.item = item;
    }

    public String getDefaultText() {
        return this.item.getUIString();
    }

    public String guessByOCR() {
        throw new RuntimeException("Not implemented.");
    }

    public String guessByContext() {
        return this.getContext(this.browser, this.getContext(this.item));
    }

    private String getContext(ITreeItem item) {
        Object o = item.getBaseNode();
        if (!(o instanceof Node)) {
            return null;
        }
        Node n = (Node)o;
        while (n != null) {
            Node a;
            NamedNodeMap v;
            if (n instanceof Document) break;
            String name = n.getLocalName();
            if ("A".equals(name) && (v = n.getAttributes()) != null && (a = v.getNamedItem("href")) != null) {
                return a.getNodeValue();
            }
            n = n.getParentNode();
        }
        return null;
    }

    private String getContext(IWebBrowserACTF browser, String path) {
        try {
            URL url = new URL(new URL(browser.getURL()), path);
            String s = null;
            String title = "";
            String h1 = "";
            Pattern pattern = Pattern.compile("<(?:(title)|(h1))[^>]*>([^<]*)</(?:title|h1)>", 2);
            BufferedReader br = new BufferedReader(new InputStreamReader(url.openStream()));
            while ((s = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(s);
                if (!matcher.matches()) continue;
                if (matcher.group(1) != null) {
                    title = matcher.group(3);
                }
                if (matcher.group(2) != null) {
                    h1 = matcher.group(3);
                }
                if (title.length() > 0 && h1.length() > 0) break;
            }
            br.close();
            System.out.println("URL\t" + url);
            System.out.println("title\t" + title);
            System.out.println("h1\t" + h1);
            return title.length() > h1.length() ? title : h1;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

