/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.eclipse.actf.ai.fennec.FennecMediatorFactory;
import org.eclipse.actf.ai.fennec.IFennecMediator;
import org.eclipse.actf.ai.fennec.treemanager.ILocation;
import org.eclipse.actf.ai.navigator.broker.RequestBroker;
import org.eclipse.actf.ai.navigator.extension.ManipulatorExtension;
import org.eclipse.actf.ai.navigator.extension.MediaControlExtension;
import org.eclipse.actf.ai.navigator.extension.ScreenReaderExtension;
import org.eclipse.actf.ai.navigator.impl.BrowserControlImpl;
import org.eclipse.actf.ai.navigator.impl.NavigatorImpl;
import org.eclipse.actf.ai.navigator.impl.NavigatorImplEx;
import org.eclipse.actf.ai.navigator.impl.TripJournal;
import org.eclipse.actf.model.ui.IModelServiceHolder;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTFEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class WebEventListener
implements IWebBrowserACTFEventListener {
    private static final String ABOUT_BLANK_URL = "about:blank";
    private HashMap<IWebBrowserACTF, BrowserState> browserStateMap = new HashMap();
    private RequestBroker requestBroker;
    private final TripJournal tripJournal = new TripJournal();
    private final BrowserControlImpl browserControl = new BrowserControlImpl(this, this.tripJournal);
    private static final boolean EVENT_DEBUG = false;
    private static final String FILE_SCHEME_SUFFIX = "file:///";

    public WebEventListener() {
        IWebBrowserACTF.WebBrowserNavigationEventListnerHolder.LISTENER = this.browserControl;
        ManipulatorExtension.setBrowserControl(this.browserControl);
        this.requestBroker = new RequestBroker(this);
    }

    public synchronized BrowserState getBrowserState(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.browserStateMap.get(webBrowser);
        if (bs == null) {
            bs = new BrowserState(webBrowser);
            this.browserStateMap.put(webBrowser, bs);
        }
        return bs;
    }

    public void forceRestart(IWebBrowserACTF webBrowser) {
        this.startNavigation(webBrowser, false);
    }

    public NavigatorImpl getFocused() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IModelServiceHolder modelServiceHolder = (IModelServiceHolder)editor;
        IWebBrowserACTF wb = (IWebBrowserACTF)modelServiceHolder.getModelService();
        BrowserState bs = this.browserStateMap.get(wb);
        if (bs == null) {
            return null;
        }
        return bs.getNavigator();
    }

    private void startNavigation(IWebBrowserACTF webBrowser) {
        this.startNavigation(webBrowser, false);
    }

    private void startNavigation(IWebBrowserACTF webBrowser, boolean isRefresh) {
        this.tripJournal.tripEnd();
        BrowserState bs = this.getBrowserState(webBrowser);
        if (bs.state >= 10) {
            return;
        }
        if (bs.state == 10) {
            MediaControlExtension.doDispose(bs.navigator.getMediaControlHandle());
        }
        MediaControlExtension.start(bs.navigator.getMediaControlHandle());
        IFennecMediator mediator = FennecMediatorFactory.newFennecMediator((IWebBrowserACTF)webBrowser);
        bs.navigator.setFennecMediator(mediator);
        bs.navigator.startNavigation(webBrowser, !isRefresh);
        this.requestBroker.setNavigator(bs.navigator, webBrowser);
        bs.forwardState(10);
        this.requestBroker.newPageReady();
    }

    private String unifyURLFileScheme(String url) {
        if (url.startsWith(FILE_SCHEME_SUFFIX)) {
            url = url.substring(FILE_SCHEME_SUFFIX.length());
            try {
                url = URLDecoder.decode(url, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return url.replace('/', '\\');
        }
        return url;
    }

    private boolean urlEquals(String url1, String url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        return this.unifyURLFileScheme(url1).equals(this.unifyURLFileScheme(url2));
    }

    public void navigateComplete(IWebBrowserACTF webBrowser, String url) {
        if (!this.urlEquals(url, webBrowser.getURL())) {
            return;
        }
        BrowserState bs = this.getBrowserState(webBrowser);
        if (bs.shouldRecord && bs.state < 3) {
            this.tripJournal.recordJournal(bs.navigator, bs.savedLocation, webBrowser.getURL(), bs.initFlag);
        }
        bs.forwardState(3);
        bs.navigator.navigateComplete();
    }

    public void titleChange(IWebBrowserACTF webBrowser, String title) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof IModelServiceHolder && webBrowser != ((IModelServiceHolder)editor).getModelService()) {
            return;
        }
        this.setWindowTitle(title);
    }

    public void dispose() {
    }

    public void progressChange(IWebBrowserACTF webBrowser, int progress, int progressMax) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.forwardState(1);
        bs.navigator.progressChange(progress, progressMax);
    }

    public void rootDocumentComplete(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        if (!ABOUT_BLANK_URL.equals(webBrowser.getURL())) {
            bs.navigator.speakTab(false);
            this.startNavigation(webBrowser);
        } else {
            bs.setNoState();
        }
    }

    public void getFocus(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        ManipulatorExtension.setNavigator(bs.navigator);
        this.requestBroker.setNavigator(bs.navigator, webBrowser);
        MediaControlExtension.start(bs.navigator.getMediaControlHandle());
        this.setWindowTitle();
    }

    private void setWindowTitle(String title) {
        String productName = Platform.getProduct().getName();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(String.valueOf(title) + " - " + productName);
    }

    private void setWindowTitle() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        String title = page.getActiveEditor().getTitle();
        this.setWindowTitle(title);
    }

    public void beforeNavigate(IWebBrowserACTF webBrowser, String url, String targetFrameName, boolean isInNavigation) {
        BrowserState bs = this.getBrowserState(webBrowser);
        if (!url.startsWith("javascript")) {
            if (!ABOUT_BLANK_URL.equals(url)) {
                bs.initFlag = bs.state == -1;
                bs.shouldRecord = true;
                bs.savedLocation = bs.navigator.getLocation();
            } else {
                bs.shouldRecord = false;
            }
            bs.resetState();
            bs.navigator.beforeNavigation(webBrowser.getURL());
        } else {
            bs.shouldRecord = false;
        }
        ScreenReaderExtension.takeBackControl(webBrowser);
    }

    public void browserDisposed(IWebBrowserACTF webBrowser, String title) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.navigator.speakCloseTab(title);
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null || page.getActiveEditor() == null) {
            this.setWindowTitle("No Tab");
        }
    }

    public void refreshStart(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.resetState();
        bs.savedLocationForMyRefresh = bs.navigator.getLocation();
        bs.navigator.beforeNavigation(webBrowser.getURL());
    }

    public void refreshComplete(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.navigator.restoreLocation(bs.savedLocationForMyRefresh);
        this.startNavigation(webBrowser, true);
    }

    public void navigateStop(IWebBrowserACTF webBrowser) {
    }

    public void focusGainedOfAddressText(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.navigator.enterBrowserAddress();
    }

    public void focusLostOfAddressText(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.navigator.exitFormMode();
    }

    public void newWindow(IWebBrowserACTF webBrowser) {
        BrowserState bs = this.getBrowserState(webBrowser);
        bs.navigator.speakOpenTab();
    }

    public class BrowserState {
        public static final int STATE_NONE = -1;
        public static final int STATE_UNINIT = 0;
        public static final int STATE_PROGRESS = 1;
        public static final int STATE_NAVIGATECOMPLETED = 3;
        public static final int STATE_STARTED = 10;
        boolean shouldRecord;
        boolean initFlag;
        ILocation savedLocation;
        ILocation savedLocationForMyRefresh;
        NavigatorImpl navigator;
        int state;

        public NavigatorImpl getNavigator() {
            return this.navigator;
        }

        public int getState() {
            return this.state;
        }

        void resetState() {
            this.state = 0;
        }

        void setNoState() {
            this.state = -1;
        }

        void forwardState(int newst) {
            if (this.state < newst) {
                this.state = newst;
            }
        }

        BrowserState(IWebBrowserACTF webBrowser) {
            this.navigator = new NavigatorImplEx(WebEventListener.this, webBrowser, 30, 1000);
            this.state = -1;
        }
    }
}

