/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.ArrayList;
import org.eclipse.actf.ai.fennec.IFennecService;
import org.eclipse.actf.ai.fennec.treemanager.IMediaSyncEventListener;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.IVideoControl;
import org.eclipse.actf.model.dom.dombycom.AnalyzedResult;
import org.eclipse.actf.model.dom.dombycom.INodeEx;
import org.eclipse.actf.model.dom.dombycom.INodeExVideo;
import org.eclipse.actf.ui.util.timer.SyncEventListener;
import org.eclipse.actf.ui.util.timer.WeakSyncTimer;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;
import org.eclipse.actf.util.vocab.Vocabulary;
import org.w3c.dom.Node;

public class TreeItemVideoControl
implements IVideoControl {
    private final IFennecService fennecService;
    private AnalyzedResult analyzedResult;
    private ArrayList<IMediaSyncEventListener> listeners;

    private INodeExVideo getCurrentNodeExVideo() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        if (videos.length == 0) {
            return null;
        }
        if (videos.length == 1) {
            return videos[0];
        }
        ITreeItem item = this.fennecService.getLastTreeItem();
        int i = 0;
        while (i < videos.length) {
            INodeEx node = videos[i].getReferenceNode();
            IProposition prop = Vocabulary.nodeLocation((Node)node, (boolean)true);
            if (prop.eval((IEvalTarget)item)) {
                return videos[i];
            }
            ++i;
        }
        return videos[0];
    }

    public boolean previousTrack() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        boolean r = true;
        int i = 0;
        while (i < videos.length) {
            r &= videos[i].previousTrack();
            ++i;
        }
        return r;
    }

    public boolean nextTrack() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        boolean r = true;
        int i = 0;
        while (i < videos.length) {
            r &= videos[i].nextTrack();
            ++i;
        }
        return r;
    }

    public boolean stopMedia() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        boolean r = true;
        int i = 0;
        while (i < videos.length) {
            r &= videos[i].stopMedia();
            ++i;
        }
        return r;
    }

    public boolean playMedia() {
        INodeExVideo v = this.getCurrentNodeExVideo();
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        int i = 0;
        while (i < videos.length) {
            if (videos[i] != v) {
                videos[i].pauseMedia();
            }
            ++i;
        }
        if (v != null) {
            return v.playMedia();
        }
        return false;
    }

    public boolean pauseMedia() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        boolean pause = false;
        int i = 0;
        while (i < videos.length) {
            INodeExVideo.VideoState st = videos[i].getCurrentState();
            if (st == INodeExVideo.VideoState.STATE_PLAY || st == INodeExVideo.VideoState.STATE_UNKNOWN) {
                pause = true;
                break;
            }
            ++i;
        }
        if (pause) {
            boolean r = true;
            int i2 = 0;
            while (i2 < videos.length) {
                r &= videos[i2].pauseMedia();
                ++i2;
            }
            return r;
        }
        INodeExVideo v = this.getCurrentNodeExVideo();
        if (v != null) {
            return v.playMedia();
        }
        return false;
    }

    public IVideoControl.VideoState getVideoState() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        IVideoControl.VideoState st = IVideoControl.VideoState.STATE_OTHER;
        int i = 0;
        while (i < videos.length) {
            INodeExVideo.VideoState stn = videos[i].getCurrentState();
            switch (stn) {
                case STATE_UNKNOWN: {
                    break;
                }
                case STATE_PLAY: {
                    st = IVideoControl.VideoState.STATE_PLAY;
                    break;
                }
                case STATE_STOP: {
                    if (st != IVideoControl.VideoState.STATE_OTHER) break;
                    st = IVideoControl.VideoState.STATE_STOP;
                    break;
                }
                case STATE_PAUSE: {
                    if (st != IVideoControl.VideoState.STATE_OTHER) break;
                    st = IVideoControl.VideoState.STATE_PAUSE;
                    break;
                }
                case STATE_WAITING: {
                    if (st != IVideoControl.VideoState.STATE_OTHER) break;
                    st = IVideoControl.VideoState.STATE_WAITING;
                    break;
                }
                case STATE_FASTFORWARD: {
                    if (st == IVideoControl.VideoState.STATE_PLAY) break;
                    st = IVideoControl.VideoState.STATE_FASTFORWARD;
                    break;
                }
                case STATE_FASTREVERSE: {
                    if (st == IVideoControl.VideoState.STATE_PLAY) break;
                    st = IVideoControl.VideoState.STATE_FASTREVERSE;
                }
            }
            ++i;
        }
        return st;
    }

    public boolean fastReverse() {
        INodeExVideo v = this.getCurrentNodeExVideo();
        if (v != null) {
            return v.fastReverse();
        }
        return false;
    }

    public boolean fastForward() {
        INodeExVideo v = this.getCurrentNodeExVideo();
        if (v != null) {
            return v.fastForward();
        }
        return false;
    }

    public double getCurrentPosition() {
        INodeExVideo v = this.getCurrentNodeExVideo();
        if (v != null) {
            return v.getCurrentPosition();
        }
        return 0.0;
    }

    public double getTotalLength() {
        INodeExVideo v = this.getCurrentNodeExVideo();
        if (v != null) {
            return v.getTotalLength();
        }
        return 0.0;
    }

    public int getCount() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        return videos.length;
    }

    public int getIndex() {
        INodeExVideo[] videos = this.analyzedResult.getVideoNodes();
        if (videos.length == 0) {
            return -1;
        }
        if (videos.length == 1) {
            return 0;
        }
        ITreeItem item = this.fennecService.getLastTreeItem();
        int i = 0;
        while (i < videos.length) {
            INodeEx node = videos[i].getReferenceNode();
            IProposition prop = Vocabulary.nodeLocation((Node)node, (boolean)true);
            if (prop.eval((IEvalTarget)item)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static IVideoControl newTreeItemVideoControl(AnalyzedResult ar, IFennecService fennecService) {
        return new TreeItemVideoControl(ar, fennecService);
    }

    private TreeItemVideoControl(AnalyzedResult ar, IFennecService fennecService) {
        this.analyzedResult = ar;
        this.fennecService = fennecService;
    }

    public boolean addEventListener(IMediaSyncEventListener listener) {
        WeakSyncTimer timer = WeakSyncTimer.getTimer();
        timer.addEventListener((SyncEventListener)listener);
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(listener);
        return true;
    }
}

