/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.impl.FennecBundleMetadata;
import org.eclipse.actf.ai.fennec.impl.FennecMode;
import org.eclipse.actf.ai.fennec.impl.FennecServiceImpl;
import org.eclipse.actf.ai.fennec.impl.TreeItemFennec;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.query.IQuery;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class FennecMetadata {
    protected final FennecServiceImpl fennecService;
    private final IQuery query;
    private final boolean hasTarget;
    private static final NodeList emptyNodeList = new EmptyNodeList();
    protected final FennecMode mode;

    public boolean hasTargets() {
        return this.hasTarget;
    }

    NodeList query(IQuery q, Node baseNode) {
        if (q == null || !q.hasTarget()) {
            return emptyNodeList;
        }
        return q.query(baseNode);
    }

    NodeList query(IQuery q, ITreeItem baseItem) {
        if (q == null || !q.hasTarget()) {
            return emptyNodeList;
        }
        Node baseNode = null;
        while (baseItem != null && baseNode == null) {
            baseNode = (Node)baseItem.getBaseNode();
            baseItem = baseItem.getParent();
        }
        if (baseNode == null) {
            baseNode = this.fennecService.getDocumentElement();
        }
        if (baseNode == null) {
            return emptyNodeList;
        }
        return q.query(baseNode);
    }

    NodeList query(Node baseNode) {
        return this.query(this.query, baseNode);
    }

    NodeList query(ITreeItem baseItem) {
        return this.query(this.query, baseItem);
    }

    public abstract String getAltText(ITreeItem var1);

    public abstract String getDescription(ITreeItem var1);

    public abstract short getHeadingLevel(ITreeItem var1);

    List buildItems(TreeItemFennec baseItem, Node baseNode, int trigger) throws FennecException {
        if (this.hasTargets()) {
            NodeList nl = baseNode != null ? this.query(baseNode) : this.query(baseItem);
            int len = nl.getLength();
            ArrayList<TreeItemFennec> result = new ArrayList<TreeItemFennec>(len);
            int i = 0;
            while (i < len) {
                Node n = nl.item(i);
                TreeItemFennec newItem = TreeItemFennec.newTreeItem(this, baseItem, n);
                if (newItem != null) {
                    result.add(newItem);
                }
                ++i;
            }
            return result;
        }
        if (this instanceof FennecBundleMetadata) {
            ArrayList<TreeItemFennec> result = new ArrayList<TreeItemFennec>(1);
            TreeItemFennec newItem = TreeItemFennec.newTreeItem(this, baseItem, null);
            if (newItem != null) {
                result.add(newItem);
            }
            return result;
        }
        return null;
    }

    TreeItemFennec buildRootItem() throws FennecException {
        List items = this.buildItems(null, null, 1);
        if (items == null || items.size() == 0) {
            return null;
        }
        if (items.size() == 1) {
            TreeItemFennec root = (TreeItemFennec)items.get(0);
            return root.expand(1);
        }
        TreeItemFennec root = TreeItemFennec.newTreeItem(this, null, this.fennecService.getDocumentElement());
        if (root == null) {
            return null;
        }
        root.setChildItems(items);
        return root;
    }

    abstract List expand(TreeItemFennec var1, int var2) throws FennecException;

    protected FennecMetadata(FennecServiceImpl fennecService, IQuery q, FennecMode mode) {
        this.fennecService = fennecService;
        this.query = q;
        this.hasTarget = q != null ? q.hasTarget() : false;
        this.mode = mode;
        this.mode.addMetadata(this);
    }

    protected FennecMetadata(FennecServiceImpl fennecService, FennecMode mode, Node node) {
        this.fennecService = fennecService;
        this.query = null;
        this.hasTarget = false;
        this.mode = mode;
        this.mode.addMetadata(this);
    }

    private static class EmptyNodeList
    implements NodeList {
        private EmptyNodeList() {
        }

        public Node item(int index) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    }
}

