/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and Others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Kentarou FUKUDA - initial API and implementation
 *******************************************************************************/
package org.eclipse.actf.model.internal.dom.sgml;

import java.io.IOException;
import java.util.Hashtable;

import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.AndModelGroup.AndContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public interface ISGMLParser extends IParser {

	public void addAutoGenerated(Element element);

	public void clearContextMap(Node parent);

	/**
	 * Gets DTD that defines this Document's syntax.
	 * 
	 * @return DTD that defines this Document's syntax.
	 */
	public SGMLDocTypeDef getDTD();

	/**
	 * Checks if parser preserve whitespaces or not.
	 * 
	 * @return <code>true</code> if this parser preserve whitespaces.
	 *         Otherwise <code>false</code>
	 */
	public boolean getPreserveWhitespace();

	/**
	 * Inserts a string to current position in read stream. This method is
	 * usually invoked by token-level error handlers.
	 * 
	 * @param str
	 *            String to insert
	 */
	public void insert(String str) throws IOException;

	/**
	 * Determines if this parser preserve whitespaces or not. If preserve, the
	 * parser create text node for whitespace between tags and does not ignore
	 * carriage return and line feed after start tags and before end tags. By
	 * default a parser ignores whitespaces.
	 * 
	 * @see #getPreserveWhitespace()
	 */
	public void setPreserveWhitespace(boolean preserv);

	public Hashtable<Node, AndContext> getAndMap();

	public Hashtable<Node, Integer> getSeqMap();

	public Hashtable<Node, Node> getPlusMap();

	public IModelGroup[] getSeqArray();

	/**
	 * Set up syntax information described by DTD.
	 * 
	 * @param publicID
	 *            DTD's public id that specifies which to set up.
	 */
	public void setupDTD(String publicID) throws ParseException, IOException;

}