/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCleaner {
    public static Set<String> removeCSS(Document document, String string) {
        NodeList nodeList;
        Object object;
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (Exception exception) {}
        NodeList nodeList2 = document.getElementsByTagName("link");
        if (nodeList2 != null) {
            int n2 = nodeList2.getLength();
            n = n2 - 1;
            while (n >= 0) {
                Element element = (Element)nodeList2.item(n);
                if ("text/css".equals(element.getAttribute("type"))) {
                    object = DocumentCleaner.getHref(element, uRL);
                    if (!((String)object).equals("")) {
                        hashSet.add((String)object);
                    }
                    element.getParentNode().removeChild(element);
                }
                --n;
            }
        }
        if ((nodeList = document.getElementsByTagName("style")) != null) {
            n = nodeList.getLength();
            int n3 = n - 1;
            while (n3 >= 0) {
                object = (Element)nodeList.item(n3);
                if (object.getAttribute("type").equals("text/css")) {
                    NodeList nodeList3 = object.getChildNodes();
                    int n4 = 0;
                    while (n4 < nodeList3.getLength()) {
                        Node node = nodeList3.item(n4);
                        DocumentCleaner.getImportUrl(node.toString(), uRL, hashSet);
                        ++n4;
                    }
                }
                object.getParentNode().removeChild((Node)object);
                --n3;
            }
        }
        NodeList nodeList4 = document.getElementsByTagName("body");
        int n5 = 0;
        while (n5 < nodeList4.getLength()) {
            object = (Element)nodeList4.item(n5);
            object.removeAttribute("style");
            ++n5;
        }
        return hashSet;
    }

    private static String createFullPath(URL uRL, String string) {
        String string2 = string;
        if (uRL != null) {
            try {
                URL uRL2 = new URL(uRL, string);
                string2 = uRL2.toString();
            }
            catch (Exception exception) {}
        }
        return string2;
    }

    private static String getHref(Element element, URL uRL) {
        String string = "";
        if (element.hasAttribute("href")) {
            string = element.getAttribute("href");
            string = DocumentCleaner.createFullPath(uRL, string);
        }
        return string;
    }

    private static void getImportUrl(String string, URL uRL, Set<String> set) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("@import");
                if (n <= -1 || (n = (string2 = string2.substring(n + 7)).indexOf("url(\"")) <= -1 || (n = (string2 = string2.substring(n + 5)).indexOf("\");")) <= -1) continue;
                string2 = string2.substring(0, n);
                string2 = DocumentCleaner.createFullPath(uRL, string2);
                set.add(string2);
            }
        }
        catch (IOException iOException) {}
    }

    public static void removeBase(Document document) {
        NodeList nodeList = document.getElementsByTagName("base");
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Element element = (Element)nodeList.item(n2);
            element.getParentNode().removeChild(element);
            --n2;
        }
    }

    public static void removeApplet(Document document) {
        NodeList nodeList = document.getElementsByTagName("applet");
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("id");
            Element element2 = document.createElement("div");
            element2.setAttribute("id", string);
            Node node = element.getLastChild();
            while (node != null) {
                Node node2 = node.getPreviousSibling();
                if (!node.getNodeName().equals("param")) {
                    if (element2.hasChildNodes()) {
                        element2.insertBefore(node, element2.getFirstChild());
                    } else {
                        element2.appendChild(node);
                    }
                }
                node = node2;
            }
            element.getParentNode().insertBefore(element2, element);
            element.getParentNode().removeChild(element);
            --n2;
        }
    }

    public static void removeObject(Document document) {
        NodeList nodeList = document.getElementsByTagName("object");
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("id");
            Element element2 = document.createElement("div");
            element2.setAttribute("id", string);
            Node node = element.getLastChild();
            while (node != null) {
                Node node2 = node.getPreviousSibling();
                if (!node.getNodeName().equals("param")) {
                    if (element2.hasChildNodes()) {
                        element2.insertBefore(node, element2.getFirstChild());
                    } else {
                        element2.appendChild(node);
                    }
                }
                node = node2;
            }
            element.getParentNode().insertBefore(element2, element);
            element.getParentNode().removeChild(element);
            --n2;
        }
    }

    public static void removeEmbed(Document document) {
        NodeList nodeList = document.getElementsByTagName("embed");
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object object;
            Object object2;
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("id");
            Element element2 = document.createElement("div");
            element2.setAttribute("id", string);
            Node node = element.getParentNode();
            NodeList nodeList2 = element.getElementsByTagName("noembed");
            Node node2 = null;
            boolean bl = false;
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                node2 = nodeList2.item(n3);
                if (element == node2.getParentNode()) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (bl) {
                object2 = node2.getChildNodes();
                int n4 = object2.getLength() - 1;
                while (n4 >= 0) {
                    element2.insertBefore(object2.item(n4), element2.getFirstChild());
                    --n4;
                }
                object = node2.getNextSibling();
            } else {
                element2.appendChild(document.createTextNode("(Embeded element)"));
                object = element.getFirstChild();
            }
            node.insertBefore(element2, element);
            while (object != null) {
                object2 = object.getNextSibling();
                node.insertBefore((Node)object, element);
                object = object2;
            }
            node.removeChild(element);
            --n2;
        }
    }

    public static void removeOnMouse(Element element) {
        String string = element.getAttribute("onmouseover");
        if (string != null && string.length() > 0) {
            element.removeAttribute("onmouseover");
        }
        if ((string = element.getAttribute("onmouseout")) != null && string.length() > 0) {
            element.removeAttribute("onmouseout");
        }
        if ((string = element.getAttribute("onmousemove")) != null && string.length() > 0) {
            element.removeAttribute("onmousemove");
        }
        if ((string = element.getAttribute("onclick")) != null && string.length() > 0) {
            element.removeAttribute("onclick");
        }
        if ((string = element.getAttribute("onresize")) != null && string.length() > 0) {
            element.removeAttribute("onresize");
        }
    }

    public static void removeOnLoad(Element element) {
        String string = element.getAttribute("onload");
        if (string != null && string.length() > 0) {
            element.removeAttribute("onload");
        }
    }

    public static void removeDisplayNone(Document document) {
        NodeList nodeList = document.getElementsByTagName("div");
        int n = nodeList.getLength() - 1;
        while (n >= 0) {
            Node node;
            Element element = (Element)nodeList.item(n);
            if (element.getAttribute("style").indexOf("DISPLAY: none") > -1 && (node = element.getParentNode()) != null) {
                node.removeChild(element);
            }
            --n;
        }
    }

    public static void removeBgcolor(Document document) {
        NodeList nodeList = document.getElementsByTagName("body");
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            element.removeAttribute("bgcolor");
        }
    }

    public static void removeMeta(Document document) {
        NodeList nodeList = document.getElementsByTagName("meta");
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element = (Element)nodeList.item(n2);
            String string = element.getAttribute("http-equiv");
            if (string != null && (string.equalsIgnoreCase("refresh") || string.equalsIgnoreCase("Content-Type"))) {
                element.removeAttribute("http-equiv");
            }
            ++n2;
        }
    }

    public static void removeJavaScript(List<VisualizationNodeInfo> list, Document document) {
        Node node;
        NodeList nodeList = document.getElementsByTagName("script");
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            try {
                node = (Element)nodeList.item(n2);
                node.getParentNode().removeChild(node);
            }
            catch (Exception exception) {}
            --n2;
        }
        nodeList = document.getElementsByTagName("body");
        n = nodeList.getLength();
        n2 = 0;
        while (n2 < n) {
            try {
                ((Element)nodeList.item(n2)).removeAttribute("onload");
                ((Element)nodeList.item(n2)).removeAttribute("onunload");
            }
            catch (Exception exception) {}
            ++n2;
        }
        n = list.size();
        n2 = 0;
        while (n2 < n) {
            node = list.get(n2).getNode();
            if (node.getNodeType() == 1) {
                try {
                    String string;
                    Element element = (Element)node;
                    String string2 = element.getAttribute("onload");
                    if (string2.length() > 0) {
                        element.removeAttribute("onload");
                    }
                    if ((string = element.getAttribute("onmouseover")).length() > 0) {
                        element.removeAttribute("onmouseover");
                    }
                }
                catch (Exception exception) {}
            }
            ++n2;
        }
    }

    public static void removePI(Document document) {
        NodeList nodeList = document.getChildNodes();
        int n = nodeList.getLength() - 1;
        while (n > -1) {
            Node node = nodeList.item(n);
            if (node instanceof ProcessingInstruction) {
                document.removeChild(node);
            }
            --n;
        }
    }
}

