/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.impl;

import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import org.eclipse.actf.model.internal.dom.sgml.IPrintXML;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLElement;
import org.eclipse.actf.model.internal.dom.sgml.impl.AttributeDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLAttribute;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocTypeDef;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLDocument;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParentNode;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLParser;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

public class SGMLElement
extends SGMLParentNode
implements ISGMLElement {
    private static final long serialVersionUID = -8088815760723728378L;
    private String tagName;
    private SGMLAttribute[] attributes = new SGMLAttribute[8];
    private int attrNum = 0;

    public SGMLElement(String string, Document document) {
        super(document);
        this.tagName = string;
    }

    void check(Node node) throws DOMException {
        if (node == null) {
            throw new DOMException(3, "trying to insert null"){
                private static final long serialVersionUID = -3195872655825042328L;
            };
        }
        if (node.getOwnerDocument() != this.ownerDocument) {
            throw new DOMException(4, node + " created from " + node.getOwnerDocument() + ". " + this + " created from " + this.ownerDocument){
                private static final long serialVersionUID = -3952917378943559036L;
            };
        }
        switch (node.getNodeType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                throw new DOMException(3, node + " is not allowed as a child of " + this){
                    private static final long serialVersionUID = 2793178675397177186L;
                };
            }
        }
    }

    public String getAttribute(String string) {
        int n = this.attrNum - 1;
        while (n >= 0) {
            SGMLAttribute sGMLAttribute = this.attributes[n];
            if (sGMLAttribute.getNodeName().equalsIgnoreCase(string)) {
                return sGMLAttribute.getNodeValue();
            }
            --n;
        }
        if (this.getDefaultValue(string) != null) {
            return this.getDefaultValue(string);
        }
        return "";
    }

    public Attr getAttributeNode(String string) {
        int n = this.attrNum - 1;
        while (n >= 0) {
            SGMLAttribute sGMLAttribute = this.attributes[n];
            if (sGMLAttribute.getNodeName().equalsIgnoreCase(string)) {
                return sGMLAttribute;
            }
            --n;
        }
        return null;
    }

    private void expandAttrBuf() {
        SGMLAttribute[] sGMLAttributeArray = new SGMLAttribute[this.attrNum * 2];
        System.arraycopy(this.attributes, 0, sGMLAttributeArray, 0, this.attrNum);
        this.attributes = sGMLAttributeArray;
    }

    public NamedNodeMap getAttributes() {
        return new NamedNodeMap(){

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer(91);
                int n = 0;
                while (n < SGMLElement.this.attrNum - 1) {
                    stringBuffer.append(SGMLElement.this.attributes[n] + ", ");
                    ++n;
                }
                if (SGMLElement.this.attrNum > 0) {
                    stringBuffer.append(SGMLElement.this.attributes[SGMLElement.this.attrNum - 1]);
                }
                stringBuffer.append(']');
                return stringBuffer.toString();
            }

            public Node getNamedItem(String string) {
                return SGMLElement.this.getAttributeNode(string);
            }

            public Node getNamedItemNS(String string, String string2) {
                return this.getNamedItem(string2);
            }

            public Node setNamedItem(Node node) throws DOMException {
                if (node instanceof SGMLAttribute) {
                    int n = SGMLElement.this.attrNum - 1;
                    while (n >= 0) {
                        SGMLAttribute sGMLAttribute = SGMLElement.this.attributes[n];
                        if (sGMLAttribute.getNodeName().equalsIgnoreCase(node.getNodeName())) {
                            ((SGMLElement)SGMLElement.this).attributes[n] = (SGMLAttribute)node;
                            SGMLElement.this.attributes[n].setOwnerElement(SGMLElement.this);
                            return sGMLAttribute;
                        }
                        --n;
                    }
                    if (SGMLElement.this.attrNum == SGMLElement.this.attributes.length) {
                        SGMLElement.this.expandAttrBuf();
                    }
                    SGMLAttribute[] sGMLAttributeArray = SGMLElement.this.attributes;
                    SGMLElement sGMLElement = SGMLElement.this;
                    int n2 = sGMLElement.attrNum;
                    sGMLElement.attrNum = n2 + 1;
                    sGMLAttributeArray[n2] = (SGMLAttribute)node;
                    ((SGMLAttribute)node).setOwnerElement(SGMLElement.this);
                    return null;
                }
                throw new DOMException(7, "only Attr instance can be set: " + node){
                    private static final long serialVersionUID = -8500293705674064623L;
                };
            }

            public Node setNamedItemNS(Node node) throws DOMException {
                return this.setNamedItem(node);
            }

            public Node removeNamedItem(String string) throws DOMException {
                int n = SGMLElement.this.attrNum - 1;
                while (n >= 0) {
                    SGMLAttribute sGMLAttribute = SGMLElement.this.attributes[n];
                    if (sGMLAttribute.getNodeName().equalsIgnoreCase(string)) {
                        ((SGMLElement)SGMLElement.this).attributes[n] = null;
                        sGMLAttribute.setOwnerElement(null);
                        ++n;
                        while (n < SGMLElement.this.attrNum) {
                            ((SGMLElement)SGMLElement.this).attributes[n - 1] = SGMLElement.this.attributes[n];
                            ++n;
                        }
                        SGMLElement sGMLElement = SGMLElement.this;
                        sGMLElement.attrNum = sGMLElement.attrNum - 1;
                        return sGMLAttribute;
                    }
                    --n;
                }
                return null;
            }

            public Node removeNamedItemNS(String string, String string2) throws DOMException {
                return this.removeNamedItem(string2);
            }

            public Node item(int n) {
                if (n >= 0 && n < SGMLElement.this.attrNum) {
                    return SGMLElement.this.attributes[n];
                }
                return null;
            }

            public int getLength() {
                return SGMLElement.this.attrNum;
            }
        };
    }

    public NodeList getElementsByTagName(String string) {
        class MyNodeList
        implements NodeList {
            private String name;
            private ArrayList<WeakReference<Node>> list;
            private int s;
            private int e;
            private long lastupdated;

            MyNodeList(String string) {
                this.name = string;
                this.list = SGMLElement.getNodeList(SGMLElement.this.ownerDocument, string);
                this.init();
            }

            private void init() {
                this.s = 0;
                Node node = SGMLElement.this.findPreviousNodeByTagName(SGMLElement.this, this.name);
                if (node != null) {
                    while (this.s < this.list.size()) {
                        if (this.list.get(this.s).get() == node) {
                            ++this.s;
                            break;
                        }
                        ++this.s;
                    }
                }
                if (this.s < this.list.size() && this.list.get(this.s).get() == SGMLElement.this) {
                    ++this.s;
                }
                this.e = this.list.size();
                Node node2 = SGMLElement.this.getNextSibling();
                Node node3 = SGMLElement.this.getParentNode();
                while (node3 != null && node2 == null) {
                    node2 = node3.getNextSibling();
                    if (node2 != null) continue;
                    node3 = node3.getParentNode();
                }
                if (node2 != null) {
                    Node node4 = SGMLElement.this.findPreviousNodeByTagName(node2, this.name);
                    if (node4 != null) {
                        --this.e;
                        while (this.e >= 0) {
                            if (this.list.get(this.e).get() == node4) {
                                ++this.e;
                                break;
                            }
                            --this.e;
                        }
                    } else {
                        this.e = 0;
                    }
                }
                this.lastupdated = SGMLElement.getNodeListUpdatedAt(SGMLElement.this.ownerDocument, this.name);
            }

            public int getLength() {
                if (this.lastupdated != SGMLElement.getNodeListUpdatedAt(SGMLElement.this.ownerDocument, this.name)) {
                    this.init();
                }
                return this.e - this.s;
            }

            public Node item(int n) {
                if (this.getLength() <= n) {
                    return null;
                }
                return (Node)this.list.get(this.s + n).get();
            }
        }
        return new MyNodeList(string);
    }

    public String getNodeName() {
        return this.tagName;
    }

    public short getNodeType() {
        return 1;
    }

    public String getNodeValue() {
        return null;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void removeAttribute(String string) throws DOMException {
        int n = this.attrNum - 1;
        while (n >= 0) {
            SGMLAttribute sGMLAttribute = this.attributes[n];
            if (sGMLAttribute.getNodeName().equalsIgnoreCase(string)) {
                String string2 = this.getDefaultValue(string);
                if (string2 != null) {
                    sGMLAttribute.setNodeValue(string2);
                } else {
                    this.attributes[n] = null;
                    sGMLAttribute.setOwnerElement(null);
                    ++n;
                    while (n < this.attrNum) {
                        this.attributes[n - 1] = this.attributes[n];
                        ++n;
                    }
                    --this.attrNum;
                }
                this.processIdForOptimization(this);
                return;
            }
            --n;
        }
    }

    private String getDefaultValue(String string) {
        SGMLDocTypeDef sGMLDocTypeDef = ((SGMLDocument)this.ownerDocument).getDTD();
        if (sGMLDocTypeDef == null) {
            return null;
        }
        ElementDefinition elementDefinition = sGMLDocTypeDef.getElementDefinition(this.tagName);
        if (elementDefinition == null) {
            return null;
        }
        AttributeDefinition attributeDefinition = elementDefinition.getAttributeDef(string);
        return attributeDefinition != null ? attributeDefinition.getDefaultValue() : null;
    }

    public Attr removeAttributeNode(Attr attr) {
        int n = this.attrNum - 1;
        while (n >= 0) {
            if (this.attributes[n] == attr) {
                String string = this.getDefaultValue(attr.getNodeName());
                if (string != null) {
                    SGMLAttribute sGMLAttribute = (SGMLAttribute)this.ownerDocument.createAttribute(attr.getNodeName());
                    sGMLAttribute.setValue(string);
                    this.attributes[n] = sGMLAttribute;
                    sGMLAttribute.setOwnerElement(this);
                    break;
                }
                this.attributes[n] = null;
                ++n;
                while (n < this.attrNum) {
                    this.attributes[n - 1] = this.attributes[n];
                    ++n;
                }
                --this.attrNum;
                break;
            }
            --n;
        }
        ((SGMLAttribute)attr).setOwnerElement(this);
        this.processIdForOptimization(this);
        return attr;
    }

    public void setAttribute(String string, String string2) throws DOMException {
        SGMLAttribute sGMLAttribute;
        int n = this.attrNum - 1;
        while (n >= 0) {
            sGMLAttribute = this.attributes[n];
            if (sGMLAttribute.getName().equalsIgnoreCase(string)) {
                sGMLAttribute.setValue(string2);
                this.processIdForOptimization(this);
                return;
            }
            --n;
        }
        sGMLAttribute = (SGMLAttribute)this.ownerDocument.createAttribute(string);
        sGMLAttribute.setValue(string2);
        sGMLAttribute.setOwnerElement(this);
        if (this.attributes.length == this.attrNum) {
            this.expandAttrBuf();
        }
        this.attributes[this.attrNum++] = sGMLAttribute;
        this.processIdForOptimization(this);
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (!(attr instanceof SGMLAttribute)) {
            throw new DOMException(4, attr + "is not SGMLAttribute"){
                private static final long serialVersionUID = -2574702797917329018L;
            };
        }
        int n = this.attrNum - 1;
        while (n >= 0) {
            SGMLAttribute sGMLAttribute = this.attributes[n];
            if (sGMLAttribute.getName().equalsIgnoreCase(attr.getName())) {
                sGMLAttribute.setOwnerElement(null);
                this.attributes[n] = (SGMLAttribute)attr;
                this.attributes[n].setOwnerElement(this);
                this.processIdForOptimization(this);
                return sGMLAttribute;
            }
            --n;
        }
        if (this.attributes.length == this.attrNum) {
            this.expandAttrBuf();
        }
        this.attributes[this.attrNum] = (SGMLAttribute)attr;
        this.attributes[this.attrNum++].setOwnerElement(this);
        this.processIdForOptimization(this);
        return null;
    }

    public void setNodeValue(String string) throws DOMException {
        throw new DOMException(7, "can't set value in " + this){
            private static final long serialVersionUID = 159616090913212538L;
        };
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('<');
        stringBuffer.append(this.tagName);
        int n = 0;
        while (n < this.attrNum) {
            stringBuffer.append(this.attributes[n].toString());
            ++n;
        }
        stringBuffer.append('>');
        return new String(stringBuffer);
    }

    public void printAsXML(PrintWriter printWriter, int n, boolean bl) {
        int n2;
        if (bl && (this.previousSibling == null || this.previousSibling.getNodeType() != 3 && this.previousSibling.getNodeType() != 4)) {
            n2 = 0;
            while (n2 < n) {
                printWriter.print(' ');
                ++n2;
            }
        }
        printWriter.print(String.valueOf('<') + this.getTagName());
        n2 = 0;
        while (n2 < this.attrNum) {
            printWriter.print(this.attributes[n2].toXMLString());
            ++n2;
        }
        if (this.hasChildNodes()) {
            printWriter.print('>');
            Node node = this.getFirstChild();
            while (node != null) {
                if (bl && node.getNodeType() != 3 && node.getNodeType() != 4) {
                    printWriter.println();
                }
                ((IPrintXML)((Object)node)).printAsXML(printWriter, n + 1, bl);
                node = node.getNextSibling();
            }
            if (bl && (this.getLastChild() == null || this.getLastChild().getNodeType() != 3 && this.getLastChild().getNodeType() != 4)) {
                printWriter.println();
                int n3 = n;
                while (n3 > 0) {
                    printWriter.print(' ');
                    --n3;
                }
            }
            printWriter.print("</" + this.getTagName() + '>');
        } else {
            printWriter.print("/>");
        }
    }

    public void printAsSGML(PrintWriter printWriter, int n, boolean bl) {
        Object object;
        int n2;
        if (bl && (this.previousSibling == null || this.previousSibling.getNodeType() != 3 && this.previousSibling.getNodeType() != 4)) {
            n2 = n;
            while (n2 > 0) {
                printWriter.print(' ');
                --n2;
            }
        }
        printWriter.print(this.toString());
        boolean bl2 = this.hasChildNodes();
        n2 = bl2 ? 1 : 0;
        if (bl2) {
            object = this.getFirstChild();
            while (object != null) {
                if (bl && object.getNodeType() != 3 && object.getNodeType() != 4) {
                    printWriter.println();
                }
                ((IPrintXML)object).printAsSGML(printWriter, n + 1, bl);
                object = object.getNextSibling();
            }
        }
        object = ((SGMLDocument)this.getOwnerDocument()).getDTD();
        ElementDefinition elementDefinition = null;
        if (object != null) {
            elementDefinition = ((SGMLDocTypeDef)object).getElementDefinition(this.tagName);
        }
        if (n2 != 0 || elementDefinition == null || elementDefinition.getContentModel() != SGMLParser.empty) {
            if (bl && (this.getLastChild() == null || this.getLastChild().getNodeType() != 3 && this.getLastChild().getNodeType() != 4)) {
                printWriter.println();
                int n3 = n;
                while (n3 > 0) {
                    printWriter.print(' ');
                    --n3;
                }
            }
            printWriter.print("</" + this.getTagName() + '>');
        }
    }

    public Node cloneNode(boolean bl) {
        SGMLElement sGMLElement = (SGMLElement)super.cloneNode(bl);
        SGMLAttribute[] sGMLAttributeArray = new SGMLAttribute[this.attributes.length];
        int n = this.attrNum - 1;
        while (n >= 0) {
            sGMLAttributeArray[n] = (SGMLAttribute)this.attributes[n].cloneNode(false);
            sGMLAttributeArray[n].setOwnerElement(sGMLElement);
            --n;
        }
        sGMLElement.attributes = sGMLAttributeArray;
        return sGMLElement;
    }

    public String getAttributeNS(String string, String string2) {
        return this.getAttribute(string2);
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.setAttribute(string2, string3);
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.removeAttribute(string2);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        return this.getAttributeNode(string2);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        return this.setAttributeNode(attr);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return this.getElementsByTagName(string2);
    }

    public boolean hasAttribute(String string) {
        int n = this.attrNum - 1;
        while (n >= 0) {
            SGMLAttribute sGMLAttribute = this.attributes[n];
            if (sGMLAttribute.getNodeName().equalsIgnoreCase(string)) {
                return true;
            }
            --n;
        }
        return this.getDefaultValue(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.hasAttribute(string2);
    }

    public boolean hasAttributes() {
        return this.attrNum > 0;
    }

    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    public void setIdAttribute(String string, boolean bl) throws DOMException {
        this.processIdForOptimization(this);
    }

    public void setIdAttributeNS(String string, String string2, boolean bl) throws DOMException {
        this.processIdForOptimization(this);
    }

    public void setIdAttributeNode(Attr attr, boolean bl) throws DOMException {
        this.processIdForOptimization(this);
    }
}

