/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.internal;

import java.util.GregorianCalendar;

public class TimeHelper {
    private static long lastMillis;
    private static String lastTimeStamp;

    public static String getFormattedCurrentTime() {
        long millis = System.currentTimeMillis();
        if (millis - lastMillis >= 1000L) {
            lastMillis = millis;
            GregorianCalendar cal = new GregorianCalendar();
            lastTimeStamp = String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", cal);
        }
        return lastTimeStamp;
    }

    public static String formatDuration(long duration) {
        long durationInSeconds = duration / 1000L;
        if (duration % 1000L >= 500L) {
            ++durationInSeconds;
        }
        long seconds = durationInSeconds % 60L;
        long minutes = durationInSeconds / 60L;
        String minute = minutes == 1L ? "minute" : "minutes";
        String second = seconds == 1L ? "second" : "seconds";
        String formatted = null;
        formatted = minutes > 0L ? String.format("%1$d %2$s %3$02d %4$s", minutes, minute, seconds, second) : String.format("%1$d %2$s", seconds, second);
        return formatted;
    }

    public static String formatDetailedDuration(long duration) {
        StringBuilder builder = new StringBuilder();
        long milliseconds = duration % 1000L;
        long allSeconds = duration / 1000L;
        long seconds = allSeconds % 60L;
        long allMinutes = allSeconds / 60L;
        long minutes = allMinutes % 60L;
        long hours = allMinutes / 60L;
        if (hours > 0L) {
            builder.append(hours);
            builder.append(hours == 1L ? " hour " : " hours ");
        }
        if (minutes > 0L) {
            builder.append(minutes);
            builder.append(minutes == 1L ? " minute " : " minutes ");
        }
        if (seconds > 0L) {
            builder.append(seconds);
            builder.append(seconds == 1L ? " second " : " seconds ");
        }
        if (milliseconds > 0L) {
            builder.append(milliseconds);
            builder.append(milliseconds == 1L ? " millisecond" : " milliseconds");
        }
        return builder.toString().trim();
    }
}

