/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.HashMap;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeRegister;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IRegisters;

public class TCFChildrenRegisters
extends TCFChildren {
    TCFChildrenRegisters(TCFNode node) {
        super(node, 128);
    }

    void onSuspended(boolean func_call) {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeRegister)n).onSuspended(func_call);
        }
    }

    void onParentValueChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeRegister)n).onParentValueChanged();
        }
    }

    void onRegistersChanged() {
        for (TCFNode n : this.getNodes()) {
            ((TCFNodeRegister)n).onRegistersChanged();
        }
        this.reset();
    }

    @Override
    void onNodeDisposed(String id) {
        super.onNodeDisposed(id);
        if (this.node instanceof TCFNodeExecContext) {
            for (TCFNode n : ((TCFNodeExecContext)this.node).getStackTrace().getNodes()) {
                ((TCFNodeStackFrame)n).getRegisters().onNodeDisposed(id);
            }
        }
    }

    protected boolean startDataRetrieval() {
        IRegisters regs = (IRegisters)this.node.model.getLaunch().getService(IRegisters.class);
        if (regs == null) {
            this.set(null, null, new HashMap<String, TCFNode>());
            return true;
        }
        if (this.node instanceof TCFNodeStackFrame) {
            TCFChildrenStackTrace stack_trace_cache = ((TCFNodeExecContext)this.node.parent).getStackTrace();
            if (!stack_trace_cache.validate((Runnable)((Object)this))) {
                return false;
            }
            int frame_no = ((TCFNodeStackFrame)this.node).getFrameNo();
            if (frame_no < 0) {
                this.set(null, null, new HashMap<String, TCFNode>());
                return true;
            }
        }
        assert (this.command == null);
        this.command = regs.getChildren(this.node.id, new IRegisters.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] contexts) {
                HashMap<String, TCFNodeRegister> data = null;
                if (TCFChildrenRegisters.this.command == token && error == null) {
                    int index = 0;
                    data = new HashMap<String, TCFNodeRegister>();
                    String[] stringArray = contexts;
                    int n = contexts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        TCFNodeRegister n3 = (TCFNodeRegister)TCFChildrenRegisters.this.node.model.getNode(id);
                        if (n3 == null) {
                            n3 = new TCFNodeRegister(TCFChildrenRegisters.this.node, id);
                        }
                        n3.setIndex(index++);
                        data.put(id, n3);
                        ++n2;
                    }
                }
                TCFChildrenRegisters.this.set(token, (Throwable)error, data);
            }
        });
        return false;
    }
}

