/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.IBarSeries;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.ICustomPaintListener;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.IPlotArea;
import org.eclipse.swtchart.ISeriesSet;
import org.eclipse.swtchart.internal.Grid;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.internal.series.SeriesSet;

public class PlotArea
extends Composite
implements PaintListener,
IPlotArea {
    private Chart chart;
    private List<ICustomPaintListener> paintListeners;
    private DisposeListener disposeListener;
    private Image image = null;
    private int imagePositionX = 0;
    private int imagePositionY = 0;
    private String text = "";
    private Font fontText = Display.getDefault().getSystemFont();
    private Color colorText = Display.getDefault().getSystemColor(2);
    private int textPositionX = 0;
    private int textPositionY = 0;
    private boolean buffered = false;

    public PlotArea(Chart chart, int style) {
        super((Composite)chart, style | 0x40000 | 0x20000000);
        this.chart = chart;
        this.paintListeners = new ArrayList<ICustomPaintListener>();
        this.addPaintListener(this);
        this.disposeListener = e -> this.dispose();
        this.setData("org.eclipse.e4.ui.css.CssClassName", "PlotArea");
        chart.addDisposeListener(this.disposeListener);
        chart.setPlotArea(this);
    }

    public void dispose() {
        this.chart.removeDisposeListener(this.disposeListener);
        super.dispose();
    }

    @Override
    public Chart getChart() {
        return this.chart;
    }

    @Deprecated
    public ISeriesSet getSeriesSet() {
        return this.chart.getSeriesSet();
    }

    @Override
    public Control getControl() {
        return this;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        ((SeriesSet)this.getSeriesSet()).compressAllSeries();
    }

    @Override
    public void setBackgroundImage(Image image) {
        this.setBackgroundImage(image, 0, 0);
    }

    @Override
    public void setBackgroundImage(Image image, int x, int y) {
        this.image = image;
        this.imagePositionX = x;
        this.imagePositionY = y;
    }

    @Override
    public void setBackgroundText(String text, Font font, Color color) {
        this.setBackgroundText(text, font, color, 0, 0);
    }

    @Override
    public void setBackgroundText(String text, Font font, Color color, int x, int y) {
        this.text = text != null ? text : "";
        this.fontText = font != null ? font : Display.getDefault().getSystemFont();
        this.colorText = color != null ? color : Display.getDefault().getSystemColor(2);
        this.textPositionX = x;
        this.textPositionY = y;
    }

    @Override
    public void addCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.add(listener);
    }

    @Override
    public void removeCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.remove(listener);
    }

    @Override
    public List<ICustomPaintListener> getCustomPaintListener() {
        return Collections.unmodifiableList(this.paintListeners);
    }

    public void paintControl(PaintEvent e) {
        Point sizePlotArea = this.getSize();
        GC gc = e.gc;
        Color oldBackground = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(0, 0, sizePlotArea.x, sizePlotArea.y);
        Font fontDefault = gc.getFont();
        Color colorDefault = gc.getForeground();
        gc.setFont(this.fontText);
        gc.setForeground(this.colorText);
        if (this.image != null) {
            int offsetY = this.drawImage(gc, sizePlotArea, this.image, this.imagePositionX, this.imagePositionY);
            this.drawText(gc, sizePlotArea, this.text, this.textPositionX, this.textPositionY, offsetY);
        } else {
            this.drawText(gc, sizePlotArea, this.text, this.textPositionX, this.textPositionY, 0);
        }
        gc.setForeground(colorDefault);
        gc.setFont(fontDefault);
        Object[] objectArray = this.chart.getAxisSet().getAxes();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = objectArray[n2];
            ((Grid)axis.getGrid()).draw(gc, sizePlotArea.x, sizePlotArea.y);
            ++n2;
        }
        for (ICustomPaintListener listener : this.paintListeners) {
            if (!listener.drawBehindSeries()) continue;
            listener.paintControl(e);
        }
        objectArray = this.chart.getSeriesSet().getSeries();
        n = objectArray.length;
        int n3 = 0;
        while (n3 < n) {
            Object series = objectArray[n3];
            if (series instanceof IBarSeries) {
                ((Series)series).draw(gc, sizePlotArea.x, sizePlotArea.y);
            }
            ++n3;
        }
        objectArray = this.chart.getSeriesSet().getSeries();
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            Object series = objectArray[n3];
            if (series instanceof ILineSeries) {
                ((Series)series).draw(gc, sizePlotArea.x, sizePlotArea.y);
            }
            ++n3;
        }
        objectArray = this.chart.getSeriesSet().getSeries();
        n = objectArray.length;
        n3 = 0;
        while (n3 < n) {
            Object series = objectArray[n3];
            if (series instanceof ICircularSeries) {
                ((Series)series).draw(gc, sizePlotArea.x, sizePlotArea.y);
            }
            ++n3;
        }
        for (ICustomPaintListener listener : this.paintListeners) {
            if (listener.drawBehindSeries()) continue;
            listener.paintControl(e);
        }
        e.gc.setBackground(oldBackground);
    }

    @Override
    public ImageData getImageData() {
        ImageData imageData = null;
        Point chartSize = this.getSize();
        Image image = null;
        GC gc = null;
        try {
            image = new Image((Device)this.getDisplay(), new ImageData(chartSize.x, chartSize.y, 32, new PaletteData(255, 65280, 0xFF0000)));
            gc = new GC((Drawable)this);
            gc.copyArea(image, 0, 0);
            imageData = image.getImageData();
        }
        finally {
            if (gc != null && !gc.isDisposed()) {
                gc.dispose();
            }
            if (image != null && !image.isDisposed()) {
                image.dispose();
            }
        }
        return imageData;
    }

    @Override
    public boolean isBuffered() {
        return this.buffered;
    }

    @Override
    public void setBuffered(boolean buffered) {
        this.buffered = buffered;
    }

    private int drawImage(GC gc, Point sizePlotArea, Image image, int imagePositionX, int imagePositionY) {
        Rectangle rectangle = image.getBounds();
        int x = imagePositionX;
        int y = imagePositionY;
        int offset = rectangle.height;
        if (imagePositionX == -1 && imagePositionY == -1) {
            x = (int)((double)sizePlotArea.x / 2.0 - (double)rectangle.width / 2.0);
            y = (int)((double)sizePlotArea.y / 2.0 - (double)rectangle.height / 2.0);
            offset = (int)((double)rectangle.height / 2.0);
        }
        gc.drawImage(image, x, y);
        return offset;
    }

    private void drawText(GC gc, Point sizePlotArea, String text, int textPositionX, int textPositionY, int offsetY) {
        if (!text.isEmpty()) {
            int x = textPositionX;
            int y = textPositionY;
            Point sizeText = gc.textExtent(text);
            if (textPositionX == -1 && textPositionY == -1) {
                x = (int)((double)sizePlotArea.x / 2.0 - (double)sizeText.x / 2.0);
                y = (int)((double)sizePlotArea.y / 2.0 - (double)sizeText.y);
            }
            if (offsetY != 0) {
                y += offsetY;
                y = (int)((double)y + (double)sizeText.y * 1.5);
            }
            gc.drawString(text, x, y);
        }
    }
}

