/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.viewport.ui.action;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.NatTableLayerDim;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerDim;
import org.eclipse.statet.ecommons.waltable.selection.ui.action.SelectCellAction;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportSelectDimPositionsCommand;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.swt.events.MouseEvent;

@NonNullByDefault
public class ViewportSelectDimPositionsAction
implements IMouseAction {
    private final Orientation orientation;

    public ViewportSelectDimPositionsAction(Orientation orientation) {
        this.orientation = orientation;
    }

    @Override
    public void run(NatTable natTable, MouseEvent event) {
        LayerCell cell = natTable.getCellByPosition(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
        if (cell == null) {
            return;
        }
        NatTableLayerDim layerDim = natTable.getDim(this.orientation);
        LayerCellDim cellDim = cell.getDim(this.orientation);
        if (cellDim.getPositionSpan() > 1L) {
            ImList positions = ImCollections.newList((Object)new LRange(cellDim.getOriginPosition(), cellDim.getOriginPosition() + cellDim.getPositionSpan()));
            natTable.doCommand(new ViewportSelectDimPositionsCommand(layerDim, cellDim.getPosition(), (Collection<LRange>)positions, cellDim.getPosition(), SelectCellAction.swt2Flags(event.stateMask)));
        } else {
            natTable.doCommand(new ViewportSelectDimPositionsCommand((LayerDim)layerDim, cellDim.getPosition(), SelectCellAction.swt2Flags(event.stateMask)));
        }
    }
}

