/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GraphicsUtils {
    public static final int safe(long pixel) {
        return pixel <= Integer.MIN_VALUE ? Integer.MIN_VALUE : (pixel >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pixel);
    }

    public static final Rectangle safe(long x, long y, long width, long height) {
        int sx = GraphicsUtils.safe(x);
        int sy = GraphicsUtils.safe(y);
        return new Rectangle(sx, sy, GraphicsUtils.safe(x + width) - sx, GraphicsUtils.safe(y + height) - sy);
    }

    public static final Rectangle safe(LRectangle rect) {
        return GraphicsUtils.safe(rect.x, rect.y, rect.width, rect.height);
    }

    public static void drawVerticalText(String string, int x, int y, GC gc, int style) {
        GraphicsUtils.drawVerticalText(string, x, y, false, false, true, gc, style);
    }

    public static void drawVerticalText(String string, int x, int y, boolean underline, boolean strikethrough, boolean paintBackground, GC gc, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        Point pt = gc.textExtent(string.trim());
        Image stringImage = new Image((Device)display, pt.x, pt.y);
        try {
            GC gc0 = new GC((Drawable)stringImage);
            try {
                gc0.setAntialias(gc.getAntialias());
                gc0.setTextAntialias(gc.getTextAntialias());
                gc0.setForeground(gc.getForeground());
                gc0.setBackground(gc.getBackground());
                gc0.setFont(gc.getFont());
                gc0.fillRectangle(0, 0, pt.x, pt.y);
                gc0.drawText(string, 0, 0);
                if (underline || strikethrough) {
                    if (underline) {
                        int underlineY = pt.y - gc0.getFontMetrics().getDescent() / 2;
                        gc0.drawLine(0, underlineY, pt.x, underlineY);
                    }
                    if (strikethrough) {
                        int strikeY = pt.y / 2 + gc0.getFontMetrics().getLeading() / 2;
                        gc0.drawLine(0, strikeY, pt.x, strikeY);
                    }
                }
            }
            finally {
                gc0.dispose();
            }
            GraphicsUtils.drawVerticalImage(stringImage, x, y, paintBackground, gc, style);
        }
        finally {
            stringImage.dispose();
        }
    }

    public static void drawVerticalImage(Image image, int x, int y, GC gc, int style) {
        GraphicsUtils.drawVerticalImage(image, x, y, true, gc, style);
    }

    public static void drawVerticalImage(Image image, int x, int y, boolean paintBackground, GC gc, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        dd.transparentPixel = sd.transparentPixel;
        if (!paintBackground) {
            dd.transparentPixel = sd.palette.getPixel(gc.getBackground().getRGB());
        }
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        Image vertical = new Image((Device)display, dd);
        gc.drawImage(vertical, x, y);
        vertical.dispose();
    }

    public static Image createRotatedText(String text, Font font, Color foreground, Color background, int style) {
        Point size;
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        GC gc = new GC((Drawable)display);
        try {
            gc.setFont(font);
            size = gc.textExtent(text);
        }
        finally {
            gc.dispose();
        }
        Image stringImage = new Image((Device)display, size.x, size.y);
        try {
            GC gc0 = new GC((Drawable)stringImage);
            try {
                gc0.setFont(font);
                gc0.setForeground(foreground);
                gc0.setBackground(background);
                gc0.drawText(text, 0, 0);
            }
            finally {
                gc0.dispose();
            }
            Image image = GraphicsUtils.createRotatedImage(stringImage, style);
            return image;
        }
        finally {
            stringImage.dispose();
        }
    }

    public static Image createRotatedImage(Image image, int style) {
        Display display = Display.getCurrent();
        if (display == null) {
            SWT.error((int)22);
        }
        ImageData sd = image.getImageData();
        ImageData dd = new ImageData(sd.height, sd.width, sd.depth, sd.palette);
        boolean up = (style & 0x80) == 128;
        int sx = 0;
        while (sx < sd.width) {
            int sy = 0;
            while (sy < sd.height) {
                int dx = up ? sy : sd.height - sy - 1;
                int dy = up ? sd.width - sx - 1 : sx;
                dd.setPixel(dx, dy, sd.getPixel(sx, sy));
                ++sy;
            }
            ++sx;
        }
        return new Image((Device)display, dd);
    }
}

